/*
 * Decompiled with CFR 0.152.
 */
package sanjay.common;

import java.awt.Color;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

public class RadialPaint
implements Paint,
PaintContext {
    Color c1;
    Color c2;
    Point centre;
    int fallof;
    BufferedImage im = null;
    ColorModel cm = ColorModel.getRGBdefault();
    Rectangle b;

    public RadialPaint(Color c1, Color c2, Point centre, int fallof) {
        this.c1 = c1;
        this.c2 = c2;
        this.centre = centre;
        this.fallof = fallof;
    }

    public void dispose() {
        this.im = null;
    }

    public ColorModel getColorModel() {
        return this.cm;
    }

    public Raster getRaster(int x, int y, int w, int h) {
        WritableRaster r = this.im.getRaster();
        Raster rr = r.createChild(x - this.b.x, y - this.b.y, w, h, this.b.x, this.b.y, null);
        return rr;
    }

    public PaintContext createContext(ColorModel cm, Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform xform, RenderingHints hints) {
        int x = deviceBounds.x;
        int y = deviceBounds.y;
        int w = deviceBounds.width;
        int h = deviceBounds.height;
        this.b = deviceBounds;
        this.im = new BufferedImage(w, h, 2);
        WritableRaster r = this.im.getRaster();
        int i = 0;
        while (i < w) {
            int j = 0;
            while (j < h) {
                double f = Math.min(this.centre.distance(i + x, j + y) / (double)this.fallof, 1.0);
                r.setPixel(i, j, new int[]{(int)((double)this.c1.getRed() * (1.0 - f) + (double)this.c2.getRed() * f), (int)((double)this.c1.getGreen() * (1.0 - f) + (double)this.c2.getGreen() * f), (int)((double)this.c1.getBlue() * (1.0 - f) + (double)this.c2.getBlue() * f), 255});
                ++j;
            }
            ++i;
        }
        return this;
    }

    public int getTransparency() {
        return 1;
    }
}

