/*
 * Decompiled with CFR 0.152.
 */
package sanjay;

import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class PlafMenu
extends JMenu {
    Component component;

    public PlafMenu(Component component) {
        super("Look and Feel");
        this.component = component;
        UIManager.LookAndFeelInfo[] li = UIManager.getInstalledLookAndFeels();
        int i = 0;
        while (i < li.length) {
            this.add(new PlafAction(li[i]));
            if (li[i].getName().equals("Skin look and feel")) {
                this.addSkinMenu(li[i].getClassName());
            }
            ++i;
        }
        JFrame.setDefaultLookAndFeelDecorated(true);
        this.add(new WrapAction());
    }

    public void updateInterface() {
        Component x = this;
        while (x.getParent() != null) {
            x = x.getParent();
        }
        SwingUtilities.updateComponentTreeUI(x);
        x = this.component;
        while (x.getParent() != null) {
            x = x.getParent();
        }
        SwingUtilities.updateComponentTreeUI(x);
        x.repaint();
    }

    void addSkinMenu(String cls) {
        try {
            Class<?> c = Class.forName("sanjay.SkinSelect");
            final Object o = c.newInstance();
            this.add(new JMenuItem(new AbstractAction("Select skin"){

                public void actionPerformed(ActionEvent e) {
                    ((Runnable)o).run();
                    PlafMenu.this.updateInterface();
                }
            }));
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    class PlafAction
    extends AbstractAction {
        UIManager.LookAndFeelInfo inf;

        PlafAction(UIManager.LookAndFeelInfo inf) {
            super(inf.getName());
            this.inf = inf;
        }

        public void actionPerformed(ActionEvent e) {
            try {
                UIManager.setLookAndFeel(this.inf.getClassName());
                Component x = PlafMenu.this;
                while (x.getParent() != null) {
                    x = x.getParent();
                }
                SwingUtilities.updateComponentTreeUI(x);
                x = PlafMenu.this.component;
                while (x.getParent() != null) {
                    x = x.getParent();
                }
                SwingUtilities.updateComponentTreeUI(x);
                x.repaint();
            }
            catch (Exception x) {
                x.printStackTrace();
                JOptionPane.showMessageDialog(null, x.toString(), "Error changing look and feel to " + e.getActionCommand(), 0);
            }
        }
    }

    class WrapAction
    extends AbstractAction {
        WrapAction() {
            super("Anti-Aliasing");
        }

        public void actionPerformed(ActionEvent e) {
            try {
                Class.forName("com.l2fprod.common.swing.plaf.wrap.Wrapper").getMethod("wrap", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }
}

