/*
 * Decompiled with CFR 0.152.
 */
package sanjay;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.text.NumberFormat;
import javax.swing.JLabel;
import javax.swing.JScrollBar;
import sanjay.DisplayPanel;
import sanjay.TLeaf;

class NumberModify
extends DisplayPanel
implements AdjustmentListener {
    TLeaf leaf;
    NumberFormat nf = NumberFormat.getInstance();
    JLabel label = new JLabel();
    JScrollBar scroll = new JScrollBar(0, 50, 10, 0, 100);
    boolean ignoreEvent = false;

    public void setLeaf(TLeaf l) {
        this.leaf = l;
        this.updateDisplay();
    }

    public void updateDisplay() {
        double val = ((Number)this.leaf.get()).doubleValue();
        this.label.setText(String.valueOf(val));
    }

    NumberModify() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.label, "Center");
        this.add((Component)this.scroll, "East");
        this.scroll.addAdjustmentListener(this);
        this.nf.setMaximumFractionDigits(2);
        this.nf.setMaximumIntegerDigits(2);
    }

    public synchronized void adjustmentValueChanged(AdjustmentEvent e) {
        if (!this.ignoreEvent) {
            double prev;
            this.ignoreEvent = true;
            int delta = this.scroll.getValue() - 50;
            this.scroll.setValue(50);
            this.ignoreEvent = false;
            double val = prev = ((Number)this.leaf.get()).doubleValue();
            if (val < 0.0) {
                val = Math.abs(val);
            }
            if (val == 0.0) {
                val = 0.1;
            }
            double decade = Math.floor(Math.log(val) / Math.log(10.0)) - 1.0;
            double increment = Math.pow(10.0, decade);
            double next = prev + increment * (double)delta;
            long round = Math.round(next / increment);
            next = (double)round * increment;
            this.leaf.setNumeric(next);
            this.fireChange();
            this.updateDisplay();
        }
    }
}

