/*
 * Decompiled with CFR 0.152.
 */
package phic.modifiable;

import evaluator.ParseException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import phic.modifiable.Script;
import phic.modifiable.ScriptViewPanel_compilebutton_actionAdapter;

public class ScriptViewPanel
extends JPanel {
    Script script;
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanel2 = new JPanel();
    JPanel jPanel1 = new JPanel();
    JLabel jLabel1 = new JLabel();
    public JTextField nametxt = new JTextField();
    BorderLayout borderLayout2 = new BorderLayout();
    JPanel jPanel3 = new JPanel();
    JPanel jPanel4 = new JPanel();
    JLabel jLabel2 = new JLabel();
    JScrollPane jScrollPane1 = new JScrollPane();
    BorderLayout borderLayout3 = new BorderLayout();
    JPanel jPanel5 = new JPanel();
    JScrollPane jScrollPane2 = new JScrollPane();
    JCheckBox continuouscheck = new JCheckBox();
    JTextField intervaltxt = new JTextField();
    JLabel jLabel3 = new JLabel();
    Component component1;
    BorderLayout borderLayout4 = new BorderLayout();
    BorderLayout borderLayout5 = new BorderLayout();
    Border border1;
    Border border2;
    Border border3;
    JPanel jPanel6 = new JPanel();
    JButton compilebutton = new JButton();
    JLabel compiletxt = new JLabel();
    Border border4;
    BorderLayout borderLayout6 = new BorderLayout();
    JTextArea desctxt = new JTextArea();
    JTextArea bodytxt = new JTextArea();

    public ScriptViewPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setScript(null);
    }

    private void jbInit() throws Exception {
        this.component1 = Box.createHorizontalStrut(8);
        this.border1 = BorderFactory.createEmptyBorder(4, 4, 4, 4);
        this.border2 = BorderFactory.createEmptyBorder(4, 4, 4, 4);
        this.border3 = BorderFactory.createEmptyBorder(4, 4, 4, 4);
        this.border4 = BorderFactory.createBevelBorder(1);
        this.setLayout(this.borderLayout1);
        this.jLabel1.setToolTipText("");
        this.jLabel1.setText("Script Name");
        this.nametxt.setToolTipText("Enter the name for the script");
        this.nametxt.setText("Script1");
        this.nametxt.setColumns(15);
        this.nametxt.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                ScriptViewPanel.this.nametxt_focusLost(e);
            }
        });
        this.jPanel1.setLayout(this.borderLayout2);
        this.jLabel2.setText("Description");
        this.jScrollPane1.setHorizontalScrollBarPolicy(31);
        this.jScrollPane1.setVerticalScrollBarPolicy(20);
        this.jScrollPane1.setPreferredSize(new Dimension(130, 100));
        this.jPanel2.setLayout(this.borderLayout3);
        this.continuouscheck.setToolTipText("Whether the script runs as a continuous, time-dependent process");
        this.continuouscheck.setText("Continuous");
        this.intervaltxt.setToolTipText("If the script runs as a continuous process, this specifies how often (in seconds) the script is executed");
        this.intervaltxt.setColumns(8);
        this.intervaltxt.setText("0.100");
        this.intervaltxt.setSelectionStart(5);
        this.jLabel3.setText("Interval");
        this.jPanel4.setLayout(this.borderLayout4);
        this.jPanel3.setBorder(this.border1);
        this.jPanel3.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.jPanel3.setLayout(this.borderLayout5);
        this.borderLayout5.setHgap(4);
        this.borderLayout5.setVgap(4);
        this.jPanel4.setBorder(this.border2);
        this.borderLayout4.setHgap(4);
        this.borderLayout4.setVgap(4);
        this.jPanel2.setBorder(this.border3);
        this.compilebutton.setToolTipText("Attempt to compile the script body. If errors occur, they are shown to the right");
        this.compilebutton.setText("Compile");
        this.compilebutton.addActionListener(new ScriptViewPanel_compilebutton_actionAdapter(this));
        this.compiletxt.setBorder(this.border4);
        this.compiletxt.setPreferredSize(new Dimension(150, 25));
        this.compiletxt.setToolTipText("Messages from the script compiler");
        this.compiletxt.setText("");
        this.jPanel6.setLayout(this.borderLayout6);
        this.desctxt.setFont(new Font("Dialog", 0, 10));
        this.desctxt.setToolTipText("Type a description of the function here");
        this.desctxt.setText("");
        this.desctxt.setLineWrap(true);
        this.desctxt.setWrapStyleWord(true);
        this.setToolTipText("");
        this.bodytxt.setToolTipText("Type the body for the script here");
        this.bodytxt.setText("");
        this.bodytxt.setLineWrap(true);
        this.bodytxt.setWrapStyleWord(true);
        this.add((Component)this.jPanel2, "Center");
        this.jPanel2.add((Component)this.jPanel5, "North");
        this.jPanel5.add((Component)this.continuouscheck, null);
        this.jPanel5.add(this.component1, null);
        this.jPanel5.add((Component)this.jLabel3, null);
        this.jPanel5.add((Component)this.intervaltxt, null);
        this.jPanel2.add((Component)this.jScrollPane2, "Center");
        this.jScrollPane2.getViewport().add((Component)this.bodytxt, null);
        this.jPanel2.add((Component)this.jPanel6, "South");
        this.jPanel6.add((Component)this.compilebutton, "West");
        this.jPanel6.add((Component)this.compiletxt, "Center");
        this.add((Component)this.jPanel1, "North");
        this.jPanel1.add((Component)this.jPanel3, "North");
        this.jPanel3.add((Component)this.jLabel1, "West");
        this.jPanel3.add((Component)this.nametxt, "Center");
        this.jPanel1.add((Component)this.jPanel4, "Center");
        this.jPanel4.add((Component)this.jLabel2, "West");
        this.jPanel4.add((Component)this.jScrollPane1, "Center");
        this.jScrollPane1.getViewport().add((Component)this.desctxt, null);
    }

    public Script getScript() {
        return this.script;
    }

    public void setScript(Script script) {
        this.script = script;
        if (script != null) {
            this.nametxt.setText(script.name);
            this.desctxt.setText(script.description);
            this.continuouscheck.setSelected(script.isContinuous());
            this.intervaltxt.setText(String.valueOf(script.getExecutionInterval()));
            this.bodytxt.setText(script.getText());
            this.nametxt.setEnabled(true);
            this.desctxt.setEnabled(true);
            this.intervaltxt.setEnabled(true);
            this.bodytxt.setEnabled(true);
        } else {
            this.nametxt.setText("");
            this.desctxt.setText("");
            this.intervaltxt.setText("");
            this.bodytxt.setText("");
            this.nametxt.setEnabled(false);
            this.desctxt.setEnabled(false);
            this.intervaltxt.setEnabled(false);
            this.bodytxt.setEnabled(false);
        }
    }

    public void updateScriptFromInput() {
        this.script.name = this.nametxt.getText();
        this.script.description = this.desctxt.getText().replace('\n', ' ');
        this.script.setContinuous(this.continuouscheck.isSelected());
        this.script.setExecutionInterval(Double.parseDouble(this.intervaltxt.getText()));
    }

    void compilebutton_actionPerformed(ActionEvent e) {
        if (this.script == null) {
            this.compiletxt.setText("No script selected.");
            return;
        }
        this.updateScriptFromInput();
        boolean error = false;
        try {
            this.script.setText(this.bodytxt.getText());
        }
        catch (ParseException x) {
            this.compiletxt.setText(x.toString());
            this.compiletxt.setToolTipText(x.toString());
            error = true;
        }
        if (!error) {
            this.compiletxt.setText("Successful");
            this.compiletxt.setToolTipText("The last compile completed with no errors");
        }
    }

    void nametxt_focusLost(FocusEvent e) {
        this.updateScriptFromInput();
    }
}

