/*
 * Decompiled with CFR 0.152.
 */
package phic.modifiable;

import evaluator.MathException;
import evaluator.ParseException;
import evaluator.StackException;
import evaluator.Statement;
import evaluator.Variable;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Vector;
import phic.Current;
import phic.common.Ticker;

public class Script
implements Ticker,
Serializable {
    public String name = "Script" + serial++;
    private static int serial = 0;
    public String description = "";
    private double executionInterval = 1.0;
    private boolean continuous = false;
    Vector statements = new Vector();
    protected double totalElapsedSinceExecute = 0.0;

    public Script() {
    }

    public Script(String name, String description, String expr, boolean continuous) {
        this.name = name;
        this.description = description;
        this.setText(expr);
        this.setContinuous(continuous);
    }

    public double getExecutionInterval() {
        return this.executionInterval;
    }

    public void setExecutionInterval(double executionInterval) {
        this.executionInterval = executionInterval;
    }

    public void setContinuous(boolean c) {
        if (c && !this.continuous) {
            Current.body.getClock().addTicker(this);
        } else if (!c) {
            Current.body.getClock().removeTicker(this);
        }
        this.continuous = c;
    }

    public boolean isContinuous() {
        return this.continuous;
    }

    public Statement[] getStatements() {
        return this.statements.toArray(new Statement[this.statements.size()]);
    }

    public String getText() {
        String s = "";
        int i = 0;
        while (i < this.statements.size()) {
            if (i > 0) {
                s = String.valueOf(s) + "; ";
            }
            s = String.valueOf(s) + ((Statement)this.statements.get(i)).getDefinition();
            ++i;
        }
        return s;
    }

    public void setText(String text) throws ParseException {
        Vector<Statement> newStatements = new Vector<Statement>();
        Variable.set("elapsedTime", new Double(0.0));
        int i = 0;
        while (i < text.length()) {
            String t;
            int j = text.indexOf(59, i);
            if (j < 0) {
                j = text.length();
            }
            if ((t = text.substring(i, j).trim()).length() > 0) {
                newStatements.add(new Statement(t));
            }
            i = j + 1;
        }
        this.statements = newStatements;
    }

    public void tick(double elapsedTime) {
        try {
            this.executeScript(elapsedTime);
        }
        catch (Exception e) {
            this.setContinuous(false);
            e.printStackTrace();
            Current.body.message("Script " + this.name + " terminated because of " + e.getMessage());
        }
    }

    public final void executeScript(double elapsedTime) throws MathException, StackException {
        if (this.executionInterval > 0.0) {
            this.totalElapsedSinceExecute += elapsedTime;
            while (this.totalElapsedSinceExecute >= this.executionInterval) {
                this.totalElapsedSinceExecute -= this.executionInterval;
                Variable.set("elapsedTime", new Double(this.executionInterval));
                this.executeOnce();
            }
        } else {
            Variable.set("elapsedTime", new Double(elapsedTime));
            this.executeOnce();
        }
    }

    public final Object executeOnce() throws MathException, StackException {
        Object result = null;
        int i = 0;
        while (i < this.statements.size()) {
            result = ((Statement)this.statements.get(i)).evaluate();
            ++i;
        }
        if (result == null) {
            return "null";
        }
        return result.toString();
    }

    public String toString() {
        return this.name;
    }

    public static void executeScriptFromStream(InputStream s, String stopsymbol) throws IOException, InvocationTargetException {
        if (stopsymbol == null) {
            stopsymbol = "// End of file";
        }
        BufferedReader r = new BufferedReader(new InputStreamReader(s));
        Script sc = new Script();
        String q = r.readLine();
        int l = 0;
        while (q != null && !q.trim().startsWith(stopsymbol)) {
            ++l;
            int k = q.indexOf("//");
            if (k >= 0) {
                q = q.substring(0, k);
            }
            if ((k = q.indexOf("#")) >= 0) {
                q = q.substring(0, k);
            }
            if ((q = q.trim()).length() > 0) {
                sc.setText(q);
                try {
                    sc.executeOnce();
                }
                catch (Exception m) {
                    throw new InvocationTargetException(m, "Error in script at line " + l + ": " + q);
                }
            }
            q = r.readLine();
        }
    }

    public Script(String[] s) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < s.length) {
            String st;
            if (s[i] != null && !(st = s[i].trim()).equals("") && !st.equals(";")) {
                sb.append(st);
                if (!st.endsWith(";")) {
                    sb.append(";");
                }
            }
            ++i;
        }
        this.setText(sb.toString());
    }
}

