/*
 * Decompiled with CFR 0.152.
 */
package phic.modifiable;

import phic.gui.VisibleVariable;

public class Range {
    public double minimum = 0.0;
    public double maximum = 1.0;
    protected static final double[] decades = new double[]{0.1, 0.15, 0.2, 0.25, 0.3, 0.35, 0.4, 0.45, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0};
    protected static final double[] triads = new double[]{0.2, 0.5, 1.0};
    public static final int ZOOM_IN = 0;
    public static final int ZOOM_NORMAL = 1;
    public static final int ZOOM_OUT = 2;
    public static final int ZOOM_VARIABLE_RANGE = 3;
    public static final int[] ZOOM_RANGES;

    static {
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 2;
        ZOOM_RANGES = nArray;
    }

    public Range() {
    }

    public Range(double minimum, double maximum) {
        this.set(minimum, maximum);
    }

    public void set(double minimum, double maximum) {
        this.maximum = Math.max(maximum, minimum);
        this.minimum = Math.min(minimum, maximum);
    }

    public final double getSpan() {
        return this.maximum - this.minimum;
    }

    public double convertValueTo(Range newRange, double value) {
        return (value - this.minimum) * newRange.getSpan() / this.getSpan() + newRange.minimum;
    }

    public void include(double a) {
        this.maximum = Math.max(a, this.maximum);
        this.minimum = Math.min(a, this.minimum);
    }

    public void include(double a, double b) {
        this.maximum = Math.max(a, Math.max(b, this.maximum));
        this.minimum = Math.min(b, Math.min(a, this.minimum));
    }

    public void include(Range r) {
        if (r == null) {
            return;
        }
        this.maximum = Math.max(r.maximum, Math.max(r.minimum, this.maximum));
        this.minimum = Math.min(r.minimum, Math.min(r.maximum, this.minimum));
    }

    public static Range findRange(double value, int zoomRange) {
        Range newRange = new Range();
        boolean negative = value < 0.0;
        if ((value = Math.abs(value)) == 0.0) {
            value = 0.001;
        }
        double decade = Math.pow(10.0, 1 + (int)Math.floor(Math.log(value) / Math.log(10.0)));
        switch (zoomRange) {
            case 2: {
                newRange.minimum = 0.0;
                int i = Range.findFirstIndexAbove(value / decade, triads);
                newRange.maximum = decade * triads[i];
                break;
            }
            case 0: {
                int i = Range.findFirstIndexAbove(value / decade, decades);
                if (i == 0) {
                    newRange.minimum = decades[i] * decade;
                    newRange.maximum = decades[i + 1] * decade;
                    break;
                }
                newRange.minimum = decades[i - 1] * decade;
                newRange.maximum = decades[i] * decade;
                break;
            }
            case 1: 
            case 3: {
                int i = Range.findFirstIndexAbove(value / decade, triads);
                if (i == 0) {
                    newRange.minimum = triads[i] * decade;
                    newRange.maximum = triads[i + 1] * decade;
                    break;
                }
                newRange.minimum = triads[i - 1] * decade;
                newRange.maximum = triads[i] * decade;
                break;
            }
            default: {
                throw new IllegalArgumentException("Zoom range mustbe in the range 0-2");
            }
        }
        if (newRange.maximum == newRange.minimum) {
            newRange.maximum += 1.0;
        }
        return newRange;
    }

    public static Range findRange(VisibleVariable var, int zoomRange) {
        Range newRange = new Range();
        switch (zoomRange) {
            case 3: {
                newRange.minimum = var.minimum;
                newRange.maximum = var.maximum;
                return newRange;
            }
            case 2: {
                Range r3;
                Range r2;
                Range r1;
                try {
                    r1 = Range.findRange(var.node.doubleGetVal(), 0);
                    r2 = Range.findRange(var.minimum, 0);
                    r3 = Range.findRange(var.maximum, 0);
                }
                catch (RuntimeException e) {
                    return Range.findRange(var, 3);
                }
                newRange.maximum = Math.max(Math.max(r1.maximum, r2.maximum), r3.maximum);
                newRange.minimum = Math.min(Math.min(r1.minimum, r2.minimum), r3.minimum);
                return newRange;
            }
            case 0: {
                return Range.findRange(var.node.doubleGetVal(), 0);
            }
        }
        return Range.findRange(var.node.doubleGetVal(), zoomRange);
    }

    public static Range findRangeSymmetrical(VisibleVariable var, int zoom) {
        Range r = Range.findRange(var, zoom);
        double i = var.initial;
        double rm = Math.max(i - r.minimum, r.maximum - i);
        r.maximum = i + rm;
        r.minimum = i - rm;
        return r;
    }

    protected static final int findFirstIndexAbove(double value, double[] list) {
        int i = 0;
        while (i < list.length) {
            if (list[i] > value) {
                return i;
            }
            ++i;
        }
        return list.length - 1;
    }

    public String toString() {
        return "[ " + this.minimum + ", " + this.maximum + " ]";
    }

    public boolean equals(Range r) {
        return this.minimum == r.minimum && this.maximum == r.maximum;
    }

    public boolean contains(double value) {
        return value >= this.minimum && value <= this.maximum;
    }
}

