/*
 * Decompiled with CFR 0.152.
 */
package phic.modifiable;

import evaluator.MathException;
import evaluator.ParseException;
import evaluator.StackException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import phic.Current;
import phic.common.Container;
import phic.common.LifeSupport;
import phic.common.Quantity;
import phic.common.TimedEvent;
import phic.common.VDouble;
import phic.drug.NoSuchDrugException;
import phic.drug.Pharmacy;
import phic.gui.HorzScrollGraph;
import phic.gui.Node;
import phic.gui.PhicApplication;
import phic.gui.PhicFrameSetup;
import phic.gui.VariablePropertiesDialog;
import phic.gui.Variables;
import phic.gui.VisibleVariable;
import phic.modifiable.Script;
import sanjay.common.Utils;

public class EvaluatorHelper {
    public static boolean multilineHelp = false;
    static String helpString = "HOM commande:\n quit, exit    - exit to command prompt\n help          - this screen\n help(<item>)  - information on the fields and methods for an item\n <item>.<name> - access a named field or method of the item\n Mathematical operations +, -, *, /, pow(x,y), sin(x) etc.\n Variables.variable - list of main visible variables\n body          - root item containing all variables in the body\n environment   - root item containing all variables in the enviroment\n";

    public String help(Object object) {
        Class<?> c = object.getClass();
        StringBuffer s = new StringBuffer(c.getName());
        String prechars = multilineHelp ? "\n\t" : "";
        s.append(" methods{");
        Method[] m = c.getMethods();
        int i = 0;
        while (i < m.length) {
            s.append(prechars);
            s.append(m[i]);
            if (i < m.length - 1) {
                s.append(',');
            }
            ++i;
        }
        s.append("}\nfields{");
        Field[] f = c.getFields();
        int i2 = 0;
        while (i2 < f.length) {
            s.append(prechars);
            s.append(f[i2]);
            if (i2 < f.length - 1) {
                s.append(',');
            }
            ++i2;
        }
        s.append('}');
        return s.toString();
    }

    public String info(Object o) {
        VariablePropertiesDialog d = new VariablePropertiesDialog();
        if (o instanceof VisibleVariable) {
            d.setVariable((VisibleVariable)o);
            d.show();
            return "";
        }
        if (o instanceof Node) {
            d.setVariable(Variables.forNode((Node)o));
            d.show();
            return "";
        }
        if (o instanceof String) {
            d.setVariable(Variables.forName((String)o));
            d.show();
            return "";
        }
        return "Not a variable";
    }

    public String dir(Object o) {
        return this.help(o);
    }

    public String dump(Object o) {
        StringBuffer s = new StringBuffer();
        int fieldw = 25;
        Field[] f = o.getClass().getFields();
        int i = 0;
        while (i < f.length) {
            String fn;
            int w = 0;
            if (VDouble.class.isAssignableFrom(f[i].getType())) {
                try {
                    VDouble vd = (VDouble)f[i].get(o);
                    try {
                        VisibleVariable vv = Variables.forVDouble(vd);
                        s.append(String.valueOf(vv.shortName) + ": ");
                        w += vv.shortName.length() + 2;
                    }
                    catch (IllegalArgumentException vv) {
                        // empty catch block
                    }
                    String val = vd.formatValue(true, true);
                    fn = f[i].getName();
                    s.append(fn);
                    s.append(Utils.strstr(" ", fieldw - (w += fn.length())));
                    s.append("\t= " + val + "\n");
                }
                catch (Exception vd) {
                    // empty catch block
                }
            }
            if (f[i].getType() == Double.TYPE) {
                try {
                    double d = f[i].getDouble(o);
                    fn = f[i].getName();
                    s.append(fn);
                    s.append(Utils.strstr(" ", fieldw - (w += fn.length())));
                    s.append("\t= " + Quantity.toString(d) + "\n");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++i;
        }
        return s.toString();
    }

    public void afterSeconds(double secondsDelay, String command) {
        new TimedEvent(secondsDelay, command);
    }

    public Container getDrug(String s) throws NoSuchDrugException {
        return Pharmacy.dispense(s);
    }

    public Container getSubstance(String s) throws NoSuchDrugException {
        return Pharmacy.dispense(s);
    }

    public Container createSubstance(String s) throws NoSuchDrugException {
        return Pharmacy.dispense(s);
    }

    public Container dispense(String s) throws NoSuchDrugException {
        return Pharmacy.dispense(s);
    }

    public String fullName(String var) {
        Node n;
        try {
            VisibleVariable vv = Variables.forName(var);
            n = vv.node;
        }
        catch (Exception e) {
            n = Node.findNodeByName(var);
        }
        return n.canonicalNameReplaced();
    }

    public String clamp(String varName, double value) {
        LifeSupport ls = Current.environment.getVariableClamps();
        VisibleVariable vv = Variables.forName(varName);
        ls.setFudgeVariable(vv, true);
        ls.setFudgeValue(vv, value);
        return String.valueOf(vv.longName) + " clamped at " + vv.formatValue(value, true, false);
    }

    public void unclamp(String varName) {
        LifeSupport ls = Current.environment.getVariableClamps();
        VisibleVariable vv = Variables.forName(varName);
        ls.setFudgeVariable(vv, false);
    }

    public void scaleGraph(String variableName, double min, double max) {
        HorzScrollGraph.DisplayVariable z = ((PhicFrameSetup)PhicApplication.frame).graph.getDisplayVariable(Variables.forName(variableName));
        z.minimum = min;
        z.maximum = max;
        z.origin = min;
        z.customScaled = true;
        z.rescalePanel();
    }

    public static String formatAnswer(Object o) {
        if (o == null) {
            return "null";
        }
        String prefix = "";
        if (multilineHelp) {
            prefix = "\n\t";
        }
        if (o.getClass().isArray()) {
            StringBuffer s = new StringBuffer(o.toString());
            s.append('{');
            int n = Array.getLength(o);
            int i = 0;
            while (i < n) {
                s.append(prefix);
                s.append(Array.get(o, i));
                if (i < n - 1) {
                    s.append(',');
                }
                ++i;
            }
            s.append('}');
            return s.toString();
        }
        if (o instanceof List) {
            StringBuffer s = new StringBuffer(o.toString());
            s.append('{');
            List l = (List)o;
            int i = 0;
            while (i < l.size()) {
                s.append(prefix);
                s.append(l.get(i));
                if (i < l.size() - 1) {
                    s.append(',');
                }
                ++i;
            }
            s.append('}');
            return s.toString();
        }
        return String.valueOf(o);
    }

    public static String evaluate(String s) throws MathException, ParseException, StackException {
        if (s.equalsIgnoreCase("help")) {
            return helpString;
        }
        Script sc = new Script();
        sc.setText(s);
        return EvaluatorHelper.formatAnswer(sc.executeOnce());
    }
}

