/*
 * Decompiled with CFR 0.152.
 */
package phic.modifiable;

import java.util.Vector;
import phic.common.Organ;
import phic.common.Table;
import phic.common.VDouble;
import phic.gui.Variables;
import phic.gui.VisibleVariable;
import phic.modifiable.Controller;
import phic.modifiable.Eqn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControllerList {
    private Vector controllers;

    public ControllerList(String file) {
        Table r = new Table(file, 7);
        this.controllers = this.readFromTable(r);
    }

    Vector readFromTable(Table t) {
        int n = t.nRows;
        Vector<Object> v = new Vector<Object>();
        int i = 0;
        while (i < n) {
            block9: {
                Controller c;
                VisibleVariable v1 = Variables.forName(t.getString(i, 0));
                try {
                    VisibleVariable v2 = Variables.forName(t.getString(i, 1));
                    c = new Controller(v1, v2);
                }
                catch (IllegalArgumentException e) {
                    String v2 = t.getString(i, 1);
                    c = new Controller(v1, v2);
                }
                Controller.Type type = Controller.Type.forName(t.getString(i, 2));
                c.setType(type);
                if (type == Controller.Type.ERROR_GAIN_LIMITED || type == Controller.Type.ERROR_GAIN_UNLIMITED || type == Controller.Type.PROPORTION_LIMITED || type == Controller.Type.PROPORTION_UNLIMITED || type == Controller.Type.ERROR_POWER_LIMITED || type == Controller.Type.ERROR_NEGATIVE_LIMITED || type == Controller.Type.ERROR_POSITIVE_LIMITED) {
                    c.setGain(t.getDouble(i, 3));
                    c.setRateFractionPerMinute(t.getDouble(i, 4));
                    c.setConstant(t.getDouble(i, 5));
                }
                c.setDescription(t.getString(i, 6));
                int j = 0;
                while (j < v.size()) {
                    Vector ov;
                    Controller c2;
                    if (v.get(j) instanceof Controller) {
                        Controller c22 = (Controller)v.get(j);
                        if (c22.getControlled().equals(c.getControlled()) && c22.getRateFractionPerMinute() == c.getRateFractionPerMinute()) {
                            v.remove(c22);
                            Vector<Controller> nv = new Vector<Controller>();
                            nv.add(c22);
                            nv.add(c);
                            v.add(nv);
                            break block9;
                        }
                    } else if (v.get(j) instanceof Vector && (c2 = (Controller)(ov = (Vector)v.get(j)).get(0)).getControlled().equals(c.getControlled()) && c2.getRateFractionPerMinute() == c.getRateFractionPerMinute()) {
                        ov.add(c);
                        break block9;
                    }
                    ++j;
                }
                v.add(c);
            }
            ++i;
        }
        return v;
    }

    public void replaceAllVariables() {
        int i = 0;
        while (i < this.controllers.size()) {
            Object o = this.controllers.get(i);
            if (o instanceof Controller) {
                Controller c = (Controller)o;
                c.replaceVariables();
            } else if (o instanceof Vector) {
                Vector v = (Vector)o;
                int j = 0;
                while (j < v.size()) {
                    ((Controller)v.get(j)).replaceVariables();
                    ++j;
                }
            } else {
                throw new IllegalStateException("Object " + o + " in 'controllers' is not a Vector or Controller");
            }
            ++i;
        }
    }

    public void addNewController(VisibleVariable controlled, VisibleVariable controlling, Controller.Type type, double gain, double rateFractionPerMinute, double offset, String description) {
        Controller c = new Controller(controlled, controlling);
        c.setGain(gain);
        c.setType(type);
        c.setRateFractionPerMinute(rateFractionPerMinute);
        c.setConstant(offset);
        c.setDescription(description);
        this.controllers.add(c);
    }

    public void addNewControllerByName(String controlled, String controlling, String type, double gain, double rateFractionPerMinute, double offset, String description) {
        Controller c;
        try {
            c = new Controller(Variables.forName(controlled), Variables.forName(controlling));
        }
        catch (IllegalArgumentException e) {
            c = new Controller(Variables.forName(controlled), controlling);
        }
        c.setGain(gain);
        c.setType(Controller.Type.forName(type));
        c.setRateFractionPerMinute(rateFractionPerMinute);
        c.setConstant(offset);
        c.setDescription(description);
        this.controllers.add(c);
    }

    public Vector forControlledVariable(VisibleVariable v) {
        return this.forVariable(v, true);
    }

    public Vector forVariable(VisibleVariable v, boolean controlled) {
        Vector<Controller> result = new Vector<Controller>();
        int i = 0;
        while (i < this.controllers.size()) {
            block10: {
                Object o;
                block8: {
                    Controller c;
                    block9: {
                        o = this.controllers.get(i);
                        if (!(o instanceof Controller)) break block8;
                        c = (Controller)o;
                        if (!controlled) break block9;
                        if (c.controlledVariable != null && c.controlledVariable.equals(v)) {
                            result.add(c);
                        }
                        break block10;
                    }
                    if (c.controllingVariable == null || !c.controllingVariable.equals(v)) break block10;
                    result.add(c);
                    break block10;
                }
                if (o instanceof Vector) {
                    Vector r = (Vector)o;
                    int j = 0;
                    while (j < r.size()) {
                        Controller c = (Controller)r.get(j);
                        if (controlled) {
                            if (c.controlledVariable != null && c.controlledVariable.equals(v)) {
                                result.add(c);
                            }
                        } else if (c.controllingVariable != null && c.controllingVariable.equals(v)) {
                            result.add(c);
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        return result;
    }

    public Vector forControllingVariable(VisibleVariable v) {
        return this.forVariable(v, false);
    }

    public Controller forVariableNames(String target, String controller) throws IllegalArgumentException {
        VisibleVariable t = Variables.forName(target);
        VisibleVariable c = Variables.forName(controller);
        return this.forVariables(t, c);
    }

    public Controller forVariables(VisibleVariable target, VisibleVariable controller) {
        int i = 0;
        while (i < this.controllers.size()) {
            Object o = this.controllers.get(i);
            if (o instanceof Controller) {
                Controller c = (Controller)o;
                if (c.controlledVariable == target && c.controllingVariable == controller) {
                    return c;
                }
            } else {
                Vector v = (Vector)o;
                int j = 0;
                while (j < v.size()) {
                    Controller c = (Controller)v.get(j);
                    if (c.controlledVariable == target && c.controllingVariable == controller) {
                        return c;
                    }
                    ++j;
                }
            }
            ++i;
        }
        throw new IllegalArgumentException(String.valueOf(target.longName) + " does not control " + controller.longName);
    }

    public Controller findName(String s) {
        int i = 0;
        while (i < this.controllers.size()) {
            Object o = this.controllers.get(i);
            if (o instanceof Controller) {
                if (((Controller)o).getDescription().equalsIgnoreCase(s)) {
                    return (Controller)o;
                }
            } else if (o instanceof Vector) {
                Vector v = (Vector)o;
                int j = 0;
                while (j < v.size()) {
                    if (((Controller)v.get(j)).getDescription().equalsIgnoreCase(s)) {
                        return (Controller)v.get(j);
                    }
                    ++j;
                }
            }
            ++i;
        }
        throw new IllegalArgumentException("No controllers named " + s);
    }

    public Controller[] getControllers() {
        Vector v = new Vector();
        int i = 0;
        while (i < this.controllers.size()) {
            Object o = this.controllers.get(i);
            if (o instanceof Controller) {
                v.add(o);
            } else if (o instanceof Vector) {
                Vector v2 = (Vector)o;
                int j = 0;
                while (j < v2.size()) {
                    v.add(v2.get(j));
                    ++j;
                }
            }
            ++i;
        }
        return v.toArray(new Controller[v.size()]);
    }

    public void calculateAll(double elapsedTimeSecs) {
        int i = 0;
        while (i < this.controllers.size()) {
            Object o = this.controllers.get(i);
            if (o instanceof Controller) {
                Controller c = (Controller)o;
                c.calculate(elapsedTimeSecs);
            } else if (o instanceof Vector) {
                Vector v = (Vector)o;
                Controller c0 = (Controller)v.get(0);
                VDouble controlled = c0.getControlled();
                double target = controlled.initialValue;
                boolean limit = false;
                int j = 0;
                while (j < v.size()) {
                    Controller c = (Controller)v.get(j);
                    double diff = c.getDesiredError();
                    if (c.getType() == Controller.Type.ERROR_GAIN_LIMITED || c.getType() == Controller.Type.PROPORTION_LIMITED || c.getType() == Controller.Type.ERROR_NEGATIVE_LIMITED || c.getType() == Controller.Type.ERROR_POSITIVE_LIMITED || c.getType() == Controller.Type.ERROR_POWER_NEGATIVE_LIMITED || c.getType() == Controller.Type.ERROR_POWER_POSITIVE_LIMITED || c.getType() == Controller.Type.ERROR_POWER_LIMITED) {
                        diff = controlled.limitValue(target + diff) - target;
                        limit = true;
                    }
                    target += diff;
                    ++j;
                }
                if (limit) {
                    target = controlled.limitValue(target);
                }
                controlled.lowPass(target, Organ.fractionDecayPerMinute(c0.getRateFractionPerMinute(), elapsedTimeSecs));
            }
            ++i;
        }
    }

    public void removeController(Controller item) {
        int i = 0;
        while (i < this.controllers.size()) {
            Object o = this.controllers.get(i);
            if (o instanceof Controller) {
                if (o.equals(item)) {
                    this.controllers.remove(item);
                    return;
                }
            } else if (o instanceof Vector) {
                Vector v2 = (Vector)o;
                int j = 0;
                while (j < v2.size()) {
                    if (v2.get(j).equals(item)) {
                        v2.remove(item);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public Vector<Eqn> getAllEquations() {
        Vector<Eqn> v = new Vector<Eqn>();
        int i = 0;
        while (i < this.controllers.size()) {
            Object o = this.controllers.get(i);
            v.add(Controller.getEqn(o));
            ++i;
        }
        return v;
    }
}

