/*
 * Decompiled with CFR 0.152.
 */
package phic.modifiable;

import evaluator.MathExtra;
import java.util.Vector;
import phic.Current;
import phic.common.Organ;
import phic.common.VDouble;
import phic.gui.Variables;
import phic.gui.VisibleVariable;
import phic.modifiable.Eqn;

public final class Controller {
    protected Contribution contribution = Contribution.ADDITIVE;
    protected Type type = Type.ERROR_GAIN_UNLIMITED;
    protected VDouble controlling;
    protected VDouble controlled;
    protected VisibleVariable controllingVariable;
    protected VisibleVariable controlledVariable;
    protected String description;
    protected double gain = 0.0;
    protected double rateFractionPerMinute = 0.0;
    protected String drugProperty = null;
    protected double constant = 0.0;

    public Controller(VisibleVariable controlledV, VisibleVariable controllingV) {
        this.controllingVariable = controllingV;
        this.controlledVariable = controlledV;
        this.controlling = controllingV.node.getVDouble();
        this.controlled = controlledV.node.getVDouble();
    }

    public Controller(VisibleVariable controlledV, String drugProperty) {
        this.controllingVariable = null;
        this.controlledVariable = controlledV;
        this.controlled = controlledV.node.getVDouble();
        this.drugProperty = drugProperty;
    }

    public void calculate(double elapsedTimeSecs) {
        double r = Organ.fractionDecayPerMinute(this.rateFractionPerMinute, elapsedTimeSecs);
        if (this.controllingVariable != null) {
            if (this.type == Type.ERROR_GAIN_LIMITED) {
                this.controlled.regulateQuantity(this.controlling, this.gain, r, this.constant);
                return;
            }
            if (this.type == Type.ERROR_GAIN_UNLIMITED) {
                this.controlled.regulate(this.controlling, this.gain, r, this.constant);
                return;
            }
            if (this.type == Type.PROPORTION_LIMITED) {
                this.controlled.lowPass(this.constant + this.controlled.initialValue * (1.0 + this.gain * (this.controlling.get() / this.controlling.initialValue - 1.0)), r);
                return;
            }
            if (this.type == Type.PROPORTION_UNLIMITED) {
                this.controlled.lowPassQuantity(this.controlled.initialValue + this.gain * this.controlling.get() / this.controlling.initialValue, r);
                return;
            }
            double desiredError = this.getDesiredError();
            this.controlled.lowPassQuantity(this.controlled.initialValue + desiredError, r);
            return;
        }
        if (this.drugProperty != null) {
            double binding = Current.body.blood.getDrugBinding(this.drugProperty);
            if (this.type == Type.ERROR_GAIN_LIMITED) {
                this.controlled.lowPassQuantity(this.controlled.initialValue + this.gain * binding, r);
                return;
            }
            if (this.type == Type.ERROR_GAIN_UNLIMITED) {
                this.controlled.lowPass(this.controlled.initialValue + this.gain * binding, r);
                return;
            }
            if (this.type == Type.ERROR_POWER_LIMITED) {
                this.controlled.lowPassQuantity(this.controlled.initialValue + this.getDesiredError(), r);
                return;
            }
        }
        throw new UnsupportedOperationException("Can't perform " + this.type + " with " + this.controllingVariable + " controlling " + this.controlledVariable);
    }

    public double getDesiredError() {
        if (this.controlling != null) {
            if (this.type == Type.ERROR_GAIN_LIMITED || this.type == Type.ERROR_GAIN_UNLIMITED) {
                return this.controlling.getError() * this.gain + this.constant;
            }
            if (this.type == Type.PROPORTION_UNLIMITED || this.type == Type.PROPORTION_LIMITED) {
                return this.controlled.initialValue * this.gain * (this.controlling.get() / this.controlling.initialValue - 1.0) + this.constant;
            }
            if (this.type == Type.ERROR_POWER_LIMITED) {
                double d = this.controlling.getError();
                double q = Math.pow(Math.abs(d), this.gain);
                return (this.constant == 0.0 ? 1.0 : this.constant) * (double)(d < 0.0 ? -1 : 1) * q;
            }
            if (this.type == Type.ERROR_POSITIVE_LIMITED) {
                return Math.max(0.0, this.controlling.getError() * this.gain + this.constant);
            }
            if (this.type == Type.ERROR_NEGATIVE_LIMITED) {
                return Math.min(0.0, this.controlling.getError() * this.gain + this.constant);
            }
            if (this.type == Type.ERROR_GAIN_SIGMOID) {
                return this.gain * MathExtra.sigmoid(this.controlling.getError() / this.constant);
            }
            if (this.type == Type.ERROR_POWER_POSITIVE_LIMITED) {
                double d = this.controlling.getError();
                double q = Math.pow(Math.abs(d), this.gain);
                return Math.max(0.0, (this.constant == 0.0 ? 1.0 : this.constant) * (double)(d < 0.0 ? -1 : 1) * q);
            }
            if (this.type == Type.ERROR_POWER_NEGATIVE_LIMITED) {
                double d = this.controlling.getError();
                double q = Math.pow(Math.abs(d), this.gain);
                return Math.min(0.0, (this.constant == 0.0 ? 1.0 : this.constant) * (double)(d < 0.0 ? -1 : 1) * q);
            }
        } else if (this.drugProperty != null) {
            double binding = Current.body.blood.getDrugBinding(this.drugProperty);
            if (this.type == Type.ERROR_GAIN_LIMITED || this.type == Type.ERROR_GAIN_UNLIMITED) {
                return binding * this.gain;
            }
            if (this.type == Type.ERROR_POWER_LIMITED) {
                return Math.pow(binding, this.gain);
            }
        }
        throw new UnsupportedOperationException("Can't perform " + this.type + " with " + this.controllingVariable + " controlling " + this.controlledVariable);
    }

    public VDouble getControlled() {
        return this.controlled;
    }

    public VDouble getControlling() {
        return this.controlling;
    }

    public void setControlling(VDouble controlling) {
        this.controlling = controlling;
    }

    public void setControlled(VDouble controlled) {
        this.controlled = controlled;
    }

    public double getGain() {
        return this.gain;
    }

    public void setGain(double gain) {
        this.gain = gain;
    }

    public double getRateFractionPerMinute() {
        return this.rateFractionPerMinute;
    }

    public void setRateFractionPerMinute(double rateFractionPerMinute) {
        this.rateFractionPerMinute = rateFractionPerMinute;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDrugProperty() {
        return this.drugProperty;
    }

    public void setControllingVariable(VisibleVariable controllingVariable) {
        this.controllingVariable = controllingVariable;
        if (controllingVariable != null) {
            this.controlling = controllingVariable.node.getVDouble();
            this.drugProperty = null;
        }
    }

    public void setControlledVariable(VisibleVariable controlledVariable) {
        this.controlledVariable = controlledVariable;
        this.controlled = controlledVariable.node.getVDouble();
    }

    public void setDrugProperty(String s) {
        this.drugProperty = s;
        if (this.drugProperty != null) {
            this.controllingVariable = null;
            this.controlling = null;
        }
    }

    public VisibleVariable getControlledVariable() {
        return this.controlledVariable;
    }

    public VisibleVariable getControllingVariable() {
        return this.controllingVariable;
    }

    public void setConstant(double v) {
        this.constant = v;
    }

    public double getConstant() {
        return this.constant;
    }

    public String toString() {
        return this.controlledVariable + "\t" + this.controllingVariable + "\t" + this.type + "\t" + this.gain + "\t" + this.rateFractionPerMinute + "\t" + this.constant + "\t\"" + this.description + "\"";
    }

    public void replaceVariables() {
        this.setControlledVariable(Variables.forName(this.getControlledVariable().canonicalName));
        if (this.controllingVariable != null) {
            this.setControllingVariable(Variables.forName(this.getControllingVariable().canonicalName));
        }
    }

    public static Eqn getEqn(Object obj) {
        Vector<Controller> vec;
        if (obj instanceof Controller) {
            vec = new Vector<Controller>();
            vec.add((Controller)obj);
        } else {
            vec = (Vector<Controller>)obj;
        }
        String fx = "";
        VisibleVariable controlled = null;
        double rate = 0.0;
        int i = 0;
        while (i < vec.size()) {
            Controller c = (Controller)vec.get(i);
            if (controlled == null) {
                controlled = c.controlledVariable;
            } else if (controlled != c.controlledVariable) {
                throw new IllegalStateException("Controllers didn't all control the same variable");
            }
            String cn = c.controllingVariable != null ? c.controllingVariable.shortName : c.drugProperty.replace('_', ' ').toLowerCase();
            if (c.type == Type.ERROR_GAIN_LIMITED) {
                fx = String.valueOf(fx) + " + \\left[" + Controller.fnum(c.gain) + " \\cdot \\Delta " + cn + " \\right]^{" + Controller.fnum(c.controlled.maximum) + "}_{" + Controller.fnum(c.controlled.minimum) + "}";
                if (c.constant != 0.0) {
                    fx = String.valueOf(fx) + "+" + Controller.fnum(c.constant);
                }
            } else if (c.type == Type.ERROR_GAIN_UNLIMITED) {
                fx = String.valueOf(fx) + " + " + Controller.fnum(c.gain) + " \\cdot \\Delta " + cn;
                if (c.constant != 0.0) {
                    fx = String.valueOf(fx) + "+" + Controller.fnum(c.constant);
                }
            } else if (c.type == Type.ERROR_POSITIVE_LIMITED) {
                fx = String.valueOf(fx) + " + \\left[ " + Controller.fnum(c.gain) + " \\cdot \\Delta^{+} " + cn + " \\right]^{" + Controller.fnum(c.controlled.maximum) + "}_{" + Controller.fnum(c.controlled.minimum) + "}";
                if (c.constant != 0.0) {
                    fx = String.valueOf(fx) + "+" + Controller.fnum(c.constant);
                }
            } else if (c.type == Type.ERROR_NEGATIVE_LIMITED) {
                fx = String.valueOf(fx) + " + " + Controller.fnum(c.gain) + " \\left[ \\Delta^{-} " + cn + " \\right]^{" + Controller.fnum(c.controlled.maximum) + "}_{" + Controller.fnum(c.controlled.minimum) + "}";
                if (c.constant != 0.0) {
                    fx = String.valueOf(fx) + "+" + Controller.fnum(c.constant);
                }
            } else if (c.type == Type.ERROR_GAIN_SIGMOID) {
                fx = String.valueOf(fx) + " + " + Controller.fnum(c.gain) + " \\cdot sigmoid \\left( \\frac{ \\Delta " + cn + "}{" + Controller.fnum(c.constant) + "} \\right)";
            } else if (c.type == Type.ERROR_POWER_POSITIVE_LIMITED) {
                fx = String.valueOf(fx) + " + ";
                if (c.constant != 0.0) {
                    fx = String.valueOf(fx) + Controller.fnum(c.constant) + " \\cdot ";
                }
                fx = String.valueOf(fx) + " + sgn\\left( \\Delta " + cn + " \\right) \\cdot \\left| \\Delta " + cn + " \\right| ^{" + Controller.fnum(c.gain) + "}";
            } else if (c.type == Type.ERROR_POWER_NEGATIVE_LIMITED) {
                if (c.constant != 0.0) {
                    fx = String.valueOf(fx) + Controller.fnum(c.constant) + " \\cdot ";
                }
                fx = String.valueOf(fx) + " + sgn \\left( \\Delta " + cn + " \\right) \\cdot \\left( - \\left| \\Delta " + cn + " \\right| \\right) ^{" + Controller.fnum(c.gain) + "}";
            }
            rate = c.rateFractionPerMinute;
            ++i;
        }
        return new Eqn("\\Delta " + controlled.shortName + "\\longrightarrow _{" + Controller.fnum(rate) + "}", fx);
    }

    private static final String fnum(double d) {
        String f = Double.toString(d);
        if (f.contains("E")) {
            int ix = f.indexOf("E");
            double mantissa = Double.parseDouble(f.substring(0, ix));
            mantissa = Math.round(mantissa * 1024.0) / 1024L;
            f = String.valueOf(String.valueOf(mantissa)) + " \\times 10^{" + f.substring(ix + 1) + "}";
            f = f.replaceAll(".0 ", "");
        }
        if (f.endsWith(".0")) {
            f = f.substring(0, f.length() - 2);
        }
        f.replaceAll("(\\.[0-9]*[0-8]+99)9*", "$1");
        return f;
    }

    public static class Contribution {
        private String name;
        private String abbrev;
        private static Vector listAll = new Vector();
        public static Contribution ADDITIVE = new Contribution("+", "Additive");
        public static Contribution MULTIPLICATIVE = new Contribution("*", "Multiplicative");
        public static Contribution COMPETITIVE = new Contribution(".", "Competitive");

        private Contribution(String abbrev, String name) {
            this.abbrev = abbrev;
            this.name = name;
            listAll.add(this);
        }

        public String toString() {
            return this.name;
        }

        public static Contribution forName(String s) {
            int i = 0;
            while (i < listAll.size()) {
                Contribution t = (Contribution)listAll.get(i);
                if (t.name.equalsIgnoreCase(s) || t.abbrev.equalsIgnoreCase(s)) {
                    return t;
                }
                ++i;
            }
            throw new IllegalArgumentException("No such controller type, " + s);
        }
    }

    public static class Type {
        String name;
        String abbreviation;
        private static Vector listAll = new Vector();
        public static Type ERROR_GAIN_UNLIMITED = new Type("EGU", "Error gain (unlimited)");
        public static Type ERROR_GAIN_LIMITED = new Type("EGL", "Error gain (limited)");
        public static Type ERROR_ADD_LIMITED = new Type("EAL", "Error add (limited)");
        public static Type ERROR_POSITIVE_LIMITED = new Type("EPL", "Error positive (limited)");
        public static Type ERROR_NEGATIVE_LIMITED = new Type("ENL", "Error negative (limited)");
        public static Type PROPORTION_UNLIMITED = new Type("PRU", "Proportional (unlimited)");
        public static Type PROPORTION_LIMITED = new Type("PRL", "Proportional (limited)");
        public static Type ERROR_POWER_LIMITED = new Type("EPWL", "Error power (limited)");
        public static Type ERROR_GAIN_SIGMOID = new Type("SIG", "Error gain sigmoid");
        public static Type ERROR_POWER_POSITIVE_LIMITED = new Type("EPPL", "Error power positive (limited)");
        public static Type ERROR_POWER_NEGATIVE_LIMITED = new Type("EPNL", "Error power negative (limited)");

        private Type(String abbrev, String name) {
            this.abbreviation = abbrev;
            this.name = name;
            listAll.add(this);
        }

        public String toString() {
            return this.name;
        }

        public static Type forName(String s) {
            int i = 0;
            while (i < listAll.size()) {
                Type t = (Type)listAll.get(i);
                if (t.name.equalsIgnoreCase(s) || t.abbreviation.equalsIgnoreCase(s)) {
                    return t;
                }
                ++i;
            }
            throw new IllegalArgumentException("No such controller type, " + s);
        }

        public static Type[] getTypes() {
            return listAll.toArray(new Type[listAll.size()]);
        }
    }
}

