/*
 * Decompiled with CFR 0.152.
 */
package phic.modifiable;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import phic.common.Container;
import phic.common.Quantity;
import phic.common.VDouble;
import phic.common.Variable;

public abstract class AbstractQuantity
extends VDouble {
    Container parent;
    Variable Q = new Variable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public double get() {
            Container container = AbstractQuantity.this.parent;
            synchronized (container) {
                return AbstractQuantity.this.get() * AbstractQuantity.this.parent.volume.get();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void set(double quantity) {
            Container container = AbstractQuantity.this.parent;
            synchronized (container) {
                AbstractQuantity.this.set(quantity / AbstractQuantity.this.parent.volume.get());
            }
        }
    };
    static final NumberFormat numformat = new DecimalFormat("0.##E0");

    public AbstractQuantity(Container parent) {
        super(parent);
        this.parent = parent;
    }

    public void setC(double cc) {
        this.set(cc);
    }

    public void setQ(double qq) {
        if (qq == 0.0) {
            this.set(0.0);
        } else {
            this.set(qq / this.parent.volume.get());
        }
    }

    public double getC() {
        return this.get();
    }

    public double getQ() {
        return this.get() * this.parent.volume.get();
    }

    public double C() {
        return this.getC();
    }

    public double Q() {
        return this.getQ();
    }

    public void addQ(double qq) {
        if (this.parent.volume.get() == 0.0) {
            return;
        }
        this.set(Math.max(this.getQ() + qq, 0.0) / this.parent.volume.get());
    }

    public void addC(double cc) {
        super.add(cc);
    }

    public void multiplyC(double factor) {
        this.set(this.get() * factor);
    }

    public void moveTo(Quantity to) {
        to.addQ(this.getQ());
        this.setQ(0.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveTo(AbstractQuantity to, double quantity) {
        Container container = to.parent;
        synchronized (container) {
            Container container2 = this.parent;
            synchronized (container2) {
                quantity = Math.max(Math.min(quantity, this.getQ()), -to.getQ());
                to.addQ(quantity);
                this.addQ(-quantity);
            }
        }
    }

    public String toString() {
        return numformat.format(this.get());
    }

    public static String toString(double d) {
        return numformat.format(d);
    }

    static final double sgn(double x) {
        return x > 0.0 ? 1 : (x < 0.0 ? -1 : 0);
    }

    public static double getNearestRoundBelow(double d) {
        int p = (int)(Math.log(d) / Math.log(10.0));
        return Math.pow(10.0, p);
    }

    public static double getNearestRoundAbove(double d) {
        double p = Math.log(d) / Math.log(10.0);
        p = Math.floor(p);
        return Math.pow(10.0, p + 1.0);
    }
}

