/*
 * Decompiled with CFR 0.152.
 */
package phic.gui.graphics;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JLabel;
import javax.swing.JPanel;
import medicine.Entity;
import phic.Body;
import phic.Current;
import phic.common.Gas;
import phic.gui.exam.Examination;
import phic.gui.graphics.GasLabel;

public class GasesDiagram
extends JPanel
implements Examination {
    JPanel jPanel1 = new JPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanel2 = new JPanel();
    JLabel jLabel2 = new JLabel();
    GasLabel tisgas = new GasLabel();
    JPanel jPanel3 = new JPanel();
    JLabel jLabel3 = new JLabel();
    GasLabel vengas = new GasLabel();
    JPanel jPanel4 = new JPanel();
    JLabel jLabel4 = new JLabel();
    GasLabel artgas = new GasLabel();
    JPanel diagpanel = new JPanel(){
        double h1 = 0.25;
        double h2 = 0.75;
        int aw = 5;
        int lw = 5;

        public void paint(Graphics g) {
            super.paint(g);
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setStroke(new BasicStroke(this.lw));
            g2.setColor(this.getForeground());
            int ph1 = (int)((double)this.getHeight() * this.h1);
            int w = this.getWidth();
            int ph2 = (int)((double)this.getHeight() * this.h2);
            g2.drawLine(0, ph1, w - this.lw, ph1);
            g2.drawLine(w - this.aw - this.lw, ph1 - this.aw, w - this.lw, ph1);
            g2.drawLine(w - this.aw - this.lw, ph1 + this.aw, w - this.lw, ph1);
            g2.drawLine(this.lw, ph2, w, ph2);
            g2.drawLine(this.lw, ph2, this.aw + this.lw, ph2 + this.aw);
            g2.drawLine(this.lw, ph2, this.aw + this.lw, ph2 - this.aw);
        }
    };
    JPanel jPanel5 = new JPanel();
    JLabel jLabel1 = new JLabel();
    GasLabel alvgas = new GasLabel();
    BorderLayout borderLayout2 = new BorderLayout();
    JPanel jPanel6 = new JPanel();
    JLabel jLabel5 = new JLabel();
    GasLabel atmgas = new GasLabel();

    public GasesDiagram() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public JPanel createPanel() {
        return this;
    }

    public Entity[] getPathologies() {
        return null;
    }

    public Entity[] getSigns() {
        return null;
    }

    public void initialise(Body body) {
        this.atmgas.setGas(Current.environment.airP);
        this.alvgas.setGas(body.lungs.alvP);
        this.artgas.setGas(body.blood.arterial.getPartials());
        this.vengas.setGas(body.blood.venous.getPartials());
        Gas tissue = new Gas();
        tissue.O2.set(0.025);
        tissue.O2.setUnit(6);
        tissue.CO2.set(0.05);
        tissue.CO2.setUnit(6);
        this.tisgas.setGas(body.CVS.InterstitialP);
    }

    private void jbInit() throws Exception {
        this.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.setLayout(this.borderLayout1);
        this.jLabel2.setText("Tissues");
        this.jLabel3.setText("Venous blood");
        this.jPanel3.setBackground(new Color(214, 153, 255));
        this.jPanel3.setPreferredSize(new Dimension(120, 50));
        this.jLabel4.setText("Arterial blood");
        this.jPanel4.setBackground(new Color(255, 183, 167));
        this.jPanel4.setPreferredSize(new Dimension(120, 50));
        this.jPanel1.setBackground(new Color(201, 235, 255));
        this.jPanel1.setLayout(this.borderLayout2);
        this.jPanel2.setBackground(new Color(224, 133, 106));
        this.jLabel1.setText("Alveolus");
        this.jPanel5.setBackground(new Color(194, 203, 255));
        this.jPanel6.setBackground(new Color(221, 255, 255));
        this.jLabel5.setText("Atmosphere");
        this.add((Component)this.jPanel1, "North");
        this.jPanel1.add((Component)this.jPanel5, "Center");
        this.jPanel5.add((Component)this.jLabel1, null);
        this.jPanel5.add((Component)this.alvgas, null);
        this.jPanel1.add((Component)this.jPanel6, "North");
        this.jPanel6.add((Component)this.jLabel5, null);
        this.jPanel6.add((Component)this.atmgas, null);
        this.add((Component)this.jPanel2, "South");
        this.jPanel2.add((Component)this.jLabel2, null);
        this.jPanel2.add((Component)this.tisgas, null);
        this.add((Component)this.jPanel3, "West");
        this.jPanel3.add((Component)this.jLabel3, null);
        this.jPanel3.add((Component)this.vengas, null);
        this.add((Component)this.jPanel4, "East");
        this.jPanel4.add((Component)this.jLabel4, null);
        this.jPanel4.add((Component)this.artgas, null);
        this.add((Component)this.diagpanel, "Center");
    }

    public String getName() {
        return "Gases diagram";
    }

    public String toString() {
        return this.getName();
    }

    public double getUpdateFrequencySeconds() {
        return 0.2;
    }
}

