/*
 * Decompiled with CFR 0.152.
 */
package phic.gui.graphics;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import phic.common.Gas;
import phic.common.VDouble;
import phic.gui.ThinNodeView;

public class GasLabel
extends JPanel {
    JTextField o2txt = new JTextField();
    JTextField co2txt = new JTextField();
    Border border1;
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanel1 = new JPanel();
    JPanel jPanel2 = new JPanel();
    GridLayout gridLayout1 = new GridLayout();
    JLabel po2label = new JLabel();
    JLabel pco2label = new JLabel();
    GridLayout gridLayout2 = new GridLayout();
    int nValues = 2;
    Gas gas;
    VDouble pO2;
    VDouble pCO2;

    public GasLabel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setPreferredSize(new Dimension(115, 44));
    }

    private void jbInit() throws Exception {
        this.border1 = BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.o2txt.setText("0");
        this.setLayout(this.borderLayout1);
        this.co2txt.setText("0");
        this.setBorder(this.border1);
        this.jPanel1.setLayout(this.gridLayout1);
        this.gridLayout1.setColumns(1);
        this.gridLayout1.setRows(2);
        this.po2label.setText("pO2");
        this.pco2label.setText("pCO2");
        this.jPanel2.setLayout(this.gridLayout2);
        this.gridLayout2.setColumns(1);
        this.gridLayout2.setRows(2);
        this.add((Component)this.jPanel1, "West");
        this.jPanel1.add((Component)this.po2label, null);
        this.jPanel1.add((Component)this.pco2label, null);
        this.add((Component)this.jPanel2, "Center");
        this.jPanel2.add((Component)this.o2txt, null);
        this.jPanel2.add((Component)this.co2txt, null);
    }

    public void addValue(String label, VDouble variable) {
    }

    public void setGas(Gas g) {
        this.gas = g;
        this.pO2 = g.O2;
        this.pCO2 = g.CO2;
        this.updateValues();
    }

    public Gas getGas() {
        return this.gas;
    }

    public void updateValues() {
        double po2 = this.pO2.get();
        double pco2 = this.pCO2.get();
        this.o2txt.setText(this.pO2.formatValue(po2, true, true));
        this.co2txt.setText(this.pCO2.formatValue(pco2, true, true));
        this.po2label.setIcon(ThinNodeView.getIcon(po2, this.pO2));
        this.pco2label.setIcon(ThinNodeView.getIcon(pco2, this.pCO2));
    }
}

