/*
 * Decompiled with CFR 0.152.
 */
package phic.gui.graphics;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Synthesizer;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import phic.Body;
import phic.common.Ticker;
import phic.ecg.Lead;
import phic.ecg.PhicHeart;
import phic.ecg.Trace;
import phic.gui.HorizontalBar;
import phic.gui.exam.Auscultation;

public class ECGIcon
extends JPanel
implements Ticker {
    Body body;
    ComponentListener compListen = new ComponentAdapter(){

        public void componentHidden(ComponentEvent e) {
            HorizontalBar.removeBar(ECGIcon.this);
            if (ECGIcon.this.noteOn >= 0) {
                ECGIcon.this.chan.noteOff(ECGIcon.this.noteOn);
            }
            if (ECGIcon.this.auscultation != null) {
                ECGIcon.this.auscultation.stopSound();
            }
        }

        public void componentShown(ComponentEvent e) {
            HorizontalBar.addBar(ECGIcon.this);
            if (ECGIcon.this.auscultation != null) {
                ECGIcon.this.auscultation.startSound();
            }
        }
    };
    Auscultation auscultation = null;
    Color lineCol = new Color(0, 128, 0);
    boolean sound = false;
    int noteOn = -1;
    int volume = 60;
    Synthesizer synth;
    MidiChannel chan;
    PhicHeart heart;
    double[][] fields;
    double[][] trace;
    Lead lead = Trace.leads[2];
    double secPerBeat = 1.0;
    int illuminated = 0;
    double soundCumTime = 0.0;
    JPopupMenu jPopupMenu1 = new JPopupMenu();
    JCheckBoxMenuItem soundcheck = new JCheckBoxMenuItem();
    JCheckBoxMenuItem animcheck = new JCheckBoxMenuItem();
    boolean needsCalc = true;
    boolean animate = true;
    boolean soundEnabled = true;
    JMenu jMenu1 = new JMenu();
    JMenuItem jMenuItem1 = new JMenuItem();
    double oph;

    public ECGIcon(Body body) {
        this();
        this.setBody(body);
    }

    public ECGIcon() {
        this.addComponentListener(this.compListen);
        this.jbInit();
    }

    public void setBody(Body body) {
        this.body = body;
        this.heart = new PhicHeart(body);
        this.setBackground(Color.black);
        this.setForeground(Color.green);
    }

    public void addNotify() {
        super.addNotify();
        try {
            this.synth = MidiSystem.getSynthesizer();
            this.synth.open();
            this.chan = this.synth.getChannels()[0];
            this.chan.programChange(80);
            this.chan.controlChange(6, 0);
            this.sound = true;
        }
        catch (MidiUnavailableException ex) {
            ex.printStackTrace();
            this.sound = false;
            this.soundcheck.setEnabled(false);
            this.soundcheck.setSelected(false);
        }
        if (this.auscultation != null) {
            this.auscultation.setBody(this.body);
        }
    }

    public void removeNotify() {
        this.abortNote();
        super.removeNotify();
    }

    public void abortNote() {
        if (this.synth != null) {
            if (this.noteOn >= 0) {
                this.chan.noteOff(this.noteOn);
            }
            this.synth.close();
        }
    }

    public void refreshBeat() {
        this.fields = this.heart.getBeatsField(60.0 / this.body.CVS.heart.rate.get());
    }

    public void tick(double t) {
        double ph = this.body.CVS.heart.phase;
        if (this.noteOn >= 0) {
            this.soundCumTime += t;
        }
        if (this.sound && this.soundEnabled && this.body.getClock().isSlowMode) {
            if (this.noteOn < 0 && ph < this.oph) {
                this.noteOn = (int)(this.body.blood.SatO2.get() * 100.0) - 14;
                this.chan.noteOn(this.noteOn, this.volume);
                this.soundCumTime = 0.0;
            } else if (this.noteOn >= 0 && (ph > this.oph || this.soundCumTime > 0.2)) {
                this.chan.noteOff(this.noteOn);
                if (ph > 0.2) {
                    this.noteOn = -1;
                }
            }
        }
        if (ph < this.oph) {
            this.recalculateECG();
            this.needsCalc = false;
            if (!this.animate) {
                this.repaint();
            }
        } else if (ph > 0.2) {
            this.needsCalc = true;
        }
        if (this.animate) {
            this.secPerBeat = 60.0 / this.body.CVS.heart.rate.get();
            if (this.trace != null) {
                int i = 0;
                while (i < this.trace.length) {
                    if (this.trace[i][0] / this.secPerBeat >= ph) {
                        this.illuminated = i;
                        break;
                    }
                    ++i;
                }
                this.repaint();
            }
        }
        this.oph = ph;
        if (this.auscultation != null) {
            this.auscultation.tick(t);
        }
    }

    void recalculateECG() {
        this.fields = this.heart.getBeatsField(this.secPerBeat);
        this.trace = this.lead.getPoints(this.fields);
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.trace != null) {
            g.setColor(this.lineCol);
            Graphics2D g2 = (Graphics2D)g;
            g2.setStroke(new BasicStroke(1.0f));
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            double xscale = (double)this.getWidth() / this.secPerBeat;
            double yscale = (double)(-this.getHeight()) / 2.0;
            double y0 = (double)this.getHeight() / 2.0;
            int ox = 0;
            int oy = this.getHeight() / 2;
            int i = 0;
            while (i < this.trace.length) {
                if (i == this.illuminated) {
                    g.setColor(this.getForeground());
                } else {
                    g.setColor(this.lineCol);
                }
                int n = ox;
                int n2 = oy;
                ox = (int)(this.trace[i][0] * xscale);
                oy = (int)(this.trace[i][1] * yscale + y0);
                g.drawLine(n, n2, ox, oy);
                ++i;
            }
        }
    }

    private void jbInit() {
        this.soundcheck.setSelected(true);
        this.soundcheck.setText("Sound");
        this.animcheck.setSelected(true);
        this.animcheck.setText("Animation");
        this.animcheck.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ECGIcon.this.animate = ECGIcon.this.animcheck.isSelected();
                if (!ECGIcon.this.animate) {
                    ECGIcon.this.illuminated = -1;
                }
            }
        });
        this.soundcheck.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ECGIcon.this.soundEnabled = ECGIcon.this.soundcheck.isSelected();
                if (!ECGIcon.this.soundEnabled) {
                    ECGIcon.this.abortNote();
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 3) {
                    ECGIcon.this.jPopupMenu1.show(ECGIcon.this, e.getX(), e.getY());
                }
            }
        });
        this.jMenu1.setText("Lead");
        this.jPopupMenu1.add(this.soundcheck);
        this.jPopupMenu1.add(this.animcheck);
        this.jPopupMenu1.add(this.jMenu1);
        int i = 0;
        while (i < Trace.leads.length) {
            this.jMenu1.add(new AbstractAction(Trace.leads[i].name){

                public void actionPerformed(ActionEvent e) {
                    ECGIcon.this.setLead(e.getActionCommand());
                }
            });
            ++i;
        }
    }

    void setLead(String lead) {
        int i = 0;
        while (i < Trace.leads.length) {
            if (Trace.leads[i].name.equalsIgnoreCase(lead)) {
                this.lead = Trace.leads[i];
                this.recalculateECG();
            }
            ++i;
        }
    }
}

