/*
 * Decompiled with CFR 0.152.
 */
package phic.gui.graphics;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import phic.Body;
import phic.common.UnitConstants;
import phic.common.VDouble;
import phic.gui.Variables;
import phic.gui.VisibleVariable;

public class CompartmentDiagram
extends JPanel {
    String[] compartmentName = new String[]{"Plasma", "ECF", "ICF"};
    String[] itemNames = new String[]{"Vol", "Na", "K", "Cl", "Bic", "gluc", "prot", "urea"};
    Color[] colours = new Color[]{Color.black, Color.red.darker(), Color.cyan.darker(), Color.green.darker(), Color.gray, Color.pink.darker(), Color.yellow, Color.orange.darker()};
    VDouble[][] vd;
    VisibleVariable[][] var;
    Component[][] comp;
    Body body;
    double heightScale = 1.0;
    double widthScale = 1.0;
    double totalVolume = 60.0;
    double maxOsm = 0.35;
    int axx = 50;
    int axy = 15;
    int[] rowmids;
    int[] rowbots;

    public void setBody(Body b) {
        if (this.body != b) {
            this.vd = new VDouble[][]{{b.blood.PV, b.blood.PNa, b.blood.PK, b.blood.PCl, b.blood.PBic, b.blood.glucose, b.blood.PPr, b.blood.PUN}, {b.ecf.volume, b.ecf.Na, b.ecf.K, b.ecf.Cl, b.ecf.bicarb, b.ecf.glucose, b.ecf.prot, b.ecf.urea}, {b.icf.volume, b.icf.Na, b.icf.K, b.icf.Cl, b.icf.bicarb, b.icf.glucose, b.icf.prot, b.icf.urea}};
            this.rowmids = new int[this.vd.length];
            this.rowbots = new int[this.vd.length];
            this.var = new VisibleVariable[this.vd.length][this.vd[0].length];
            if (this.comp == null) {
                this.comp = new Component[this.vd.length][this.vd[0].length];
            }
            int i = 0;
            while (i < this.vd.length) {
                int j = 0;
                while (j < this.vd[i].length) {
                    this.var[i][j] = Variables.forVDouble(this.vd[i][j]);
                    if (this.comp[i][j] == null) {
                        this.comp[i][j] = new Item(j, this.var[i][j]);
                        this.add(this.comp[i][j]);
                    }
                    ++j;
                }
                ++i;
            }
            this.body = b;
        }
        this.update();
    }

    public CompartmentDiagram() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void paint(Graphics g) {
        super.paintComponent(g);
        g.setColor(Color.black);
        g.drawLine(0, this.axy, this.getWidth(), this.axy);
        g.drawLine(this.axx, 0, this.axx, this.getHeight());
        g.setFont(this.getFont());
        int i = 0;
        while (i < this.rowmids.length) {
            g.drawString(this.compartmentName[i], 2, this.rowmids[i] + 5);
            double v = this.vd[i][0].get();
            g.drawString(UnitConstants.formatValue(v, 4, i == this.rowmids.length - 1, true), 10, Math.max(this.rowbots[i], this.rowmids[i] + 20));
            ++i;
        }
        int N = 3;
        int i2 = 0;
        while (i2 < N) {
            double v = (double)i2 * 0.3 / (double)N;
            int x = this.axx + i2 * (this.getWidth() - this.axx) / N;
            g.drawString(UnitConstants.formatValue(v, 11, i2 == N - 1, true), x + 2, this.axy - 4);
            g.drawLine(x, this.axy, x, this.axy - 4);
            ++i2;
        }
        super.paintComponents(g);
    }

    public void update() {
        int cumHt = this.axy + 2;
        int i = 0;
        while (i < this.vd.length) {
            int h = Math.max(1, (int)(this.vd[i][0].get() * this.heightScale));
            this.rowmids[i] = cumHt + h / 2;
            this.rowbots[i] = cumHt + h;
            int cumWd = this.axx + 2;
            int j = 1;
            while (j < this.vd[i].length) {
                int w = Math.max(1, (int)(this.vd[i][j].get() * this.widthScale));
                this.comp[i][j].setBounds(cumWd, cumHt, w, h);
                cumWd += w;
                ++j;
            }
            cumHt += h + 1;
            ++i;
        }
        this.repaint();
    }

    public void addNotify() {
        super.addNotify();
        this.resized();
    }

    private void jbInit() throws Exception {
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                CompartmentDiagram.this.resized();
            }
        });
        this.setLayout(null);
    }

    public void resized() {
        this.heightScale = (double)(this.getHeight() - this.axy) / this.totalVolume;
        this.widthScale = (double)(this.getWidth() - this.axx) / this.maxOsm;
        this.update();
    }

    class Item
    extends JLabel {
        VisibleVariable var;
        int colour;
        MouseListener ml = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                Item.this.var.showVariableInfoBox.actionPerformed(new ActionEvent(this, 0, ""));
            }
        };

        public Item(int colour, VisibleVariable v) {
            this.var = v;
            this.colour = colour;
            this.setBackground(CompartmentDiagram.this.colours[colour]);
            this.setToolTipText(v.longName);
            this.setOpaque(true);
            this.addMouseListener(this.ml);
            this.setCursor(Cursor.getPredefinedCursor(12));
        }

        public String getToolTipText() {
            return String.valueOf(this.var.longName) + " = " + this.var.formatValue(this.var.node.getVDouble().get(), true, false);
        }

        public void paint(Graphics g) {
            g.setColor(this.getBackground());
            g.fill3DRect(0, 0, this.getWidth(), this.getHeight(), true);
            if (this.getWidth() > 20 && this.getHeight() > 10) {
                g.setColor(this.getForeground());
                g.drawString(this.var.shortName, 2, this.getHeight() - 2);
            }
        }
    }
}

