/*
 * Decompiled with CFR 0.152.
 */
package phic.gui.exam;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import medicine.Entity;
import phic.Body;
import phic.Current;
import phic.gui.exam.Examination;

public class SkinColour
extends JPanel
implements Examination {
    public JLabel jLabel1 = new JLabel();
    public JPanel jPanel1 = new JPanel();
    public Color basePigment = new Color(255, 225, 215);
    Body body = null;
    Color colour;

    public SkinColour() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String toString() {
        return this.getName();
    }

    public JPanel createPanel() {
        return this;
    }

    public String getName() {
        return "Skin colour";
    }

    public Entity[] getPathologies() {
        return null;
    }

    public Entity[] getSigns() {
        return null;
    }

    public void initialise(Body body) {
        this.basePigment = Current.person.skinBasePigment;
        this.body = body;
        this.update();
    }

    public void update() {
        double hb = this.body.blood.Hb.get();
        double sat = this.body.blood.SatO2.get();
        double co = this.body.blood.CO.get();
        double rabs = 255.0 * Math.min(0.15, 1.0 - (sat += co)) / 0.15;
        double gabs = 255.0;
        double babs = 255.0 * Math.max(0.0, sat - 0.875) / 12.5;
        double vasc = 0.0026 * Math.max(0.0, Math.min(1.7, 0.1 / this.body.skin.resistance.get()));
        hb = Math.max(0.0, (hb - 60.0) * 1.8);
        int r = this.basePigment.getRed() - (int)(rabs * hb * vasc);
        int g = this.basePigment.getGreen() - (int)(gabs * hb * vasc);
        int b = this.basePigment.getBlue() - (int)(babs * hb * vasc);
        r = Math.max(Math.min(r, 255), 0);
        g = Math.max(Math.min(g, 255), 0);
        b = Math.max(Math.min(b, 255), 0);
        this.colour = new Color(r, g, b);
        this.jPanel1.setBackground(this.colour);
    }

    public Color getColour() {
        return this.colour;
    }

    private void jbInit() throws Exception {
        this.jLabel1.setText("Skin colour:");
        this.jPanel1.setBorder(BorderFactory.createBevelBorder(1));
        this.jPanel1.setPreferredSize(new Dimension(50, 50));
        this.add((Component)this.jLabel1, null);
        this.add((Component)this.jPanel1, null);
    }

    public double getUpdateFrequencySeconds() {
        return 0.2;
    }
}

