/*
 * Decompiled with CFR 0.152.
 */
package phic.gui.exam;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import medicine.Entity;
import phic.Body;
import phic.Brain;
import phic.gui.exam.Examination;

public class ReflexExamination
extends JPanel
implements Examination {
    private BorderLayout borderLayout1 = new BorderLayout();
    private Box box1;
    private JPanel jPanel1 = new JPanel();
    private JPanel jPanel2 = new JPanel();
    private Border border1;
    private Border border2;
    private JPanel rightreflexes = new JPanel();
    private BorderLayout borderLayout2 = new BorderLayout();
    private BorderLayout borderLayout3 = new BorderLayout();
    private JPanel leftreflexes = new JPanel();
    private JLabel jLabel1 = new JLabel();
    private JLabel jLabel2 = new JLabel();
    SideDisplay left;
    SideDisplay right;
    static final int R_ABSENT = 0;
    static final int R_DECREASED = 1;
    static final int R_NORMAL = 2;
    static final int R_BRISK = 3;
    static final String[] ds = new String[]{"Absent", "Diminished", "Normal", "Brisk"};
    static final String[] ankleds = new String[]{"Absent", "Downgoing", "Downgoing", "Upgoing"};

    public JPanel createPanel() {
        return this;
    }

    public void initialise(Body body) {
        int[] l;
        int[] r = l = new int[]{2, 2, 2, 2, 2, 2};
        Brain cfr_ignored_0 = body.brain;
        if (body.brain.getFeeling() == 3) {
            l = r = new int[6];
        } else if (body.icf.volume.get() > 42.0) {
            r = new int[]{3, 3, 3, 3, 3, 3, 3};
            l = r;
        }
        double temp = body.Temp.get();
        double thyr = body.blood.Thyr.get();
        if (temp < 26.0 || thyr < 1.2E-11) {
            r = new int[]{1, 1, 1, 1, 1, 1};
            l = r;
        } else if (temp < 32.0 || thyr < 1.0E-11) {
            l = r = new int[6];
        }
        this.left.setState(l);
        this.right.setState(r);
    }

    public Entity[] getPathologies() {
        return null;
    }

    public Entity[] getSigns() {
        return null;
    }

    public String getName() {
        return "Reflexes";
    }

    public String toString() {
        return this.getName();
    }

    public ReflexExamination() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.left = new SideDisplay();
        this.leftreflexes.add(this.left);
        this.right = new SideDisplay();
        this.rightreflexes.add(this.right);
    }

    private void jbInit() throws Exception {
        this.box1 = Box.createHorizontalBox();
        this.border1 = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        this.border2 = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        this.setLayout(this.borderLayout1);
        this.jPanel1.setBorder(this.border1);
        this.jPanel1.setLayout(this.borderLayout2);
        this.jPanel2.setBorder(this.border2);
        this.jPanel2.setLayout(this.borderLayout3);
        this.rightreflexes.setBorder(BorderFactory.createLoweredBevelBorder());
        this.leftreflexes.setBorder(BorderFactory.createLoweredBevelBorder());
        this.jLabel1.setText("Right");
        this.jLabel2.setText("Left");
        this.add((Component)this.box1, "Center");
        this.box1.add((Component)this.jPanel1, null);
        this.jPanel1.add((Component)this.rightreflexes, "Center");
        this.jPanel1.add((Component)this.jLabel1, "North");
        this.box1.add((Component)this.jPanel2, null);
        this.jPanel2.add((Component)this.leftreflexes, "Center");
        this.jPanel2.add((Component)this.jLabel2, "North");
    }

    public double getUpdateFrequencySeconds() {
        return 1.0;
    }

    class SideDisplay
    extends JPanel {
        final String[] cs = new String[]{"Triceps", "Biceps", "Wrist", "Knee", "Ankle", "Plantar"};
        int[] state = new int[6];
        JLabel[] label = new JLabel[this.cs.length];
        JLabel[] val = new JLabel[this.cs.length];

        public SideDisplay() {
            this.setLayout(new GridLayout(6, 2));
            this.setState(new int[]{2, 2, 2, 2, 2, 2});
        }

        void setState(int[] state) {
            this.state = state;
            this.removeAll();
            int i = 0;
            while (i < this.cs.length) {
                String s = ds[state[i]];
                if (i == 5) {
                    s = ankleds[state[i]];
                }
                this.label[i] = new JLabel(String.valueOf(this.cs[i]) + ": ");
                this.val[i] = new JLabel(s);
                this.add(this.label[i]);
                this.add(this.val[i]);
                ++i;
            }
        }
    }
}

