/*
 * Decompiled with CFR 0.152.
 */
package phic.gui.exam;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import medicine.Entities;
import medicine.Entity;
import medicine.EntityData;
import phic.Body;
import phic.Current;
import phic.gui.ConsciousStateLabel;
import phic.gui.PathologyAnalysisDialog;
import phic.gui.exam.Examination;
import phic.gui.exam.Observations_jList1_listSelectionAdapter;
import phic.gui.exam.Observations_jList2_listSelectionAdapter;

public class Observations
extends JPanel
implements Examination {
    BorderLayout borderLayout1 = new BorderLayout();
    BorderLayout borderLayout4 = new BorderLayout();
    DefaultListModel signmodel = new DefaultListModel();
    DefaultListModel symptommodel = new DefaultListModel();
    JPanel jPanel1 = new JPanel();
    GridLayout gridLayout1 = new GridLayout();
    JPanel jPanel2 = new JPanel();
    JPanel jPanel3 = new JPanel();
    JList jList1 = new JList();
    JScrollPane jScrollPane1 = new JScrollPane();
    JList jList2 = new JList();
    JScrollPane jScrollPane2 = new JScrollPane();
    BorderLayout borderLayout2 = new BorderLayout();
    BorderLayout borderLayout3 = new BorderLayout();
    JLabel jLabel1 = new JLabel();
    JLabel jLabel2 = new JLabel();
    Border border1;
    Border border2;
    JScrollPane jScrollPane3 = new JScrollPane();
    JTextArea description = new JTextArea();
    JPanel jPanel4 = new JPanel();
    JTextArea observation = new JTextArea();
    EntityData ed;
    Entity SIGN;
    Entity SYMPTOM;
    Vector signDetail;
    Vector symptomDetail;
    PathologyAnalysisDialog.PathologyData p;
    public static String[] postureString = new String[]{"standing up", "sitting down", "semi-recumbent", "lying flat", "lying with head tilted down", "standing upside down"};

    public Observations() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.p = new PathologyAnalysisDialog.PathologyData();
    }

    public JPanel createPanel() {
        return this;
    }

    public void initialise(Body body) {
        this.createObs(body);
        if (body.brain.getFeeling() == 3) {
            return;
        }
        this.p.createProblems();
        Vector v = this.p.getPathologies();
        this.signDetail = new Vector();
        this.symptomDetail = new Vector();
        this.signmodel.removeAllElements();
        this.symptommodel.removeAllElements();
        try {
            this.SIGN = this.p.getData().findEntityExact("Sign");
            this.SYMPTOM = this.p.getData().findEntityExact("Symptom");
            int i = 0;
            while (i < v.size()) {
                Entity e = (Entity)v.get(i);
                if (!this.tryAdd(e, null)) {
                    int j = 0;
                    while (j < e.effects.size()) {
                        Entity e2 = (Entity)e.effects.get(j);
                        this.tryAdd(e2, e);
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    boolean tryAdd(Entity e, Entity efrom) {
        if (Entities.isChildOf(e, this.SIGN)) {
            this.signmodel.addElement(e);
            String desc = this.p.getPathologyFromEntity(e);
            if (desc != null) {
                this.signDetail.add(desc);
            } else if (efrom != null) {
                this.signDetail.add("Consequence of " + efrom.toString());
            } else {
                this.signDetail.add("");
            }
            return true;
        }
        if (Entities.isChildOf(e, this.SYMPTOM)) {
            this.symptommodel.addElement(e);
            String desc = this.p.getPathologyFromEntity(e);
            if (desc != null) {
                this.symptomDetail.add(desc);
            } else if (efrom != null) {
                this.symptomDetail.add("Consequence of " + efrom.toString());
            } else {
                this.symptomDetail.add("");
            }
            return true;
        }
        return false;
    }

    public Entity[] getPathologies() {
        return null;
    }

    public Entity[] getSigns() {
        return null;
    }

    public String getName() {
        return "Observation";
    }

    private void jbInit() throws Exception {
        this.border1 = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        this.border2 = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        this.setLayout(this.borderLayout1);
        this.jPanel1.setLayout(this.gridLayout1);
        this.jList1.setModel(this.signmodel);
        this.jList1.addListSelectionListener(new Observations_jList1_listSelectionAdapter(this));
        this.jList2.setModel(this.symptommodel);
        this.jList2.addListSelectionListener(new Observations_jList2_listSelectionAdapter(this));
        this.jPanel3.setLayout(this.borderLayout2);
        this.jPanel2.setLayout(this.borderLayout3);
        this.jLabel1.setVerifyInputWhenFocusTarget(true);
        this.jLabel1.setText("Signs");
        this.jLabel2.setText("Symptoms");
        this.jPanel3.setBorder(this.border1);
        this.jPanel2.setBorder(this.border2);
        this.description.setEditable(false);
        this.description.setText("");
        this.description.setLineWrap(true);
        this.description.setRows(3);
        this.description.setTabSize(8);
        this.description.setWrapStyleWord(true);
        this.jPanel4.setLayout(this.borderLayout4);
        this.observation.setEditable(false);
        this.observation.setText("");
        this.observation.setLineWrap(true);
        this.observation.setRows(3);
        this.observation.setWrapStyleWord(true);
        this.add((Component)this.jPanel1, "Center");
        this.jPanel1.add((Component)this.jPanel3, null);
        this.jPanel3.add((Component)this.jScrollPane1, "Center");
        this.jPanel3.add((Component)this.jLabel1, "North");
        this.jScrollPane1.getViewport().add((Component)this.jList1, null);
        this.jPanel1.add((Component)this.jPanel2, null);
        this.jPanel2.add((Component)this.jScrollPane2, "Center");
        this.jPanel2.add((Component)this.jLabel2, "North");
        this.add((Component)this.jScrollPane3, "South");
        this.add((Component)this.jPanel4, "North");
        this.jPanel4.add((Component)this.observation, "Center");
        this.jScrollPane3.getViewport().add((Component)this.description, null);
        this.jScrollPane2.getViewport().add((Component)this.jList2, null);
    }

    void jList1_valueChanged(ListSelectionEvent e) {
        int i = this.jList1.getSelectedIndex();
        if (i >= 0) {
            Object s = this.signDetail.get(i);
            if (s != null) {
                this.description.setText(s.toString());
            }
        } else {
            this.description.setText("");
        }
    }

    void jList2_valueChanged(ListSelectionEvent e) {
        int i = this.jList2.getSelectedIndex();
        if (i >= 0) {
            Object s = this.symptomDetail.get(i);
            if (s != null) {
                this.description.setText(s.toString());
            }
        } else {
            this.description.setText("");
        }
    }

    private void createObs(Body body) {
        String name = Current.person.name;
        int feeling = body.brain.getFeeling();
        String text = String.valueOf(name) + " is " + ConsciousStateLabel.stateStrings[feeling];
        text = feeling != 3 ? String.valueOf(text) + " and " + Observations.postureString(Current.environment.Uprt.get()) : String.valueOf(text) + ". ";
        if (feeling < 2) {
            text = String.valueOf(text) + ", with a pain score of " + (int)(body.brain.pain.get() * 100.0) + "%. ";
            if (body.brain.hunger.get() > 0.75 && body.brain.thirst.get() < 0.75) {
                text = String.valueOf(text) + name + " is hungry. ";
            } else if (body.brain.thirst.get() > 0.75 && body.brain.hunger.get() < 0.75) {
                text = String.valueOf(text) + name + " is thirsty. ";
            } else if (body.brain.thirst.get() > 0.75 && body.brain.hunger.get() > 0.75) {
                text = String.valueOf(text) + name + " is hungry and thirsty. ";
            }
        }
        double sktmp = body.skin.Temp.get();
        double swr = body.skin.SwR.get();
        String skt = null;
        String sks = null;
        if (sktmp > 28.0) {
            skt = "hot";
        } else if (sktmp < 20.0) {
            skt = "cold";
        }
        if (swr < 0.001) {
            sks = "dry";
        } else if (swr > 0.004) {
            sks = "sweaty";
        }
        if (sks != null && skt != null) {
            text = String.valueOf(text) + "The skin is " + skt + " and " + sks + ". ";
        } else if (sks != null) {
            text = String.valueOf(text) + "The skin is " + sks + ". ";
        } else if (skt != null) {
            text = String.valueOf(text) + "The skin is " + skt + ". ";
        }
        this.observation.setText(text);
    }

    public static String postureString(double uprt) {
        int p = uprt > 0.9 ? 0 : (uprt > 0.7 ? 1 : (uprt > 0.55 ? 2 : (uprt > 0.45 ? 3 : (uprt > 0.2 ? 4 : 5))));
        return postureString[p];
    }

    public String toString() {
        return this.getName();
    }

    public double getUpdateFrequencySeconds() {
        return 2.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PathologyAnalysisDialog createPathologyDialog() {
        class R
        implements Runnable {
            PathologyAnalysisDialog result;

            R() {
            }

            public synchronized void run() {
                this.result = new PathologyAnalysisDialog();
                this.notify();
            }
        }
        R r = new R();
        try {
            R r2 = r;
            synchronized (r2) {
                new Thread(r).start();
                r.wait();
            }
        }
        catch (InterruptedException x) {
            x.printStackTrace();
        }
        return r.result;
    }
}

