/*
 * Decompiled with CFR 0.152.
 */
package phic.gui.exam;

import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import medicine.Entity;
import phic.Body;
import phic.Resource;
import phic.common.IniReader;
import phic.gui.Node;
import phic.gui.ThinNodeView;
import phic.gui.VariablePropertiesDialog;
import phic.gui.Variables;
import phic.gui.VisibleVariable;
import phic.gui.exam.Examination;

public class ImageDiagram
extends JPanel
implements Examination {
    Map map;
    Image image;
    static final String IMAGE_KEY = "Image";
    MouseListener labelMouseListener = new MouseAdapter(){

        public void mouseClicked(MouseEvent e) {
            Object o;
            if (e.getSource() instanceof JLabel && (o = ImageDiagram.this.getVariableForLabel((JLabel)e.getSource())) instanceof VisibleVariable) {
                VariablePropertiesDialog vpd = new VariablePropertiesDialog();
                vpd.setVariable((VisibleVariable)o);
                vpd.show();
            }
        }
    };
    Vector jlabels = new Vector();
    Vector nodes = new Vector();

    public ImageDiagram(IniReader iniFile, String sectionName) {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.map = iniFile.getSectionMap(sectionName);
        this.image = Resource.loader.getImageResource(this.map.get(IMAGE_KEY).toString());
        Set keys = this.map.keySet();
        for (String s : keys) {
            if (s.equals(IMAGE_KEY)) continue;
            try {
                VisibleVariable vv = null;
                try {
                    vv = Variables.forName(s);
                    this.nodes.add(vv);
                }
                catch (IllegalArgumentException x) {
                    Node n = Node.findNodeByName(s);
                    this.nodes.add(n);
                }
                String[] params = this.map.get(s).toString().split(",");
                int x = Integer.parseInt(params[0].trim());
                int y = Integer.parseInt(params[1].trim());
                JLabel label = new JLabel();
                this.add(label);
                label.setLocation(x, y);
                label.setSize(label.getPreferredSize());
                if (vv != null) {
                    label.setToolTipText(String.valueOf(Resource.identifierToText(vv.longName)) + " (" + vv.formatValue(vv.minimum, true, false) + " - " + vv.formatValue(vv.maximum, true, false) + ")");
                }
                this.jlabels.add(label);
                label.addMouseListener(this.labelMouseListener);
                label.setCursor(Cursor.getPredefinedCursor(12));
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("Error at line '" + s + "' in image diagram " + sectionName);
            }
        }
    }

    public void refreshValues() {
        int i = 0;
        while (i < this.nodes.size()) {
            Object o = this.nodes.get(i);
            ImageIcon icon = null;
            String s = "ERROR";
            if (o instanceof VisibleVariable) {
                VisibleVariable vv = (VisibleVariable)o;
                double val = vv.node.doubleGetVal();
                s = vv.formatValue(val, true, true);
                icon = ThinNodeView.getIcon(val, vv.node.getVDouble());
            } else if (o instanceof Node) {
                s = ((Node)o).stringGetVal();
            }
            JLabel label = (JLabel)this.jlabels.get(i);
            label.setText(s);
            label.setIcon(icon);
            label.setSize(label.getPreferredSize());
            ++i;
        }
    }

    public Object getVariableForLabel(JLabel l) {
        int i = 0;
        while (i < this.jlabels.size()) {
            if (l == this.jlabels.get(i)) {
                return this.nodes.get(i);
            }
            ++i;
        }
        throw new IllegalArgumentException("Object " + l + " is not a label in this diagram");
    }

    public void paint(Graphics g) {
        if (this.image != null) {
            g.drawImage(this.image, 0, 0, this);
        }
        super.paint(g);
    }

    private void jbInit() throws Exception {
        this.setLayout(null);
        this.setOpaque(false);
    }

    public JPanel createPanel() {
        return this;
    }

    public Entity[] getPathologies() {
        return null;
    }

    public Entity[] getSigns() {
        return null;
    }

    public double getUpdateFrequencySeconds() {
        return 60.0;
    }

    public void initialise(Body body) {
        this.refreshValues();
    }
}

