/*
 * Decompiled with CFR 0.152.
 */
package phic.gui.exam;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.event.MouseInputAdapter;
import phic.gui.exam.Eye;
import sanjay.common.RadialPaint;

public class EyeExaminationPanel
extends JPanel {
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public Eye left = new Eye();
    public Eye right = new Eye();
    public Eye[] eyes = new Eye[]{this.left, this.right};
    public int interocularDistance = 150;
    public EyeInput mouseInput = new EyeInput();
    private boolean lightOn = false;
    Point currentDirection = new Point();
    public double lookSpeed = 0.3;
    Timer timer = new Timer(100, new TimerListener());
    public double pupilSizeModification = 0.0;
    public int distanceOfTarget = 300;
    public int radiusOfEyeball = 20;
    public double accommodationRate = 0.2;
    Point[] lastDeflections = new Point[2];
    boolean saccade;
    int saccadeTimeout;
    double meanError;
    double saccErrorThresh;
    Point desiredL;
    Point desiredR;
    double saccvxl;
    double saccvyl;
    double saccvxr;
    double saccvyr;
    double maxSaccadeSpeed;
    int minimumSaccadeInterval;
    int saccadeFramesLeft;
    int thinkingTimeLeft;
    double microsaccadeProbability;
    double microsaccadeMagnitude;
    int thinkingDelay;
    double pupilSizeCommand;
    public int esx;
    public int iris;
    public int[] esy;
    public int lightRadius;
    public Color[] irisColor;
    public Color skinColour;

    public EyeExaminationPanel() {
        this.lastDeflections[0] = new Point();
        this.lastDeflections[1] = new Point();
        this.saccade = false;
        this.saccadeTimeout = 0;
        this.meanError = 0.0;
        this.saccErrorThresh = 40.0;
        this.desiredL = new Point();
        this.desiredR = new Point();
        this.saccvxl = 0.0;
        this.saccvyl = 0.0;
        this.maxSaccadeSpeed = 8.0;
        this.minimumSaccadeInterval = 5;
        this.thinkingTimeLeft = -1;
        this.microsaccadeProbability = 0.1;
        this.microsaccadeMagnitude = 3.0;
        this.thinkingDelay = 4;
        this.pupilSizeCommand = 4.0;
        this.esx = 40;
        this.iris = 18;
        this.esy = new int[]{20, 20};
        this.lightRadius = 50;
        this.irisColor = new Color[]{new Color(154, 108, 108), new Color(92, 48, 48)};
        this.skinColour = new Color(250, 230, 220);
        this.initialisePoints();
        this.addMouseListener(this.mouseInput);
        this.addMouseMotionListener(this.mouseInput);
        this.jbInit();
    }

    public void addNotify() {
        super.addNotify();
        this.timer.start();
    }

    public void removeNotify() {
        this.timer.stop();
        super.removeNotify();
    }

    public void initialisePoints() {
        this.eyes[0].centre = new Point((this.getWidth() - this.interocularDistance) / 2, this.getHeight() / 2);
        this.eyes[1].centre = new Point((this.getWidth() + this.interocularDistance) / 2, this.getHeight() / 2);
        int i = 0;
        while (i < 2) {
            this.eyes[i].pupilCentre = (Point)this.eyes[i].centre.clone();
            ++i;
        }
    }

    public void tick() {
    }

    public void movePupilsToLookAt(Point p) {
        double ratio = (double)this.radiusOfEyeball / (double)this.distanceOfTarget;
        double dxl = this.desiredL.x - this.lastDeflections[1].x;
        double dxr = this.desiredR.x - this.lastDeflections[0].x;
        double dyl = this.desiredL.y - this.lastDeflections[1].y;
        double dyr = this.desiredR.y - this.lastDeflections[0].y;
        this.meanError = dxl * dxl + dyl * dyl + dxr * dxr + dyr * dyr;
        if (!this.saccade && this.lookSpeed > 0.0) {
            if (this.saccadeTimeout == 0) {
                if (this.meanError > this.saccErrorThresh) {
                    double thl = Math.atan2(dyl, dxl);
                    double thr = Math.atan2(dyr, dxr);
                    double mgl = dxl * dxl + dyl * dyl;
                    double mgr = dxr * dxr + dyr * dyr;
                    double spL = mgl * 2.0 / (mgl + mgr);
                    double spR = mgr * 2.0 / (mgl + mgr);
                    int frames = (int)((Math.sqrt(mgl) + Math.sqrt(mgr)) / 2.0 / this.maxSaccadeSpeed);
                    frames = Math.max(frames, 1);
                    this.saccvxl = dxl / (double)frames;
                    this.saccvyl = dyl / (double)frames;
                    this.saccvxr = dxr / (double)frames;
                    this.saccvyr = dyr / (double)frames;
                    this.saccadeFramesLeft = frames;
                    if (this.thinkingTimeLeft == -1) {
                        this.thinkingTimeLeft = this.thinkingDelay;
                    } else if (this.thinkingTimeLeft == 0) {
                        this.saccade = true;
                        this.thinkingTimeLeft = -1;
                    } else {
                        --this.thinkingTimeLeft;
                    }
                } else if (Math.random() < this.microsaccadeProbability) {
                    this.saccadeFramesLeft = 1;
                    this.saccvxl = (Math.random() - 0.5) * this.microsaccadeMagnitude;
                    this.saccvxr = -this.saccvxl;
                    this.saccvyl = this.saccvyr = (Math.random() - 0.5) * this.microsaccadeMagnitude;
                    this.saccade = true;
                }
            } else {
                --this.saccadeTimeout;
            }
        } else {
            --this.saccadeFramesLeft;
            if (this.saccadeFramesLeft <= 0) {
                this.saccade = false;
                this.saccadeTimeout = this.minimumSaccadeInterval;
            }
        }
        int i = 0;
        while (i < 2) {
            int LR = i == 0 ? -1 : 1;
            double px = (p.x - this.getWidth() / 2) * 2 + this.getWidth() / 2;
            double py = (p.y - this.getHeight() / 2) * 2 + this.getHeight() / 2;
            Point deflection = new Point((int)((double)LR * (px - (double)this.eyes[i].centre.x + (double)this.eyes[i].strabismusX) * ratio), (int)((py - (double)this.eyes[i].centre.y + (double)this.eyes[i].strabismusY) * ratio));
            if (this.eyes[i].abducentPalsy) {
                deflection.x = Math.min(deflection.x, 0);
            }
            if (this.eyes[i].oculomotorPalsy) {
                deflection.x = Math.max(deflection.x, 10);
                deflection.y = Math.max(deflection.y, 10);
            }
            deflection.x = (int)((double)deflection.x * (1.0 - (deflection.x > 0 ? this.eyes[i].lr : this.eyes[i].mr)));
            deflection.y = (int)((double)deflection.y * (1.0 - (deflection.y < 0 ? this.eyes[i].sr : this.eyes[i].ir)));
            deflection.x = Math.max(-30, Math.min(30, deflection.x));
            deflection.y = Math.max(-20, Math.min(20, deflection.y));
            if (i == 0) {
                this.desiredR.x = deflection.x;
                this.desiredR.y = deflection.y;
            } else {
                this.desiredL.x = deflection.x;
                this.desiredL.y = deflection.y;
            }
            if (this.saccade) {
                this.lastDeflections[i].x = (int)((double)this.lastDeflections[i].x + (i == 0 ? this.saccvxr : this.saccvxl));
                this.lastDeflections[i].y = (int)((double)this.lastDeflections[i].y + (i == 0 ? this.saccvyr : this.saccvyl));
            } else {
                this.lastDeflections[i].x = (int)((double)this.lastDeflections[i].x + this.lookSpeed * (double)(deflection.x - this.lastDeflections[i].x));
                this.lastDeflections[i].y = (int)((double)this.lastDeflections[i].y + this.lookSpeed * (double)(deflection.y - this.lastDeflections[i].y));
            }
            this.eyes[i].pupilCentre.x = this.eyes[i].centre.x + LR * this.lastDeflections[i].x;
            this.eyes[i].pupilCentre.y = this.eyes[i].centre.y + this.lastDeflections[i].y;
            this.calcPupilSize(i);
            ++i;
        }
    }

    public void calcPupilSize(int i) {
        double targetPupilSize = this.pupilSizeCommand;
        targetPupilSize = Math.min(12.0, Math.max(2.0, (1.0 - this.eyes[i].sympatheticPalsy) * (targetPupilSize + 9.0 * this.eyes[i].parasympatheticPalsy)));
        this.eyes[i].pupilSize += this.accommodationRate * (targetPupilSize - this.eyes[i].pupilSize);
    }

    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Shape[] sclera = new Shape[2];
        int i = 0;
        while (i < 2) {
            g2.setPaint(new RadialPaint(Color.white, Color.lightGray, new Point(this.eyes[i].centre.x - 10, this.eyes[i].centre.y - 10), 50));
            sclera[i] = new Ellipse2D.Double(this.eyes[i].centre.x - this.esx, this.eyes[i].centre.y - this.esy[i], this.esx * 2, this.esy[i] * 2);
            g2.fill(sclera[i]);
            g2.setPaint(new RadialPaint(this.irisColor[0], this.irisColor[1], new Point(this.eyes[i].centre.x - 10, this.eyes[i].centre.y - 10), 20));
            g.fillOval(this.eyes[i].pupilCentre.x - this.iris, this.eyes[i].pupilCentre.y - this.iris, this.iris * 2, this.iris * 2);
            double ps = this.eyes[i].pupilSize;
            g2.setPaint(new RadialPaint(new Color(128, 128, 128), Color.black, new Point(this.eyes[i].centre.x - 10, this.eyes[i].centre.y - 10), 15));
            g2.fill(new Ellipse2D.Double((double)this.eyes[i].pupilCentre.x - ps, (double)this.eyes[i].pupilCentre.y - ps, ps * 2.0, ps * 2.0));
            g.setColor(new Color(255, 255, 255, 156));
            g.fillOval(this.eyes[i].centre.x - 15, this.eyes[i].centre.y - 15, 10, 10);
            ++i;
        }
        g.setColor(this.skinColour);
        GeneralPath s = new GeneralPath(new Rectangle2D.Double(0.0, 0.0, this.getWidth(), this.getHeight()));
        s.append(sclera[0], false);
        s.append(sclera[1], false);
        s.setWindingRule(0);
        g2.fill(s);
        if (this.lightOn) {
            g2.setColor(new Color(255, 255, 192, 108));
            g2.fillOval(this.mouseInput.lookingAt.x - this.lightRadius, this.mouseInput.lookingAt.y - this.lightRadius, this.lightRadius * 2, this.lightRadius * 2);
        }
    }

    private void jbInit() {
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                EyeExaminationPanel.this.this_componentResized(e);
            }
        });
    }

    void this_componentResized(ComponentEvent e) {
        this.initialisePoints();
    }

    public class EyeInput
    extends MouseInputAdapter {
        public Point lookingAt = new Point(0, 0);

        public void mousePressed(MouseEvent e) {
            EyeExaminationPanel.this.lightOn = true;
            EyeExaminationPanel.this.repaint();
        }

        public void mouseReleased(MouseEvent e) {
            EyeExaminationPanel.this.lightOn = false;
            EyeExaminationPanel.this.repaint();
        }

        public void mouseMoved(MouseEvent e) {
            this.lookingAt.setLocation(e.getX(), e.getY());
        }

        public void mouseDragged(MouseEvent e) {
            this.lookingAt.setLocation(e.getX(), e.getY());
        }
    }

    class TimerListener
    implements ActionListener {
        TimerListener() {
        }

        public void actionPerformed(ActionEvent e) {
            EyeExaminationPanel.this.tick();
            Point t = EyeExaminationPanel.this.mouseInput.lookingAt;
            EyeExaminationPanel.this.movePupilsToLookAt(t);
            double totalLight = 0.0;
            int i = 0;
            while (i < 2) {
                double distLight = EyeExaminationPanel.this.mouseInput.lookingAt.distance(EyeExaminationPanel.this.eyes[i].pupilCentre);
                if (EyeExaminationPanel.this.lightOn) {
                    totalLight += distLight < (double)EyeExaminationPanel.this.lightRadius ? 1.0 - EyeExaminationPanel.this.eyes[i].opticPalsy : 0.0;
                }
                ++i;
            }
            EyeExaminationPanel.this.pupilSizeCommand = Math.max(9.0 - totalLight * 5.0 + EyeExaminationPanel.this.pupilSizeModification, 3.0);
            EyeExaminationPanel.this.repaint();
        }
    }
}

