/*
 * Decompiled with CFR 0.152.
 */
package phic.gui.exam;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JPanel;
import medicine.Entity;
import phic.Body;
import phic.gui.exam.Examination;
import phic.gui.exam.EyeExaminationPanel;
import phic.gui.exam.SkinColour;

public class EyeExamination
extends JPanel
implements Examination {
    EyeExaminationPanel panel = null;

    public String getName() {
        return "Eye examination";
    }

    public String toString() {
        return this.getName();
    }

    public Entity[] getPathologies() {
        return new Entity[0];
    }

    public Entity[] getSigns() {
        return new Entity[0];
    }

    public JPanel createPanel() {
        if (this.panel == null) {
            this.panel = new EyeExaminationPanel();
            this.setLayout(new BorderLayout());
            this.add((Component)this.panel, "Center");
            this.add((Component)new JLabel("Click to use pen torch"), "South");
        }
        return this;
    }

    public void initialise(Body body) {
        int feeling = body.brain.getFeeling();
        if (feeling == 3) {
            this.panel.eyes[1].parasympatheticPalsy = 1.0;
            this.panel.eyes[0].parasympatheticPalsy = 1.0;
            this.panel.lookSpeed = 0.0;
        } else {
            this.panel.lookSpeed = feeling == 2 ? 0.0 : 0.4;
        }
        double mu = body.blood.getDrugBinding("MU_OPIATE_RECEPTOR") * 10.0;
        double sy = Math.max(0.0, body.brain.Symp.getError()) * 5.0;
        this.panel.pupilSizeModification = Math.max(0.0, Math.min(5.0, sy - mu));
        SkinColour sc = new SkinColour();
        sc.initialise(body);
        this.panel.skinColour = sc.getColour();
        this.panel.eyes[0].pupilSize = this.panel.eyes[1].pupilSize = 10.0 - this.panel.pupilSizeModification;
        this.panel.accommodationRate = Math.max(0.0, 0.2 * Math.max(0.0, Math.min(1.0, 1.0 + 0.13 * (body.Temp.get() - 33.0))) - mu / 10.0);
    }

    public double getUpdateFrequencySeconds() {
        return 6.0;
    }
}

