/*
 * Decompiled with CFR 0.152.
 */
package phic.gui.exam;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import phic.Body;
import phic.Current;
import phic.common.Ticker;
import phic.ecg.PhicECGExamination;
import phic.gui.HTMLMessagePane;
import phic.gui.HorizontalBar;
import phic.gui.ModalDialog;
import phic.gui.exam.AuscultationExam;
import phic.gui.exam.BloodFilmExam;
import phic.gui.exam.CompartmentExamination;
import phic.gui.exam.Examination;
import phic.gui.exam.EyeExamination;
import phic.gui.exam.Observations;
import phic.gui.exam.ReflexExamination;
import phic.gui.exam.SkinColour;
import phic.gui.graphics.GasesDiagram;

public class ExaminationsDialog
extends ModalDialog
implements Ticker {
    Class[] examinations = new Class[]{Observations.class, SkinColour.class, PhicECGExamination.class, EyeExamination.class, ReflexExamination.class, BloodFilmExam.class, AuscultationExam.class, GasesDiagram.class, CompartmentExamination.class};
    private DefaultListModel examlistmodel = new DefaultListModel();
    private JPanel jPanel1 = new JPanel();
    private BorderLayout borderLayout1 = new BorderLayout();
    private JPanel jPanel2 = new JPanel();
    private JPanel jPanel3 = new JPanel();
    private JButton okbutton = new JButton();
    private BorderLayout borderLayout2 = new BorderLayout();
    private JPanel jPanel4 = new JPanel();
    private JPanel jPanel5 = new JPanel();
    private BorderLayout borderLayout3 = new BorderLayout();
    private JPanel jPanel6 = new JPanel();
    private JScrollPane jScrollPane1 = new JScrollPane();
    private JList examlist = new JList();
    private BorderLayout borderLayout4 = new BorderLayout();
    private JPanel jPanel7 = new JPanel();
    private JLabel jLabel1 = new JLabel();
    private JPanel jPanel8 = new JPanel();
    private BorderLayout borderLayout5 = new BorderLayout();
    private JPanel exampanel = new JPanel();
    private Border border1;
    private BorderLayout borderLayout6 = new BorderLayout();
    WindowListener showListener = new WindowAdapter(){

        public void windowOpened(WindowEvent e) {
            HorizontalBar.addBar(ExaminationsDialog.this);
        }

        public void windowClosing(WindowEvent e) {
            HorizontalBar.removeBar(ExaminationsDialog.this);
        }
    };
    double serialTime = 0.0;
    public static boolean MAKE_MODAL = true;
    JPanel currentExamDisplay = null;
    Body body;
    int lastSelection = -1;
    Examination currentExamination;
    JButton helpbutton = new JButton();
    Action helpAction = new AbstractAction("Help"){

        public void actionPerformed(ActionEvent e) {
            HTMLMessagePane.showDialog("help/Examination.html", "Examination help");
        }
    };

    public ExaminationsDialog(Body b) {
        this.body = b;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setPreferredSize(new Dimension(500, 350));
        this.initialiseList();
        this.setTitle("Examine " + Current.person.name);
        if (!MAKE_MODAL) {
            this.setModal(false);
            this.addWindowListener(this.showListener);
        }
    }

    public void tick(double time) {
        double ufs;
        this.serialTime += time;
        if (this.currentExamination != null && (ufs = this.currentExamination.getUpdateFrequencySeconds()) > 0.0 && this.serialTime > ufs) {
            this.currentExamination.initialise(this.body);
            this.serialTime = 0.0;
        }
    }

    private void jbInit() throws Exception {
        this.border1 = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        this.jPanel1.setLayout(this.borderLayout1);
        this.okbutton.setText("OK");
        this.okbutton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ExaminationsDialog.this.okbutton_actionPerformed(e);
            }
        });
        this.jPanel2.setLayout(this.borderLayout2);
        this.jPanel4.setLayout(this.borderLayout3);
        this.jScrollPane1.setPreferredSize(new Dimension(159, 131));
        this.jPanel6.setLayout(this.borderLayout4);
        this.jLabel1.setText("Select examination");
        this.jPanel5.setLayout(this.borderLayout5);
        this.jPanel5.setBorder(this.border1);
        this.exampanel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.exampanel.setLayout(this.borderLayout6);
        this.examlist.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                ExaminationsDialog.this.examlist_valueChanged(e);
            }
        });
        this.examlist.setModel(this.examlistmodel);
        this.helpbutton.setAction(this.helpAction);
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.jPanel1.add((Component)this.jPanel2, "Center");
        this.jPanel2.add((Component)this.jPanel4, "West");
        this.jPanel4.add((Component)this.jPanel6, "Center");
        this.jPanel6.add((Component)this.jScrollPane1, "Center");
        this.jPanel4.add((Component)this.jPanel7, "North");
        this.jPanel7.add((Component)this.jLabel1, null);
        this.jScrollPane1.getViewport().add((Component)this.examlist, null);
        this.jPanel2.add((Component)this.jPanel5, "Center");
        this.jPanel5.add((Component)this.jPanel8, "South");
        this.jPanel5.add((Component)this.exampanel, "Center");
        this.jPanel1.add((Component)this.jPanel3, "South");
        this.jPanel3.add((Component)this.okbutton, null);
        this.jPanel3.add((Component)this.helpbutton, null);
    }

    void okbutton_actionPerformed(ActionEvent e) {
        this.hide();
    }

    void setExamination(Examination e) {
        if (this.currentExamDisplay != null) {
            this.exampanel.remove(this.currentExamDisplay);
        }
        this.currentExamDisplay = e.createPanel();
        if (this.body != null) {
            e.initialise(this.body);
        }
        this.exampanel.add(this.currentExamDisplay);
        this.exampanel.invalidate();
        this.exampanel.validate();
        this.exampanel.repaint();
        this.currentExamination = e;
    }

    void initialiseList() {
        int i = 0;
        while (i < this.examinations.length) {
            try {
                Examination newExam = (Examination)this.examinations[i].newInstance();
                this.examlistmodel.addElement(newExam);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    void examlist_valueChanged(ListSelectionEvent e) {
        int selection = this.examlist.getSelectedIndex();
        if (selection != this.lastSelection) {
            this.lastSelection = selection;
            this.setExamination((Examination)this.examlist.getSelectedValue());
        }
    }
}

