/*
 * Decompiled with CFR 0.152.
 */
package phic.gui.exam;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import javax.swing.event.MouseInputAdapter;
import phic.Resource;

public class BloodFilmPanel
extends JPanel {
    int xx;
    int yy;
    Input input = new Input();
    MediaTracker mt;
    static final int ERYTHROCYTES = 0;
    static final int LYMPHOCYTES = 1;
    String[] cellNames = new String[]{"Erythrocytes", "Lymphocytes"};
    Image[] cellImages = new Image[this.cellNames.length];
    double[] cellFrequency = new double[]{5000.0, 10.0};
    int fwidth = 1000;
    int fheight = 1000;
    double opacity = 0.5;
    double opacityVariability = 0.1f;
    double cellSize = 1.0;
    double cellSizeVariability = 0.1;
    double thickness = 2.0;
    BufferedImage film;
    boolean filmLoaded = false;

    public BloodFilmPanel() {
        this.setBackground(new Color(224, 255, 255));
        this.mt = new MediaTracker(this);
        int i = 0;
        while (i < this.cellNames.length) {
            this.cellImages[i] = Resource.loader.getImageResource(String.valueOf(this.cellNames[i]) + ".gif");
            this.mt.addImage(this.cellImages[i], 0);
            ++i;
        }
        this.addMouseListener(this.input);
        this.addMouseMotionListener(this.input);
    }

    public void tryCreateFilm() {
        new Thread(new Runnable(){

            public void run() {
                BloodFilmPanel.this.filmLoaded = false;
                BloodFilmPanel.this.repaint();
                try {
                    BloodFilmPanel.this.mt.waitForAll();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                BloodFilmPanel.this.createFilm();
                BloodFilmPanel.this.filmLoaded = true;
                BloodFilmPanel.this.repaint();
            }
        }).start();
    }

    private void createFilm() {
        this.film = new BufferedImage(this.fwidth, this.fheight, 2);
        int area = this.fwidth * this.fheight;
        Graphics2D g2 = this.film.createGraphics();
        int i = 0;
        while (i < this.cellNames.length) {
            double ch = this.cellImages[i].getHeight(this);
            double cw = this.cellImages[i].getWidth(this);
            int number = (int)(this.thickness * (double)area * this.cellFrequency[i] / 1000000.0);
            int j = 0;
            while (j < number) {
                g2.setComposite(AlphaComposite.getInstance(3, Math.max(0.0f, Math.min(1.0f, (float)(0.4 * this.opacity + (Math.random() - 0.5) * this.opacityVariability)))));
                double sz = this.cellSize * (1.0 + (Math.random() - 0.5) * this.cellSizeVariability);
                g2.drawImage(this.cellImages[i], (int)(Math.random() * (double)this.fwidth), (int)(Math.random() * (double)this.fheight), (int)(cw * sz), (int)(ch * sz), this);
                ++j;
            }
            ++i;
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.film != null) {
            g.drawImage(this.film, this.xx, this.yy, this);
        }
        if (!this.filmLoaded) {
            g.drawString("Creating blood film...", 20, 20);
        }
    }

    class Input
    extends MouseInputAdapter {
        Point point;

        Input() {
        }

        public void mousePressed(MouseEvent e) {
            this.point = e.getPoint();
        }

        public void mouseDragged(MouseEvent e) {
            BloodFilmPanel.this.xx += e.getX() - this.point.x;
            BloodFilmPanel.this.yy += e.getY() - this.point.y;
            BloodFilmPanel.this.xx = Math.max(Math.min(BloodFilmPanel.this.xx, 0), BloodFilmPanel.this.getWidth() - BloodFilmPanel.this.fwidth);
            BloodFilmPanel.this.yy = Math.max(Math.min(BloodFilmPanel.this.yy, 0), BloodFilmPanel.this.getHeight() - BloodFilmPanel.this.fheight);
            this.point = e.getPoint();
            BloodFilmPanel.this.repaint();
        }
    }
}

