/*
 * Decompiled with CFR 0.152.
 */
package phic.gui.exam;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.swing.Timer;
import phic.gui.exam.Auscultation;

public class AuscultationImpl
extends Auscultation {
    AudioFormat af;
    SourceDataLine sdl;
    protected boolean running;
    public static final int samplesPerSecond = 44100;
    public static final int bytesPerSample = 1;
    byte[] buf;
    ActionListener timerAction;
    int maxSample;
    double[] freq;
    double[] time;
    int NR;
    public static final int TIMER_DELAY = 250;
    Timer timer;
    int sscale;
    double A;
    double mu;

    public AuscultationImpl() {
        block2: {
            this.af = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 44100.0f, 8, 1, 1, 44100.0f, false);
            this.running = false;
            this.buf = new byte[44100];
            this.timerAction = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AuscultationImpl.this.tick(0.0);
                }
            };
            this.maxSample = 256;
            this.freq = new double[100];
            this.time = new double[100];
            this.NR = 10;
            this.timer = new Timer(250, this.timerAction);
            this.sscale = 120;
            this.A = 87.6;
            this.mu = 255.0;
            try {
                this.sdl = (SourceDataLine)AudioSystem.getLine(new DataLine.Info(SourceDataLine.class, this.af));
            }
            catch (LineUnavailableException ex) {
                ex.printStackTrace();
                if (this.body == null) break block2;
                this.body.error("Sound unavailable :" + ex.toString());
            }
        }
    }

    public void startSound() {
        block2: {
            try {
                this.sdl.open();
                this.sdl.start();
                this.running = true;
                this.timer.start();
            }
            catch (LineUnavailableException ex) {
                ex.printStackTrace();
                if (this.body == null) break block2;
                this.body.error("Sound unavailable :" + ex.toString());
            }
        }
    }

    public void stopSound() {
        this.timer.stop();
        this.running = false;
        this.sdl.stop();
        this.sdl.close();
    }

    public void finalize() throws Throwable {
        super.finalize();
        this.stopSound();
    }

    public void tick(double t) {
        if (this.running && !this.body.clock.running) {
            this.stopSound();
            return;
        }
        if (this.body.clock.running && !this.running) {
            this.startSound();
        }
        if (!this.running || this.body == null) {
            return;
        }
        int n = this.sdl.available();
        if (n <= 0) {
            return;
        }
        double initHPhase = this.body.CVS.heart.phase;
        double initRPhase = this.body.lungs.phase;
        double HR = this.body.CVS.heart.rate.get();
        double RR = this.body.lungs.RespR.get();
        double pulmOed = Math.min(1.0, Math.max(0.0, 2.0 * (this.body.lungs.Oedema.get() - 0.2)));
        double aorticRegurg = this.body.CVS.heart.aorticRegurg.get() * this.nearness(0.0, 0.0, 0.2);
        double aorticStenosis = this.body.CVS.heart.aorticStenosis.get();
        double mitralRegurg = this.body.CVS.heart.mitralRegurg.get() * this.nearness(0.0, 0.0, 0.2);
        double mitralStenosis = this.body.CVS.heart.mitralRegurg.get() * this.nearness(0.2, 0.0, 0.2);
        double CO = this.body.CVS.heart.CO.get();
        int waitingSamples = (this.sdl.getBufferSize() - n) / 1;
        n = Math.min(n, this.buf.length) / 1;
        double twoPiBeat = Math.PI * 2 / (HR / 60.0);
        double twoPiBreath = Math.PI * 2 / (RR / 60.0);
        double lastbreathsample = 0.0;
        double lop = 0.0;
        double hs1 = 1.0 * this.nearness(0.2, 0.1, 0.2);
        double hs2 = 0.8 * this.nearness(0.0, -0.1, 0.2);
        hs2 *= aorticStenosis < 0.2 ? 1.0 : (aorticStenosis < 0.5 ? 1.0 - (aorticStenosis - 0.2) / 0.3 : 0.0);
        double asMurmur = this.nearness(0.0, -0.3, 0.3) * Math.min(1.0 - 4.0 * (aorticStenosis - 0.5) * (aorticStenosis - 0.5), 1.0);
        double bs = 0.02 * this.nearness(0.0, 0.0, 1.0);
        int i = 0;
        while (i < n) {
            double hph = (initHPhase + HR / 60.0 * (double)(i + waitingSamples) / 44100.0) % 1.0;
            double rph = (initRPhase + RR / 60.0 * (double)(i + waitingSamples) / 44100.0) % 1.0;
            double dt = 2.2675736961451248E-5;
            double hs2ph = hph - 0.5;
            double hs1ph = hph - 0.1;
            double aovel = Math.max(0.0, CO / 5.0 * Math.exp(-200.0 * (hph - 0.3) * (hph - 0.3)));
            double airvel = this.breathAmpl(rph);
            double nextSample = hs1 * (hs1ph > -0.09 ? Math.exp(-9000.0 * hs1ph * hs1ph) * Math.sin(150.0 * twoPiBeat * hs1ph) : 0.0) + hs2 * (hs2ph > 0.0 ? Math.exp(-90.0 * hs2ph) * Math.sin(120.0 * twoPiBeat * hs2ph) : 0.0) + asMurmur * 0.3 * aovel * this.noiseCentred(0, 400.0 + aovel * 100.0, 0.6, dt) + aorticRegurg * 0.1 * (hs2ph > 0.0 ? Math.exp(-50.0 * (1.0 - aorticRegurg) * hs2ph) * Math.random() : 0.0) + bs * airvel * this.noiseCentred(1, 200.0 + 300.0 * airvel, 0.6, dt) + bs * 15.0 * pulmOed * (double)(Math.random() < pulmOed * 0.02 ? 1 : 0) * Math.exp(-150.0 * (rph - 0.25) * (rph - 0.25));
            nextSample = Math.max(-1.0, Math.min(1.0, nextSample));
            int intSample = (int)(0.4 * (double)this.maxSample * nextSample);
            this.buf[i * 1] = (byte)intSample;
            ++i;
        }
        this.sdl.write(this.buf, 0, n * 1);
    }

    double breathAmpl(double phase) {
        return phase < 0.3 ? Math.exp(-80.0 * (phase - 0.15) * (phase - 0.15)) * 0.8 : Math.exp(-10.0 * (phase - 0.65) * (phase - 0.65)) * Math.exp(-2.0 * (phase - 0.3)) * Math.exp(-1.0 * (phase - 0.5));
    }

    public double noiseCentredF(int channel, double centreFreq, double bandWidth, double dt) {
        int n = channel;
        this.time[n] = this.time[n] + dt;
        if (this.freq[channel] == 0.0) {
            this.freq[channel] = centreFreq;
        }
        if (this.time[channel] > 1.0 / this.freq[channel] || this.freq[channel] < 20.0) {
            this.time[channel] = 0.0;
            this.freq[channel] = centreFreq * (1.0 - bandWidth / 2.0 + bandWidth * Math.random());
        }
        return Math.cos(this.freq[channel] * 2.0 * Math.PI * this.time[channel]);
    }

    void initWheeze(int channels, double centreFreq, double bandWidth) {
        int i = 50;
        while (i < channels + 50) {
            this.freq[i] = centreFreq + (Math.random() - 0.5) * bandWidth;
            ++i;
        }
    }

    public double wheeze(int channels, double centreFreq, double bandWidth, double dt) {
        double sum = 0.0;
        int i = 50;
        while (i < channels + 50) {
            if (this.freq[i] == 0.0) {
                this.freq[i] = centreFreq + (Math.random() - 0.5) * bandWidth;
            }
            int n = i;
            this.time[n] = this.time[n] + dt;
            sum += Math.sin(this.freq[i] * 2.0 * Math.PI * this.time[i]);
            ++i;
        }
        return sum;
    }

    public double noiseCentred(int channel, double centreFreq, double bandWidth, double dt) {
        double x = 0.0;
        int i = 0;
        while (i < this.NR) {
            x += this.noiseCentredF(this.NR * channel + i, centreFreq, bandWidth, dt);
            ++i;
        }
        return x;
    }

    public double nearness(double x, double y, double s) {
        double t = x - this.xcoord;
        double d = t * t;
        t = y - this.ycoord;
        return Math.exp(-(d + t * t) / (s * s));
    }

    public byte packByte(double value) {
        int sgn = value >= 0.0 ? 1 : -1;
        int v = Math.abs((int)(100.0 * value));
        v = Math.max(0, Math.min(127, v));
        return (byte)(v + 128);
    }

    byte reverseBits(byte b) {
        return (byte)(b / 128 + 2 * (b / 64 & 1) + 4 * (b / 32 & 1) + 8 * (b / 16 & 1) + 16 * (b / 8 & 1) + 32 * (b / 4 & 1) + 64 * (b / 2 & 1) + 128 * (b & 1));
    }
}

