/*
 * Decompiled with CFR 0.152.
 */
package phic.gui.exam;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import javax.swing.JLabel;
import javax.swing.JPanel;
import medicine.Entity;
import phic.Body;
import phic.Resource;
import phic.gui.exam.Auscultation;
import phic.gui.exam.Examination;

public class AuscultationExam
extends JPanel
implements Examination {
    Image image;
    Body body;
    Auscultation auscultation = Auscultation.createAuscultation();
    JLabel jLabel1 = new JLabel(){

        public void paint(Graphics g) {
            super.paint(g);
            g.drawImage(AuscultationExam.this.image, 0, 0, this.getWidth(), this.getHeight(), AuscultationExam.this);
        }
    };
    BorderLayout borderLayout1 = new BorderLayout();
    JLabel textlabel = new JLabel("Hold mouse button to listen");
    double oldSecond = 1000.0;
    MyMouseListener ml = new MyMouseListener();

    public AuscultationExam() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.image = Resource.loader.getImageResource("diagram/chest.jpg");
        this.jLabel1.setOpaque(true);
    }

    public JPanel createPanel() {
        return this;
    }

    public void initialise(Body body) {
        this.body = body;
        this.auscultation.setBody(body);
    }

    public Entity[] getPathologies() {
        return null;
    }

    public Entity[] getSigns() {
        return null;
    }

    public String getName() {
        return "Auscultation";
    }

    public double getUpdateFrequencySeconds() {
        return 6.0;
    }

    private void jbInit() throws Exception {
        this.jLabel1.addMouseMotionListener(this.ml);
        this.jLabel1.addMouseListener(this.ml);
        this.setLayout(this.borderLayout1);
        this.add((Component)this.jLabel1, "Center");
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.add((Component)this.textlabel, "South");
    }

    public String toString() {
        return "Auscultation of chest";
    }

    public Point2D map(Point p, Component c) {
        return new Point2D.Double(p.getX() / (double)c.getWidth() - 0.5, p.getY() / (double)c.getHeight() - 0.5);
    }

    class MyMouseListener
    extends MouseAdapter
    implements MouseMotionListener {
        MyMouseListener() {
        }

        public void mousePressed(MouseEvent e) {
            boolean dead;
            if (AuscultationExam.this.body.clock.getSecond() != 1000.0) {
                AuscultationExam.this.oldSecond = AuscultationExam.this.body.clock.getSecond();
                AuscultationExam.this.body.clock.setSecond(1000.0);
            }
            boolean bl = dead = AuscultationExam.this.body.brain.getFeeling() == 3;
            if (!AuscultationExam.this.body.clock.running && !dead) {
                AuscultationExam.this.body.clock.start();
            }
            Point2D p = AuscultationExam.this.map(e.getPoint(), (Component)e.getSource());
            AuscultationExam.this.auscultation.setCoordinates(p.getX(), p.getY());
            if (!dead) {
                AuscultationExam.this.auscultation.startSound();
            }
        }

        public void mouseDragged(MouseEvent e) {
            Point2D p = AuscultationExam.this.map(e.getPoint(), (Component)e.getSource());
            AuscultationExam.this.auscultation.setCoordinates(p.getX(), p.getY());
        }

        public void mouseReleased(MouseEvent e) {
            AuscultationExam.this.auscultation.stopSound();
        }

        public void mouseMoved(MouseEvent e) {
        }
    }
}

