/*
 * Decompiled with CFR 0.152.
 */
package phic.gui;

import java.awt.event.ActionEvent;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JPanel;
import phic.Current;
import phic.common.LifeSupport;
import phic.common.Table;
import phic.common.UnitConstants;
import phic.gui.LifeSupportDialog;
import phic.gui.PhicApplication;
import phic.gui.PhicFrameActions;
import phic.gui.SimplePhicFrame;
import phic.gui.VDoubleNode;
import phic.gui.VariableEquationsPanel;
import phic.gui.VariablePropertiesDialog;

public class VisibleVariable {
    private boolean hasInitialisedOnce = false;
    public double minimum;
    public double initial;
    public double maximum;
    public int units;
    public int type;
    public VDoubleNode node;
    public String canonicalName;
    public String longName;
    public String shortName;
    private boolean isOverridden = false;
    private String overriddenUnit = null;
    private double overriddenConversion = Double.NaN;
    Action setNormalUnitAction;
    Action setOverriddenUnitAction;
    public Action showVariableInfoBox = new AbstractAction("Info"){

        public void actionPerformed(ActionEvent e) {
            VisibleVariable.this.displayVariableDialog();
        }
    };
    public Action showVariableEqnsBox = new AbstractAction("Equations"){

        public void actionPerformed(ActionEvent e) {
            VisibleVariable.this.displayEqnsDialog();
        }
    };
    public Action resetVariableValue = new AbstractAction("Reset"){

        public boolean isEnabled() {
            return VisibleVariable.this.type != 2 && VisibleVariable.this.type != 0;
        }

        public void actionPerformed(ActionEvent e) {
            Current.environment.getVariableClamps().setFudgeVariable(VisibleVariable.this, false);
            VisibleVariable.this.initialise();
        }
    };
    public Action clampVariable = new AbstractAction("Clamp value"){

        public boolean isEnabled() {
            return VisibleVariable.this.type != 2 && VisibleVariable.this.type != 0;
        }

        public Object getValue(String key) {
            boolean f = Current.environment.getVariableClamps().isFudgeVariable(VisibleVariable.this);
            if (key.equals("Name")) {
                return !f ? "Clamp value" : "Unclamp value";
            }
            if (key.equals("ShortDescription")) {
                return !f ? "Fix the variable's value at its current value" : "Calculate variable's value normally";
            }
            return super.getValue(key);
        }

        public void actionPerformed(ActionEvent e) {
            VisibleVariable v;
            LifeSupport ls = Current.environment.getVariableClamps();
            if (!ls.isFudgeVariable(v = VisibleVariable.this)) {
                ls.setFudgeVariable(v, true);
                ls.setFudgeValue(v, v.node.doubleGetVal());
                LifeSupportDialog lsd = new LifeSupportDialog(ls);
                lsd.setSelection(v);
                lsd.valuetxt.grabFocus();
                lsd.show();
            } else {
                ls.setFudgeVariable(v, false);
            }
        }
    };

    public VisibleVariable(Table t, int i) {
        this.canonicalName = t.getString(i, 7);
        this.longName = t.getString(i, 6);
        this.shortName = t.getString(i, 5);
        this.initial = t.getDouble(i, 0);
        this.minimum = t.getDouble(i, 1);
        this.maximum = t.getDouble(i, 2);
        this.units = (int)t.getDouble(i, 3);
        this.type = (int)t.getDouble(i, 4);
        StringTokenizer e = new StringTokenizer(this.canonicalName, ".");
        AccessibleObject member = null;
        boolean isfield = true;
        boolean firstnode = true;
        String node = e.nextToken();
        Object object = node.equals("body") ? Current.body : Current.environment;
        while (e.hasMoreElements()) {
            node = e.nextToken();
            if (node == null) {
                Current.body.error("null node string");
                break;
            }
            if (!firstnode) {
                if (member == null) {
                    Current.body.error("null node member " + object + "=" + this.canonicalName);
                    break;
                }
                try {
                    object = isfield ? ((Field)member).get(object) : ((Method)member).invoke(object, new Object[0]);
                }
                catch (Exception x) {
                    x.printStackTrace();
                    break;
                }
            }
            firstnode = false;
            if (object == null) {
                System.out.println("err");
            }
            try {
                member = object.getClass().getField(node);
                isfield = true;
            }
            catch (NoSuchFieldException x) {
                try {
                    member = object.getClass().getMethod(node, new Class[0]);
                    isfield = false;
                }
                catch (NoSuchMethodException y) {
                    Current.body.error("cannot find node " + node + " at " + this.canonicalName);
                }
            }
        }
        this.node = new VDoubleNode((Member)((Object)member), object, null);
        this.node.getVDouble().setUnit(this.units);
        this.checkOverridden();
    }

    public void initialiseFromScratch() {
        if (this.node != null) {
            if (this.node.getType() == 2) {
                this.node.doubleSetVal(this.initial);
                this.node.vdoubleSetRanges(this.initial, this.minimum, this.maximum);
            } else if (this.node.getType() == 3) {
                this.node.booleanSetVal(this.initial != 0.0);
            }
        } else {
            Current.body.error("Could not initialise " + this.canonicalName);
        }
    }

    public void initialise() {
        if (!this.hasInitialisedOnce) {
            this.initialiseFromScratch();
            this.hasInitialisedOnce = true;
            return;
        }
        if (this.node != null) {
            if (this.node.getType() == 2) {
                this.node.doubleSetVal(this.node.getVDouble().initialValue);
            } else if (this.node.getType() == 3) {
                this.node.booleanSetVal(this.node.getVDouble().initialValue != 0.0);
            }
        }
    }

    public void checkOverridden() {
        this.setOverridden(UnitConstants.getUseUnitOverrides() && UnitConstants.canVariableBeOverridden(this.canonicalName));
    }

    public String formatValue(double v, boolean showUnit, boolean fixed) {
        if (!this.isOverridden) {
            return UnitConstants.formatValue(v, this.units, showUnit, fixed);
        }
        String s = UnitConstants.formatValue(v * this.overriddenConversion, 14, showUnit, fixed);
        if (showUnit) {
            s = String.valueOf(s.substring(0, s.length() - 1)) + this.overriddenUnit;
        }
        return s;
    }

    public void displayVariableDialog() {
        VariablePropertiesDialog d = new VariablePropertiesDialog();
        d.setVariable(this);
        d.show();
    }

    public void displayEqnsDialog() {
        PhicFrameActions cfr_ignored_0 = ((SimplePhicFrame)((Object)PhicApplication.frame)).frameActions;
        VariableEquationsPanel.Dialog m = PhicFrameActions.variableEquationsPanel.createDialog();
        m.setFilter(this);
        m.setVisible(true);
    }

    public void setOverridden(boolean b) {
        this.isOverridden = b;
        if (this.isOverridden) {
            this.overriddenUnit = UnitConstants.getOverriddenUnit(this.canonicalName);
            this.overriddenConversion = UnitConstants.getOverridenConversion(this.canonicalName);
        }
    }

    public String toString() {
        if (this.node == null) {
            return this.longName;
        }
        return this.longName;
    }

    public JMenu createUnitsMenu() {
        if (!UnitConstants.canVariableBeOverridden(this.canonicalName)) {
            return null;
        }
        JMenu m = new JMenu("Unit");
        if (this.setNormalUnitAction == null) {
            this.setNormalUnitAction = new SetUnitAction(false, UnitConstants.ustring[this.units]);
            this.setOverriddenUnitAction = new SetUnitAction(true, UnitConstants.getOverriddenUnit(this.canonicalName));
        }
        m.add(this.setNormalUnitAction);
        m.add(this.setOverriddenUnitAction);
        return m;
    }

    public JPanel getVariableCausalEquations() {
        PhicFrameActions cfr_ignored_0 = ((SimplePhicFrame)((Object)PhicApplication.frame)).frameActions;
        VariableEquationsPanel p = PhicFrameActions.variableEquationsPanel;
        p.setFilter(this, true);
        return p;
    }

    class SetUnitAction
    extends AbstractAction {
        boolean override;

        SetUnitAction(boolean override, String name) {
            super(name);
            this.override = override;
        }

        SetUnitAction(boolean override, String name, Icon icon) {
            super(name, icon);
            this.override = override;
        }

        public void actionPerformed(ActionEvent e) {
            VisibleVariable.this.setOverridden(this.override);
        }
    }
}

