/*
 * Decompiled with CFR 0.152.
 */
package phic.gui;

import phic.common.Table;
import phic.common.VDouble;
import phic.gui.Node;
import phic.gui.VisibleVariable;

public class Variables {
    private static Table table = new Table("Variables.txt", 8);
    public static VisibleVariable[] variable = new VisibleVariable[Variables.table.nRows];

    static {
        Variables.initialiseVariables();
    }

    public static void initialiseVariables() {
        System.out.print("Loading variables...");
        int i = 0;
        while (i < Variables.table.nRows) {
            try {
                Variables.variable[i] = new VisibleVariable(table, i);
            }
            catch (IllegalArgumentException x) {
                System.out.println("Error in Variables.txt: item " + i + ", " + table.getString(i, 6) + ". Line reads\n" + Variables.join(table.line(i), ","));
                throw x;
            }
            ++i;
        }
        System.out.println("complete.");
    }

    public static String join(String[] s, String d) {
        StringBuffer t = new StringBuffer();
        int i = 0;
        while (i < s.length) {
            t.append(String.valueOf(s[i]) + d);
            ++i;
        }
        return t.toString();
    }

    public static VisibleVariable forName(String canonicalName) {
        String c = canonicalName.replace('/', '.');
        if (c.startsWith(".")) {
            c = c.substring(1);
        }
        int i = 0;
        while (i < variable.length) {
            if (Variables.variable[i].canonicalName.equalsIgnoreCase(c)) {
                return variable[i];
            }
            ++i;
        }
        i = 0;
        while (i < variable.length) {
            if (Variables.variable[i].shortName.equalsIgnoreCase(c)) {
                return variable[i];
            }
            if (Variables.variable[i].shortName.replace('$', '2').equalsIgnoreCase(c)) {
                return variable[i];
            }
            if (Variables.variable[i].longName.equalsIgnoreCase(c)) {
                return variable[i];
            }
            if (Variables.variable[i].canonicalName.equalsIgnoreCase("body." + c)) {
                return variable[i];
            }
            if (Variables.variable[i].canonicalName.equalsIgnoreCase("environment." + c)) {
                return variable[i];
            }
            ++i;
        }
        throw new IllegalArgumentException("No such variable " + canonicalName);
    }

    public static VisibleVariable forNode(Node n) {
        if (n == null) {
            return null;
        }
        int i = 0;
        while (i < variable.length) {
            if (variable[i] != null && Variables.variable[i].node != null && Variables.variable[i].node.member != null && Variables.variable[i].node.object != null && Variables.variable[i].node.member.equals(n.member) && Variables.variable[i].node.object.equals(n.object)) {
                return variable[i];
            }
            ++i;
        }
        return null;
    }

    public static VisibleVariable forVDouble(VDouble vd) throws IllegalArgumentException {
        int i = 0;
        while (i < variable.length) {
            if (Variables.variable[i].node.getVDouble() == vd) {
                return variable[i];
            }
            ++i;
        }
        throw new IllegalArgumentException();
    }

    public static void initialise() {
        int i = 0;
        while (i < variable.length) {
            variable[i].initialise();
            ++i;
        }
    }

    public static void initialiseBodyValues() {
        int i = 0;
        while (i < variable.length) {
            if (Variables.variable[i].node.canonicalName().startsWith("/Body")) {
                variable[i].initialise();
            }
            ++i;
        }
    }

    public static void recheckOverridden() {
        int i = 0;
        while (i < variable.length) {
            variable[i].checkOverridden();
            ++i;
        }
    }
}

