/*
 * Decompiled with CFR 0.152.
 */
package phic.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import phic.gui.OldNodeView;
import phic.gui.Variables;
import phic.gui.VisibleVariable;

public class VariableSelectionCombo
extends JComboBox
implements ActionListener {
    JTextField f;
    DefaultComboBoxModel varmodel = new DefaultComboBoxModel();
    Object previousSelection = null;
    public Runnable acceptListener;
    boolean updating;
    VisibleVariable selectedVariable;
    OldNodeView.Type selectedDisplay;
    boolean selectedScrollGraph = false;

    public VariableSelectionCombo() {
        this.addActionListener(this);
        this.setModel(this.varmodel);
        this.setEditable(true);
        if (this.getEditor().getEditorComponent() instanceof JTextField) {
            this.f = (JTextField)this.getEditor().getEditorComponent();
            this.f.getDocument().addDocumentListener(new DocumentListener(){

                public void changedUpdate(DocumentEvent e) {
                }

                public void insertUpdate(DocumentEvent e) {
                    if (!VariableSelectionCombo.this.updating) {
                        VariableSelectionCombo.this.editChange();
                    }
                }

                public void removeUpdate(DocumentEvent e) {
                    if (!VariableSelectionCombo.this.updating) {
                        VariableSelectionCombo.this.editChange();
                    }
                }
            });
        }
    }

    public void editChange() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                String s = VariableSelectionCombo.this.f.getText();
                Object o = VariableSelectionCombo.this.getSelectedItem();
                if (VariableSelectionCombo.this.previousSelection != s && (o == null || o instanceof String || o instanceof VisibleVariable && !((VisibleVariable)o).longName.equals(s))) {
                    VariableSelectionCombo.this.updating = true;
                    VariableSelectionCombo.this.previousSelection = s;
                    VariableSelectionCombo.this.updating = false;
                }
            }
        });
    }

    public void actionPerformed(ActionEvent e) {
        Object o = this.getSelectedItem();
        if (o != this.previousSelection) {
            if (o instanceof String) {
                String s = o.toString();
                this.updateList(s);
            }
            this.previousSelection = o;
        } else {
            this.okAction();
        }
    }

    void updateList(Object o) {
        String s = o == null ? "" : o.toString();
        this.hidePopup();
        this.varmodel.removeAllElements();
        int i = 0;
        while (i < Variables.variable.length) {
            VisibleVariable v = Variables.variable[i];
            String slc = s.toLowerCase();
            if (v.shortName.toLowerCase().startsWith(slc)) {
                this.varmodel.addElement(v);
            } else if (v.longName.toLowerCase().startsWith(slc)) {
                this.varmodel.addElement(v);
            } else if (v.canonicalName.toLowerCase().startsWith(slc)) {
                this.varmodel.addElement(v);
            }
            ++i;
        }
        if (this.isShowing()) {
            this.showPopup();
        }
        this.f.setText(s);
        this.f.setCaretPosition(s.length());
    }

    void okAction() {
        Object o = this.getSelectedItem();
        if (this.acceptListener != null) {
            this.acceptListener.run();
        }
    }
}

