/*
 * Decompiled with CFR 0.152.
 */
package phic.gui;

import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLEditorKit;
import phic.Current;
import phic.Resource;
import phic.common.IniReader;
import phic.common.VDouble;
import phic.common.VDoubleReadOnly;
import phic.gui.ReferenceValuesPanel;
import phic.gui.ValueInput;
import phic.gui.Variables;
import phic.gui.VisibleVariable;
import phic.modifiable.Controller;

public class VariablePropertiesPanel
extends JPanel {
    BorderLayout borderLayout1 = new BorderLayout();
    JTabbedPane jTabbedPane1 = new JTabbedPane();
    JPanel jPanel1 = new JPanel();
    JPanel jPanel2 = new JPanel();
    Box box4;
    JLabel jLabel4 = new JLabel();
    JTextField initialvaluetxt = new JTextField();
    Box box5;
    JLabel jLabel5 = new JLabel();
    ValueInput currentvaluetxt = new ValueInput();
    JPanel jPanel3 = new JPanel();
    Border border1;
    TitledBorder titledBorder1;
    Box box6;
    JTextField lowerrangetxt = new JTextField();
    JTextField higherrangetxt = new JTextField();
    JLabel jLabel6 = new JLabel();
    JPanel jPanel4 = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    JPanel jPanel5 = new JPanel();
    BorderLayout borderLayout3 = new BorderLayout();
    ReferenceValuesPanel referencevaluespanel;
    ActionListener variableListener = null;
    IniReader info = new IniReader("VariableInfo.txt");
    VisibleVariable v = null;
    JScrollPane jScrollPane1 = new JScrollPane();
    JEditorPane infotext = new JEditorPane();
    Box box7;
    JTextField canonicalnametxt = new JTextField();
    JLabel jLabel2 = new JLabel();
    JTextField fullnametxt = new JTextField();
    Box box2;
    JLabel jLabel1 = new JLabel();
    JLabel jLabel3 = new JLabel();
    JTextField shortnametxt = new JTextField();
    Box box1;
    Box box3;
    BorderLayout borderLayout4 = new BorderLayout();
    String unit = "";
    String prevValText = "";
    boolean addControllers = false;
    JLabel unittxt = new JLabel();

    public VariablePropertiesPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.infotext.setEditorKit(new HTMLEditorKit());
        this.infotext.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent e) {
                String s;
                VisibleVariable v;
                if (e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED) && (v = Variables.forName(s = e.getDescription())) != null) {
                    VariablePropertiesPanel.this.setVariable(v);
                    if (VariablePropertiesPanel.this.variableListener != null) {
                        VariablePropertiesPanel.this.variableListener.actionPerformed(new ActionEvent(this, 0, v.longName));
                    }
                }
            }
        });
    }

    public void addVariableListener(ActionListener al) {
        this.variableListener = AWTEventMulticaster.add(al, this.variableListener);
    }

    public void remvoveVariableListener(ActionListener al) {
        this.variableListener = AWTEventMulticaster.remove(al, this.variableListener);
    }

    private void jbInit() throws Exception {
        this.box4 = Box.createHorizontalBox();
        this.box5 = Box.createHorizontalBox();
        this.border1 = BorderFactory.createEtchedBorder();
        this.titledBorder1 = new TitledBorder(this.border1, "Normal range");
        this.box6 = Box.createHorizontalBox();
        this.box7 = Box.createVerticalBox();
        this.box2 = Box.createHorizontalBox();
        this.box1 = Box.createHorizontalBox();
        this.box3 = Box.createHorizontalBox();
        this.setLayout(this.borderLayout1);
        this.jPanel1.setLayout(this.borderLayout4);
        this.jLabel4.setPreferredSize(new Dimension(73, 17));
        this.jLabel4.setText("Initial value");
        this.initialvaluetxt.setPreferredSize(new Dimension(90, 21));
        this.initialvaluetxt.setEditable(false);
        this.jLabel5.setText("Current value");
        this.currentvaluetxt.setPreferredSize(new Dimension(90, 21));
        this.jPanel3.setBorder(this.titledBorder1);
        this.lowerrangetxt.setPreferredSize(new Dimension(80, 21));
        this.lowerrangetxt.setEditable(false);
        this.higherrangetxt.setPreferredSize(new Dimension(80, 21));
        this.higherrangetxt.setEditable(false);
        this.jLabel6.setText("--");
        this.jPanel4.setLayout(this.borderLayout2);
        this.infotext.setEditable(false);
        this.jPanel5.setLayout(this.borderLayout3);
        this.canonicalnametxt.setEditable(false);
        this.jLabel2.setPreferredSize(new Dimension(91, 17));
        this.jLabel2.setText("Full name");
        this.fullnametxt.setEditable(false);
        this.jLabel1.setPreferredSize(new Dimension(91, 17));
        this.jLabel1.setText("Long name");
        this.jLabel3.setPreferredSize(new Dimension(91, 17));
        this.jLabel3.setText("Short name");
        this.shortnametxt.setEditable(false);
        this.unittxt.setText(" ");
        this.add((Component)this.jTabbedPane1, "Center");
        this.jPanel1.add((Component)this.box7, "North");
        this.box2.add((Component)this.jLabel2, null);
        this.box2.add((Component)this.canonicalnametxt, null);
        this.box7.add((Component)this.box1, null);
        this.box1.add((Component)this.jLabel1, null);
        this.box1.add((Component)this.fullnametxt, null);
        this.box7.add((Component)this.box3, null);
        this.box3.add((Component)this.jLabel3, null);
        this.box3.add((Component)this.shortnametxt, null);
        this.box7.add((Component)this.box2, null);
        this.jPanel2.add((Component)this.box4, null);
        this.box4.add((Component)this.jLabel4, null);
        this.box4.add((Component)this.initialvaluetxt, null);
        this.jPanel2.add((Component)this.box5, null);
        this.box5.add((Component)this.jLabel5, null);
        this.box5.add((Component)this.currentvaluetxt, null);
        this.jPanel2.add((Component)this.jPanel3, null);
        this.jPanel3.add((Component)this.box6, null);
        this.box6.add((Component)this.lowerrangetxt, null);
        this.box6.add((Component)this.jLabel6, null);
        this.box6.add((Component)this.higherrangetxt, null);
        this.jTabbedPane1.add((Component)this.jPanel4, "Info");
        this.jTabbedPane1.add((Component)this.jPanel2, "Values");
        this.jPanel4.add((Component)this.jScrollPane1, "Center");
        this.jScrollPane1.getViewport().add((Component)this.infotext, null);
        this.jTabbedPane1.add((Component)this.jPanel5, "Reference");
        this.jTabbedPane1.add((Component)this.jPanel1, "Name");
    }

    public void setVariable(VisibleVariable v) {
        this.v = v;
        this.fullnametxt.setText(v.longName);
        this.canonicalnametxt.setText(v.canonicalName);
        this.shortnametxt.setText(v.shortName);
        VDouble vd = v.node.getVDouble();
        this.initialvaluetxt.setText(v.formatValue(vd.initialValue, true, true));
        this.lowerrangetxt.setText(v.formatValue(vd.minimum, true, true));
        this.higherrangetxt.setText(v.formatValue(vd.maximum, true, true));
        this.prevValText = v.formatValue(v.node.doubleGetVal(), true, true);
        int p = this.prevValText.indexOf(32);
        this.unit = this.prevValText.substring(p + 1);
        this.unittxt.setText(this.unit);
        this.currentvaluetxt.setVariable(v);
        if (vd instanceof VDoubleReadOnly) {
            this.currentvaluetxt.jTextField1.setEditable(false);
        }
        StringBuffer s = new StringBuffer();
        String d = v.canonicalName.replace('/', '.');
        if (d.startsWith(".")) {
            d = d.substring(1);
        }
        String[] m = this.info.getSectionStrings(d);
        int i = 0;
        while (i < m.length) {
            StringTokenizer st = new StringTokenizer(m[i]);
            while (st.hasMoreTokens()) {
                String word = st.nextToken();
                if (word.startsWith("*")) {
                    word = word.substring(1);
                }
                try {
                    VisibleVariable var = Variables.forName(word);
                    if (var == v) {
                        throw new IllegalArgumentException("same var");
                    }
                    word = "<A HREF=\"" + word + "\">" + Resource.identifierToText(var.longName) + "</A>";
                    word = String.valueOf(word) + this.getHighLowString(var);
                }
                catch (IllegalArgumentException var) {
                    // empty catch block
                }
                s.append(String.valueOf(word) + " ");
            }
            s.append('\n');
            ++i;
        }
        if (this.addControllers) {
            VisibleVariable cv;
            Controller c;
            Vector src = Current.body.getControllerList().forControlledVariable(v);
            Vector targ = Current.body.getControllerList().forControllingVariable(v);
            if (src.size() > 0) {
                s.append("<HR> <H3>Controlled by</H3> ");
                int j = 0;
                while (j < src.size()) {
                    c = (Controller)src.get(j);
                    cv = c.getControllingVariable();
                    if (cv != null) {
                        if (j != 0) {
                            s.append(", ");
                        }
                        s.append(this.getHTMLLink(cv));
                    }
                    ++j;
                }
            }
            if (targ.size() > 0) {
                s.append("<HR> <H3>Controls</H3>");
                int j = 0;
                while (j < targ.size()) {
                    c = (Controller)targ.get(j);
                    cv = c.getControlledVariable();
                    if (cv != null) {
                        if (j != 0) {
                            s.append(", ");
                        }
                        s.append(this.getHTMLLink(cv));
                    }
                    ++j;
                }
            }
        }
        this.infotext.setText("<HTML>" + s + "</HTML>");
        this.infotext.setCaretPosition(1);
        this.jTabbedPane1.remove(this.jPanel5);
        if (this.referencevaluespanel != null) {
            this.jPanel5.remove(this.referencevaluespanel);
        }
        this.jPanel5.setBorder(new EmptyBorder(5, 5, 5, 5));
        if (s.length() < 1) {
            this.jTabbedPane1.setSelectedComponent(this.jPanel2);
        }
    }

    public String getHTMLLink(VisibleVariable v) {
        return "<A HREF=\"" + v.longName + "\">" + Resource.identifierToText(v.longName) + "</A>" + this.getHighLowString(v);
    }

    public String getHighLowString(VisibleVariable v) {
        double val = v.node.doubleGetVal();
        if (val > v.maximum) {
            return "<I>(High)</I>";
        }
        if (val < v.minimum) {
            return "<I>(Low)</I>";
        }
        return "";
    }

    public VisibleVariable getVariable() {
        return this.v;
    }

    public boolean transferBack() {
        double d = this.currentvaluetxt.getValue();
        if (Double.isNaN(d)) {
            JOptionPane.showMessageDialog(this, "The variable value entered, '" + this.currentvaluetxt.jTextField1.getText() + "', is not valid.");
            this.jTabbedPane1.setSelectedComponent(this.jPanel2);
            this.currentvaluetxt.requestFocus();
            return false;
        }
        this.v.node.doubleSetVal(d);
        return true;
    }
}

