/*
 * Decompiled with CFR 0.152.
 */
package phic.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.scilab.forge.jlatexmath.TeXFormula;
import org.scilab.forge.jlatexmath.TeXIcon;
import phic.Current;
import phic.Resource;
import phic.gui.ModalDialog;
import phic.gui.VariablePropertiesPanel;
import phic.gui.VisibleVariable;
import phic.modifiable.Eqn;

public class VariableEquationsPanel
extends JPanel {
    JList list = new JList();
    int neq = 0;
    int tneq = 0;
    Vector<Vector<Rectangle2D>> mouseRegions = new Vector();
    Vector<Vector<Rectangle2D>> allMouseRegions = null;
    Vector<TeXIcon> icons = new Vector();
    Vector<TeXIcon> allIcons = null;
    Vector formulae = new Vector();
    Vector allFormulae = null;
    MyLCR lcr = new MyLCR();
    float SIZE = 17.0f;
    MyLM lm = new MyLM();
    MouseMotionListener mml = new MouseMotionAdapter(){

        public void mouseMoved(MouseEvent e) {
            VisibleVariable v = VariableEquationsPanel.this.varAtLocationInList(e.getPoint());
            if (v != null) {
                VariableEquationsPanel.this.list.setCursor(VariableEquationsPanel.this.CHAND);
                VariableEquationsPanel.this.list.setToolTipText("<HTML><B>" + Resource.identifierToText(v.longName) + "</B> (" + v.canonicalName + "):<BR>" + "Currently = <FONT color=blue><B>" + v.formatValue(v.node.doubleGetVal(), true, false) + "</B></font> (" + v.formatValue(v.minimum, false, false) + "-" + v.formatValue(v.maximum, false, false) + ")<BR>Initially = " + v.formatValue(v.initial, true, false) + "</HTML>");
            } else {
                VariableEquationsPanel.this.list.setCursor(VariableEquationsPanel.this.CNORM);
            }
        }
    };
    Cursor CHAND = Cursor.getPredefinedCursor(12);
    Cursor CNORM = Cursor.getDefaultCursor();
    MouseListener ml = new MouseAdapter(){

        public void mouseClicked(MouseEvent e) {
            VisibleVariable v = VariableEquationsPanel.this.varAtLocationInList(e.getPoint());
            if (v != null && VariableEquationsPanel.this.al != null) {
                VariableEquationsPanel.this.al.actionPerformed(new ActionEvent(v, 0, v.shortName));
            }
        }
    };
    ActionListener al = null;
    static Action helpaction = new AbstractAction("Help"){
        String[][] help = new String[][]{{"\\Delta X", "Error in variable X, from its initial value"}, {"X \\rightarrow_z Y", "The value of X tends towards the value of Y, with rate Z"}, {"\\left[ X \\right]_Y^Z", " The value X, limited to lie in the range Y<X<Z"}, {"\\left[X\\right]^+", "The value X, limited to being positive"}, {"\\left[X\\right]^-", "The value X, limited to being negative"}};

        public void actionPerformed(ActionEvent e) {
            JPanel p = new JPanel();
            p.setLayout(new GridLayout(this.help.length, 2));
            int i = 0;
            while (i < this.help.length) {
                TeXFormula f = new TeXFormula(this.help[i][0]);
                p.add(new JLabel(f.createTeXIcon(0, 20.0f)));
                p.add(new JLabel(this.help[i][1]));
                ++i;
            }
            JOptionPane.showMessageDialog(null, p);
        }
    };

    public VariableEquationsPanel() {
        this.setLayout(new BorderLayout());
        this.add(this.list);
        this.list.setCellRenderer(this.lcr);
        this.list.setModel(this.lm);
        this.list.addMouseMotionListener(this.mml);
        this.list.addMouseListener(this.ml);
    }

    public void setFilter(Filter f) {
        this.lm.setVariable(f);
    }

    public void setFilter(VisibleVariable vv) {
        this.lm.setVariable(new VariableFilter(vv));
    }

    public void setFilter(VisibleVariable vv, boolean causal) {
        this.lm.setVariable(new CausalVariableFilter(vv, causal));
    }

    public Eqn getSelectedEqn() {
        int i = this.list.getSelectedIndex();
        if (i >= 0 && this.lm.equations.size() > i) {
            return this.lm.equations.get(i);
        }
        return null;
    }

    public VisibleVariable varAtLocationInList(Point p) {
        boolean hit = false;
        int hitItem = 0;
        int ix = this.list.locationToIndex(p);
        if (ix >= 0 && ix < this.mouseRegions.size()) {
            Vector<Rectangle2D> r = this.mouseRegions.get(ix);
            Rectangle b = this.list.getCellBounds(ix, ix);
            Point2D.Float relp = new Point2D.Float((float)(p.x - b.x) / this.SIZE, (float)(p.y - b.y) / this.SIZE);
            int i = 0;
            while (i < r.size()) {
                if (r.get(i).contains(relp)) {
                    hitItem = i;
                    hit = true;
                    break;
                }
                ++i;
            }
        }
        if (hit) {
            Eqn eq = this.lm.equations.get(ix);
            return eq.getVariableAtIndex(hitItem);
        }
        return null;
    }

    public Dialog createDialog() {
        Dialog m = new Dialog(this);
        return m;
    }

    class CausalVariableFilter
    implements Filter {
        VisibleVariable v;
        boolean causal;

        CausalVariableFilter(VisibleVariable vv, boolean c) {
            this.v = vv;
            this.causal = c;
        }

        public boolean filter(Eqn e) {
            if (this.v == null) {
                return true;
            }
            if (e.getNVariables() == 0) {
                return false;
            }
            if (this.causal) {
                return e.getVariableAtIndex(0) == this.v;
            }
            int i = 1;
            while (i < e.getNVariables()) {
                VisibleVariable vv = e.getVariableAtIndex(i);
                if (vv == this.v) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }

    static class Dialog
    extends ModalDialog {
        VariablePropertiesPanel infopane = new VariablePropertiesPanel();
        VariableEquationsPanel c;
        JTextField filter = new JTextField(15);
        JButton helpbutton = new JButton(helpaction);
        JCheckBox followSelection = new JCheckBox("Follow selection");
        JLabel neqLabel = new JLabel("0");
        JButton zoom1 = new JButton(new ZoomAction("-", 0.8));
        JButton zoom2 = new JButton(new ZoomAction("+", 1.25));
        JComboBox cb = new JComboBox();
        DocumentListener dl = new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                Dialog.this.doFilter();
            }

            public void insertUpdate(DocumentEvent e) {
                Dialog.this.doFilter();
            }

            public void removeUpdate(DocumentEvent e) {
                Dialog.this.doFilter();
            }
        };
        ActionListener al = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (e.getSource() instanceof VisibleVariable) {
                    VisibleVariable v = (VisibleVariable)e.getSource();
                    Dialog.this.infopane.setVariable(v);
                    if (Dialog.this.followSelection.isSelected()) {
                        Dialog.this.c.setFilter(v);
                        Dialog.this.updN();
                    }
                }
            }
        };
        ListSelectionListener lsl = new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent ev) {
                Eqn e = Dialog.this.c.getSelectedEqn();
                if (e != null) {
                    String o = e.getOrgan();
                    Dialog.this.changingComboWithoutListChange = true;
                    if (o == null) {
                        Dialog.this.cb.setSelectedItem("Any");
                    } else {
                        Dialog.this.cb.setSelectedItem(e.getOrgan());
                    }
                    Dialog.this.changingComboWithoutListChange = false;
                }
                Dialog.this.updN();
            }
        };
        boolean changingComboWithoutListChange = false;
        ItemListener il = new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (Dialog.this.changingComboWithoutListChange) {
                    return;
                }
                String org = Dialog.this.cb.getSelectedItem().toString();
                Dialog.this.c.setFilter(new OrganFilter(org));
                Dialog.this.updN();
            }
        };

        private Dialog() {
            this.c = new VariableEquationsPanel();
            this.init();
        }

        public Dialog(VariableEquationsPanel p) {
            this.c = p;
            this.init();
        }

        void init() {
            this.c.setFilter((Filter)null);
            JScrollPane scr = new JScrollPane();
            scr.getVerticalScrollBar().setUnitIncrement(16);
            scr.getViewport().setView(this.c);
            JPanel main = new JPanel();
            JPanel topcontrols = new JPanel();
            JPanel bottomPanel = new JPanel();
            main.setLayout(new BorderLayout());
            main.add((Component)scr, "Center");
            main.add((Component)topcontrols, "North");
            main.add((Component)bottomPanel, "South");
            topcontrols.add(new JLabel("Filter:"));
            topcontrols.add(this.filter);
            topcontrols.add(this.cb);
            topcontrols.add(this.followSelection);
            this.followSelection.setSelected(true);
            topcontrols.add(this.neqLabel);
            bottomPanel.setLayout(new BorderLayout());
            bottomPanel.add(this.infopane);
            topcontrols.add(this.zoom1);
            topcontrols.add(this.zoom2);
            topcontrols.add(this.helpbutton);
            this.filter.setBorder(new BevelBorder(1));
            this.getContentPane().add(main);
            this.setTitle("Equations");
            this.setSize(1000, 500);
            this.filter.getDocument().addDocumentListener(this.dl);
            this.c.al = this.al;
            Vector<String> organs = new Vector<String>();
            organs.add("Any");
            List l = Current.body.eqnList.getList();
            int i = 0;
            while (i < l.size()) {
                String org = ((Eqn)l.get(i)).getOrgan();
                if (!organs.contains(org) && org != null) {
                    organs.add(org);
                }
                ++i;
            }
            this.cb.setModel(new DefaultComboBoxModel(organs));
            this.cb.setEditable(false);
            this.c.list.addListSelectionListener(this.lsl);
            this.cb.addItemListener(this.il);
        }

        void doFilter() {
            String txt = this.filter.getText().toLowerCase();
            VariableEquationsPanel variableEquationsPanel = this.c;
            variableEquationsPanel.getClass();
            this.c.setFilter(variableEquationsPanel.new TextFilter(txt));
            this.updN();
        }

        void updN() {
            this.neqLabel.setText(String.valueOf(String.valueOf(this.c.neq)) + "/" + String.valueOf(this.c.tneq));
        }

        public void setFilter(VisibleVariable v) {
            this.filter.setText(v.shortName);
            this.cb.setSelectedItem("Any");
            this.c.setFilter(v);
            this.infopane.setVariable(v);
        }

        class ZoomAction
        extends AbstractAction {
            double zf;

            public ZoomAction(String s, double d) {
                super(s);
                this.zf = 1.0;
                this.zf = d;
            }

            public void actionPerformed(ActionEvent e) {
                Dialog.this.c.SIZE = (float)((double)Dialog.this.c.SIZE * this.zf);
                Dialog.this.c.lm.allEquations = null;
                Dialog.this.c.setFilter(Dialog.this.c.lm.currentFilter);
            }
        }
    }

    static interface Filter {
        public boolean filter(Eqn var1);
    }

    class MyLCR
    extends JPanel
    implements ListCellRenderer {
        JLabel label = new JLabel();

        public MyLCR() {
            BorderLayout b = new BorderLayout(5, 5);
            this.setLayout(b);
            this.setBorder(BorderFactory.createBevelBorder(1));
            this.add((Component)this.label, "Center");
            this.label.setOpaque(true);
            this.label.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.label.setIcon(VariableEquationsPanel.this.icons.get(index));
            this.label.setBackground(isSelected ? SystemColor.textHighlight : SystemColor.control);
            return this;
        }
    }

    class MyLM
    extends AbstractListModel {
        Vector<Eqn> equations = null;
        Vector<Eqn> allEquations = null;
        public Filter currentFilter = null;

        MyLM() {
        }

        void setVariable(Filter filt) {
            VariableEquationsPanel.this.formulae.removeAllElements();
            VariableEquationsPanel.this.mouseRegions.removeAllElements();
            VariableEquationsPanel.this.icons.removeAllElements();
            if (this.allEquations == null) {
                Vector<Eqn> el = new Vector<Eqn>(Current.body.eqnList.getList());
                Vector<Eqn> ve = Current.body.controllers.getAllEquations();
                el.addAll(ve);
                int i = 0;
                while (i < el.size()) {
                    Eqn e = (Eqn)el.get(i);
                    TeXFormula f = new TeXFormula(e.getTeX());
                    TeXIcon ic = f.createTeXIcon(0, VariableEquationsPanel.this.SIZE);
                    VariableEquationsPanel.this.mouseRegions.add(f.mouseBoxes);
                    VariableEquationsPanel.this.formulae.add(f);
                    VariableEquationsPanel.this.icons.add(ic);
                    ++i;
                }
                this.equations = el;
                this.allEquations = new Vector(el);
                VariableEquationsPanel.this.allMouseRegions = new Vector<Vector<Rectangle2D>>(VariableEquationsPanel.this.mouseRegions);
                VariableEquationsPanel.this.allIcons = new Vector<TeXIcon>(VariableEquationsPanel.this.icons);
                VariableEquationsPanel.this.allFormulae = new Vector(VariableEquationsPanel.this.formulae);
            }
            if (filt != null) {
                VariableEquationsPanel.this.formulae.removeAllElements();
                VariableEquationsPanel.this.mouseRegions.removeAllElements();
                VariableEquationsPanel.this.icons.removeAllElements();
                this.equations.removeAllElements();
                VariableEquationsPanel.this.neq = 0;
                VariableEquationsPanel.this.tneq = this.allEquations.size();
                int i = 0;
                while (i < this.allEquations.size()) {
                    Eqn e = this.allEquations.get(i);
                    if (filt.filter(e)) {
                        VariableEquationsPanel.this.icons.add(VariableEquationsPanel.this.allIcons.get(i));
                        VariableEquationsPanel.this.mouseRegions.add(VariableEquationsPanel.this.allMouseRegions.get(i));
                        VariableEquationsPanel.this.formulae.add(VariableEquationsPanel.this.allFormulae.get(i));
                        this.equations.add(this.allEquations.get(i));
                        ++VariableEquationsPanel.this.neq;
                    }
                    ++i;
                }
            } else {
                this.equations.addAll(this.allEquations);
                VariableEquationsPanel.this.mouseRegions.addAll(VariableEquationsPanel.this.allMouseRegions);
                VariableEquationsPanel.this.formulae.addAll(VariableEquationsPanel.this.allFormulae);
                VariableEquationsPanel.this.icons.addAll(VariableEquationsPanel.this.allIcons);
            }
            this.currentFilter = filt;
            this.fireContentsChanged(this, 0, VariableEquationsPanel.this.formulae.size());
        }

        public Object getElementAt(int i) {
            return VariableEquationsPanel.this.formulae.get(i);
        }

        public int getSize() {
            return VariableEquationsPanel.this.formulae.size();
        }
    }

    static class OrganFilter
    implements Filter {
        String org;

        OrganFilter(String o) {
            this.org = o;
        }

        public boolean filter(Eqn e) {
            if (this.org.equals("Any")) {
                return true;
            }
            String o = e.getOrgan();
            if (o == null) {
                return this.org == null;
            }
            return o.equals(this.org);
        }
    }

    public class TextFilter
    implements Filter {
        String txt;

        public TextFilter(String t) {
            this.txt = t;
        }

        public boolean filter(Eqn e) {
            int i = 0;
            while (i < e.getNVariables()) {
                VisibleVariable vv = e.getVariableAtIndex(i);
                if (vv.longName.toLowerCase().contains(this.txt) || vv.canonicalName.toLowerCase().contains(this.txt) || vv.shortName.toLowerCase().contains(this.txt)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }

    class VariableFilter
    implements Filter {
        VisibleVariable v;

        VariableFilter(VisibleVariable vv) {
            this.v = vv;
        }

        public boolean filter(Eqn e) {
            if (this.v == null) {
                return true;
            }
            int i = 0;
            while (i < e.getNVariables()) {
                VisibleVariable vv = e.getVariableAtIndex(i);
                if (vv == this.v) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }
}

