/*
 * Decompiled with CFR 0.152.
 */
package phic.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import phic.Resource;
import phic.gui.VisibleVariable;

public class ValueRangeLabel
extends JPanel {
    JLabel nametxt = new JLabel();
    JLabel mintxt = new JLabel();
    JLabel maxtxt = new JLabel();
    JTextField valtxt = new JTextField();
    JLabel jLabel1 = new JLabel();
    JLabel jLabel2 = new JLabel();
    JLabel jLabel3 = new JLabel();
    VisibleVariable v;
    public boolean useColourForErrors = true;
    public Color errorColour = Color.pink;

    public ValueRangeLabel(VisibleVariable v) {
        this.v = v;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.myinit();
    }

    private void jbInit() throws Exception {
        this.nametxt.setFont(new Font("Dialog", 1, 12));
        this.nametxt.setPreferredSize(new Dimension(140, 17));
        this.nametxt.setHorizontalAlignment(11);
        this.nametxt.setText("Name");
        this.mintxt.setPreferredSize(new Dimension(75, 17));
        this.mintxt.setToolTipText("Minimum normal value");
        this.mintxt.setText("jLabel3");
        this.maxtxt.setPreferredSize(new Dimension(75, 17));
        this.maxtxt.setToolTipText("Maximum normal value");
        this.maxtxt.setText("jLabel4");
        this.valtxt.setBackground(Color.black);
        this.valtxt.setFont(new Font("SansSerif", 1, 13));
        this.valtxt.setForeground(Color.cyan);
        this.valtxt.setPreferredSize(new Dimension(98, 22));
        this.valtxt.setEditable(false);
        this.valtxt.setText("jTextField1");
        this.jLabel1.setText("-");
        this.jLabel2.setText("(");
        this.jLabel3.setText(")");
        this.add((Component)this.nametxt, null);
        this.add((Component)this.valtxt, null);
        this.add((Component)this.jLabel2, null);
        this.add((Component)this.mintxt, null);
        this.add((Component)this.jLabel1, null);
        this.add((Component)this.maxtxt, null);
        this.add((Component)this.jLabel3, null);
    }

    void myinit() {
        double value = this.v.node.doubleGetVal();
        this.nametxt.setText(Resource.identifierToText(this.v.longName));
        this.valtxt.setText(this.v.formatValue(value, true, true));
        this.mintxt.setText(this.v.formatValue(this.v.minimum, true, false));
        this.maxtxt.setText(this.v.formatValue(this.v.maximum, true, false));
        this.nametxt.setToolTipText(this.v.canonicalName);
        this.valtxt.setToolTipText("Initial value = " + this.v.formatValue(this.v.initial, true, false));
        if (this.useColourForErrors) {
            if (value < this.v.minimum) {
                this.mintxt.setOpaque(true);
                this.mintxt.setBackground(this.errorColour);
            }
            if (value > this.v.maximum) {
                this.maxtxt.setOpaque(true);
                this.maxtxt.setBackground(this.errorColour);
            }
        }
    }
}

