/*
 * Decompiled with CFR 0.152.
 */
package phic.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import phic.common.UnitConstants;
import phic.gui.VisibleVariable;

public class ValueInput
extends JPanel {
    BorderLayout borderLayout1 = new BorderLayout();
    public JTextField jTextField1 = new JTextField();
    JLabel jLabel1 = new JLabel();
    double currval;
    VisibleVariable vv;
    String unit;
    double unitmult;

    public ValueInput() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.jLabel1.setText("u");
        this.jTextField1.setText("");
        this.jTextField1.setColumns(7);
        this.add((Component)this.jTextField1, "Center");
        this.add((Component)this.jLabel1, "East");
    }

    public void setVariable(VisibleVariable v) {
        this.vv = v;
        this.setValue(v.node.getVDouble().get(), true);
    }

    public void setValue(double varvalue, boolean alterunit) {
        this.currval = varvalue;
        String s = this.vv.formatValue(this.currval, true, false);
        int spc = s.indexOf(32);
        if (spc >= 0) {
            if (alterunit) {
                this.unit = s.substring(spc + 1);
                this.unitmult = UnitConstants.getUnitMultiplier(this.currval, this.vv.units);
                this.jLabel1.setText(this.unit);
            }
            this.jTextField1.setText(s.substring(0, spc));
        } else {
            this.jTextField1.setText(s);
        }
    }

    public double getValue() {
        double v;
        try {
            v = Double.parseDouble(this.jTextField1.getText());
        }
        catch (NumberFormatException x) {
            x.printStackTrace();
            JOptionPane.showMessageDialog(this, "Illegal value", "You must enter a valid number for " + this.vv.longName, 0);
            return Double.NaN;
        }
        return v * this.unitmult;
    }

    public String getUnitShown() {
        return this.unit;
    }

    public double getUnitMultiplierUsed() {
        return this.unitmult;
    }
}

