/*
 * Decompiled with CFR 0.152.
 */
package phic.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSlider;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import phic.Current;
import phic.Resource;
import phic.common.LifeSupport;
import phic.common.Quantity;
import phic.common.Ticker;
import phic.common.VDouble;
import phic.gui.CreateGraphTarget;
import phic.gui.HorizontalBar;
import phic.gui.INodeView;
import phic.gui.Node;
import phic.gui.PhicApplication;
import phic.gui.PhicFrameSetup;
import phic.gui.ThinNodeView_closebutton_actionAdapter;
import phic.gui.ThinNodeView_namebutton_actionAdapter;
import phic.gui.ThinNodeView_valuetxt_mouseAdapter;
import phic.gui.VDoubleNode;
import phic.gui.Variables;
import phic.gui.VisibleVariable;

public class ThinNodeView
extends JPanel
implements INodeView,
Ticker {
    JLabel valuetxt = new JLabel();
    JButton closebutton = new JButton();
    JButton actionbutton = new JButton();
    JPanel extrapanel = new JPanel();
    Border border1;
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanel1 = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    JLabel iconLabel = new JLabel();
    BorderLayout borderLayout4 = new BorderLayout();
    JPanel jPanel3 = new JPanel();
    JSlider slider = new JSlider();
    JPanel jPanel2 = new JPanel();
    BorderLayout borderLayout3 = new BorderLayout();
    JCheckBox graphcheckbox = new JCheckBox();
    BorderLayout borderLayout5 = new BorderLayout();
    JPanel jPanel4 = new JPanel();
    BorderLayout borderLayout6 = new BorderLayout();
    JLabel varnamelabel = new JLabel();
    public static int SLIDER_WIDTH = 80;
    static final ImageIcon closeIcon = new ImageIcon(Resource.loader.getImageResource("Cross8px.gif"));
    static final ImageIcon highIcon = new ImageIcon(Resource.loader.getImageResource("HighSymbol.gif"));
    static final ImageIcon lowIcon = new ImageIcon(Resource.loader.getImageResource("LowSymbol.gif"));
    static final ImageIcon actionIcon = new ImageIcon(Resource.loader.getImageResource("Method.gif"));
    static final ImageIcon valueIcon = new ImageIcon(Resource.loader.getImageResource("Double.gif"));
    static final ImageIcon tickIcon = new ImageIcon(Resource.loader.getImageResource("Tick.gif"));
    static final ImageIcon crossIcon = new ImageIcon(Resource.loader.getImageResource("Cross.gif"));
    static final ImageIcon lockIcon = new ImageIcon(Resource.loader.getImageResource("LockSymbol.gif"));
    boolean isReadOnly = false;
    protected Node node;
    Color defaultForeground = Color.lightGray;
    int type;
    double currentdouble;
    VDouble theVDouble;
    VisibleVariable theVV;
    double oldVal;
    boolean automaticAdjust = false;
    boolean graphDisplayed = false;
    boolean UPDATE_BOOLEANS = true;
    CreateGraphTarget cgt;
    Action readOnlyAction = new AbstractAction("Read-only"){

        public boolean isEnabled() {
            return ThinNodeView.this.theVV.type != 2 && ThinNodeView.this.theVV.type != 0;
        }

        public Object getValue(String key) {
            boolean f = ThinNodeView.this.isReadOnly;
            if (key.equals("Name")) {
                return !f ? "Make read-only" : "Allow modification";
            }
            if (key.equals("ShortDescription")) {
                return !f ? "Prevents modification to variable" : "Allows the variable's value to be changed";
            }
            return super.getValue(key);
        }

        public void actionPerformed(ActionEvent e) {
            ThinNodeView.this.setReadOnly(!ThinNodeView.this.isReadOnly);
        }
    };
    Border highlightBorder = null;

    public ThinNodeView() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addNotify() {
        HorizontalBar.addBar(this);
        this.slider.setPreferredSize(new Dimension(SLIDER_WIDTH, 20));
        this.setPreferredSize(new Dimension(270 + SLIDER_WIDTH, 20));
        this.validate();
        super.addNotify();
    }

    public void removeNotify() {
        HorizontalBar.removeBar(this);
        super.removeNotify();
    }

    public void setReadOnly(boolean b) {
        this.isReadOnly = b;
        if (this.isReadOnly) {
            this.slider.setEnabled(false);
        } else {
            this.slider.setEnabled(true);
        }
    }

    public void replaceVariables() {
        this.node = Node.findNodeByName(this.node.canonicalName());
        this.initialiseFromNode();
        this.updateValue();
    }

    public void setNode(Node n) {
        this.node = n;
        this.initialiseFromNode();
    }

    public void initialiseFromNode() {
        String s = this.node.getFriendlyName();
        this.varnamelabel.setText(s);
        this.varnamelabel.setToolTipText("<HTML><B>" + s + "</B>" + "<BR>" + this.node.canonicalNameReplaced() + "</HTML>");
        if (this.node instanceof VDoubleNode) {
            this.theVDouble = ((VDoubleNode)this.node).getVDouble();
        }
        this.type = this.node.getType();
        this.theVV = Variables.forNode(this.node);
        if (this.theVV == null) {
            if (this.type == 3) {
                this.setupBoolean();
            } else if (this.type == 1) {
                this.setupMethod();
            } else if (this.type == 2) {
                this.setupNumeric();
                this.oldVal = this.node.doubleGetVal();
                this.slider.setToolTipText("Range: 0 - " + Quantity.toString(this.oldVal * 2.0));
                this.valuetxt.setToolTipText("Previously: " + Quantity.toString(this.oldVal));
            }
        } else {
            this.slider.setToolTipText("Range: " + this.theVV.formatValue(this.theVV.minimum, true, false) + " - " + this.theVV.formatValue(this.theVV.maximum, true, false));
            this.valuetxt.setToolTipText("Normal: " + this.theVV.formatValue(this.theVV.initial, true, false));
            this.setupNumeric();
        }
        this.updateValue();
    }

    protected void setupBoolean() {
        this.slider.setVisible(false);
        this.extrapanel.removeAll();
        this.actionbutton.setEnabled(true);
        this.graphcheckbox.setVisible(false);
        this.actionbutton.setIcon(tickIcon);
        this.actionbutton.setToolTipText("Change Yes/No value");
        this.valuetxt.setPreferredSize(new Dimension(78, 20));
    }

    protected void setupNumeric() {
        this.slider.setVisible(true);
        this.extrapanel.setVisible(true);
        this.extrapanel.removeAll();
        this.extrapanel.add(this.iconLabel);
        this.iconLabel.setIcon(null);
        this.actionbutton.setEnabled(false);
        this.graphcheckbox.setVisible(true);
        this.slider.setValue(50);
        this.setReadOnly(!this.node.isSettable());
        this.actionbutton.setIcon(valueIcon);
        this.actionbutton.setToolTipText("");
        this.oldVal = Double.NaN;
        this.jPanel4.remove(this.actionbutton);
    }

    protected void setupMethod() {
        this.slider.setVisible(false);
        this.extrapanel.removeAll();
        this.extrapanel.setVisible(false);
        this.actionbutton.setEnabled(true);
        this.graphcheckbox.setVisible(false);
        this.valuetxt.setVisible(false);
        this.actionbutton.setIcon(actionIcon);
        this.actionbutton.setToolTipText("Invoke action");
        this.remove(this.jPanel1);
    }

    public void tick(double time) {
        if (this.type == 2 || this.type == 3) {
            this.updateValue();
        }
    }

    public static void setSliderWidth(int w) {
        SLIDER_WIDTH = w;
        int i = 0;
        while (i < HorizontalBar.bars.size()) {
            Object o = HorizontalBar.bars.get(i);
            System.out.println("obj" + o);
            if (o instanceof ThinNodeView) {
                ThinNodeView v = (ThinNodeView)o;
                v.slider.setPreferredSize(new Dimension(w, 20));
                v.setPreferredSize(new Dimension(270 + w, 20));
                v.validate();
            }
            ++i;
        }
    }

    public void updateValue() {
        if (this.type == 2) {
            double val = this.node.doubleGetVal();
            if (this.theVV != null) {
                this.valuetxt.setText(this.theVV.formatValue(this.theVDouble.get(), true, true));
                this.iconLabel.setIcon(this.getVarIcon(val, this.theVDouble));
            } else if (this.theVDouble != null) {
                this.valuetxt.setText(this.theVDouble.formatValue(true, true));
                this.iconLabel.setIcon(this.getVarIcon(val, this.theVDouble));
            } else if (this.currentdouble != val) {
                this.valuetxt.setText(Quantity.toString(val));
                this.currentdouble = val;
            }
            if (this.theVDouble != null) {
                this.automaticAdjust = true;
                if (val != this.oldVal) {
                    this.oldVal = val;
                    this.slider.setValue((int)(100.0 * (val - this.theVDouble.minimum) / (this.theVDouble.maximum - this.theVDouble.minimum)));
                }
                this.automaticAdjust = false;
            }
        } else if (this.type == 3 && this.UPDATE_BOOLEANS) {
            boolean b = this.node.booleanGetVal();
            this.valuetxt.setText(b ? "Yes" : "No");
            this.actionbutton.setIcon(b ? tickIcon : crossIcon);
        }
    }

    public JComponent getComponent() {
        return this;
    }

    private void jbInit() throws Exception {
        this.border1 = BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1), BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.setLayout(this.borderLayout1);
        this.valuetxt.setBackground(Color.black);
        this.valuetxt.setFont(new Font("Dialog", 1, 12));
        this.valuetxt.setForeground(this.defaultForeground);
        this.valuetxt.setBorder(this.border1);
        this.valuetxt.setOpaque(true);
        this.valuetxt.setPreferredSize(new Dimension(100, 20));
        this.valuetxt.setText("0.000");
        this.valuetxt.addMouseListener(new ThinNodeView_valuetxt_mouseAdapter(this));
        this.closebutton.setToolTipText("Remove this variable from display");
        this.closebutton.setIcon(closeIcon);
        this.closebutton.setMargin(new Insets(0, 0, 0, 0));
        this.closebutton.addActionListener(new ThinNodeView_closebutton_actionAdapter(this));
        this.actionbutton.setPreferredSize(new Dimension(22, 20));
        this.actionbutton.setActionCommand("*");
        this.actionbutton.setHorizontalAlignment(2);
        this.actionbutton.setHorizontalTextPosition(2);
        this.actionbutton.setMargin(new Insets(2, 1, 2, 1));
        this.actionbutton.addActionListener(new ThinNodeView_namebutton_actionAdapter(this));
        this.setMinimumSize(new Dimension(210, 20));
        this.setPreferredSize(new Dimension(270 + SLIDER_WIDTH, 20));
        this.jPanel1.setLayout(this.borderLayout2);
        this.extrapanel.setBackground(Color.black);
        this.extrapanel.setForeground(Color.white);
        this.extrapanel.setPreferredSize(new Dimension(6, 0));
        this.extrapanel.setLayout(this.borderLayout4);
        this.iconLabel.setPreferredSize(new Dimension(34, 15));
        this.iconLabel.setText("");
        this.slider.setPreferredSize(new Dimension(SLIDER_WIDTH, 20));
        this.slider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent d) {
                ThinNodeView.this.slider_stateChanged(d);
            }
        });
        this.jPanel2.setLayout(this.borderLayout3);
        this.jPanel2.setBorder(null);
        this.graphcheckbox.setToolTipText("Display graph");
        this.graphcheckbox.setText("");
        this.graphcheckbox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ThinNodeView.this.graphcheckbox_actionPerformed(e);
            }
        });
        this.jPanel3.setLayout(this.borderLayout5);
        this.jPanel4.setLayout(this.borderLayout6);
        this.varnamelabel.setPreferredSize(new Dimension(120, 15));
        this.varnamelabel.setText("Full Name of Variable");
        this.add((Component)this.closebutton, "East");
        this.add((Component)this.jPanel1, "Center");
        this.jPanel1.add((Component)this.valuetxt, "West");
        this.jPanel1.add((Component)this.jPanel3, "Center");
        this.jPanel3.add((Component)this.extrapanel, "West");
        this.extrapanel.add((Component)this.iconLabel, "Center");
        this.jPanel3.add((Component)this.jPanel2, "Center");
        this.jPanel2.add((Component)this.graphcheckbox, "East");
        this.jPanel2.add((Component)this.slider, "Center");
        this.add((Component)this.jPanel4, "West");
        this.jPanel4.add((Component)this.actionbutton, "East");
        this.jPanel4.add((Component)this.varnamelabel, "West");
    }

    void closebutton_actionPerformed(ActionEvent e) {
        if (this.graphcheckbox.isSelected()) {
            this.graphcheckbox.doClick();
        }
        HorizontalBar.removeBar(this);
        Container p = this.getParent();
        if (p == null) {
            return;
        }
        Container p2 = p.getParent();
        if (p2 != null) {
            p2.remove(p);
            p2.validate();
        }
    }

    public void setCreateGraphTarget(CreateGraphTarget cgt) {
        this.cgt = cgt;
    }

    void displayVariableProperties() {
        if (this.theVV == null) {
            return;
        }
        this.theVV.displayVariableDialog();
    }

    void namebutton_actionPerformed(ActionEvent e) {
        if (this.type == 3) {
            boolean b = !this.node.booleanGetVal();
            this.node.booleanSetVal(b);
            this.updateValue();
            String comment = String.valueOf(this.node.getLeafName()) + (b ? " on" : " off");
            PhicApplication.markEvent(comment);
            Current.body.message(comment);
        } else if (this.type == 1) {
            this.node.methodInvoke();
            String comment = this.node.getLeafName();
            PhicApplication.markEvent(comment);
            Current.body.message(comment);
        } else if (this.type == 2) {
            this.displayVariableProperties();
        }
    }

    void slider_stateChanged(ChangeEvent e) {
        String newString;
        double newVal;
        if (this.automaticAdjust) {
            return;
        }
        if (this.theVDouble != null) {
            newVal = this.theVDouble.minimum + (this.theVDouble.maximum - this.theVDouble.minimum) * (double)this.slider.getValue() / 100.0;
            newString = this.theVDouble.formatValue(newVal, true, true);
        } else {
            newVal = this.oldVal * (1.0 + (double)(this.slider.getValue() - 50) / 50.0);
            newString = Quantity.toString(newVal);
        }
        LifeSupport ls = Current.environment.getVariableClamps();
        if (this.theVV != null && ls.isFudgeVariable(this.theVV)) {
            ls.setFudgeValue(this.theVV, newVal);
        } else {
            this.node.doubleSetVal(newVal);
        }
        this.valuetxt.setText(newString);
    }

    void graphcheckbox_actionPerformed(ActionEvent e) {
        if (this.cgt != null) {
            if (this.theVV != null) {
                if (this.graphcheckbox.isSelected()) {
                    this.cgt.addNewVariable(this.theVV);
                    this.cgt.setThinNodeView(this.theVV, this);
                    this.graphDisplayed = true;
                    Color graphColor = this.cgt.getColor(this.node);
                    this.valuetxt.setForeground(graphColor);
                    this.highlightBorder = BorderFactory.createMatteBorder(2, 2, 2, 2, graphColor);
                } else {
                    this.cgt.remove(this.theVV);
                    this.graphDisplayed = false;
                    this.valuetxt.setForeground(this.defaultForeground);
                    this.highlightBorder = null;
                }
            } else if (this.theVDouble != null) {
                if (this.graphcheckbox.isSelected()) {
                    this.cgt.addNewVariable(this.theVDouble, this.node.getFriendlyName());
                    this.graphDisplayed = true;
                    Color graphColor = this.cgt.getColor(this.node);
                    this.valuetxt.setForeground(graphColor);
                    this.highlightBorder = BorderFactory.createMatteBorder(2, 2, 2, 2, graphColor);
                } else {
                    this.cgt.remove(this.theVDouble);
                    this.graphDisplayed = false;
                    this.valuetxt.setForeground(this.defaultForeground);
                    this.highlightBorder = null;
                }
            }
        }
    }

    public final ImageIcon getVarIcon(double val, VDouble variable) {
        if (this.theVV != null && Current.environment.getVariableClamps().isFudgeVariable(this.theVV)) {
            return lockIcon;
        }
        if (val < variable.minimum) {
            return lowIcon;
        }
        if (val <= variable.maximum) {
            return null;
        }
        return highIcon;
    }

    public static final ImageIcon getIcon(double val, VDouble variable) {
        if (val < variable.minimum) {
            return lowIcon;
        }
        if (val <= variable.maximum) {
            return null;
        }
        return highIcon;
    }

    void valueClicked(MouseEvent e) {
        if (e.isPopupTrigger()) {
            if (this.theVV == null) {
                return;
            }
            JPopupMenu m = new JPopupMenu();
            JMenu umenu = this.theVV.createUnitsMenu();
            if (umenu != null) {
                m.add(umenu);
            }
            m.add(this.theVV.showVariableInfoBox);
            if (!this.isReadOnly) {
                m.add(this.theVV.resetVariableValue);
                m.add(this.theVV.clampVariable);
            }
            if (PhicFrameSetup.allowVariableModification && this.theVV.type != 2 && this.theVV.type != 0) {
                m.add(this.readOnlyAction);
            }
            if (PhicFrameSetup.allowEquations > 0) {
                m.add(this.theVV.showVariableEqnsBox);
            }
            if (PhicFrameSetup.allowEquations > 1) {
                m.add(this.theVV.getVariableCausalEquations());
            }
            m.show((Component)e.getSource(), e.getX(), e.getY());
        } else if (e.getClickCount() == 2) {
            this.displayVariableProperties();
        }
    }
}

