/*
 * Decompiled with CFR 0.152.
 */
package phic.gui;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.event.ChangeEvent;
import phic.BasicActions;
import phic.Current;
import phic.common.ClassVisualiser;
import phic.common.LifeSupport;
import phic.gui.PhicApplication;
import phic.gui.ThinNodeView;
import phic.gui.VisibleVariable;

public class ThinButtonSet
extends ThinNodeView {
    VisibleVariable amount;
    JButton[] buttons;
    BasicActions.ActionSet actionSet;
    BasicActions.ActionValue actionValue;

    public void initialiseFromNode() {
        String s = this.node.getFriendlyName();
        this.varnamelabel.setText(s);
        this.varnamelabel.setToolTipText("<HTML><B>" + s + "</B>" + "<BR>" + this.node.canonicalNameReplaced() + "</HTML>");
        this.type = this.node.getType();
        if (this.type == 3) {
            this.extrapanel.removeAll();
            this.actionbutton.setEnabled(true);
            this.graphcheckbox.setVisible(false);
            this.actionbutton.setIcon(tickIcon);
            this.actionbutton.setToolTipText("Change Yes/No value");
            this.valuetxt.setPreferredSize(new Dimension(78, 20));
            this.extrapanel.setVisible(false);
            this.valuetxt.setVisible(true);
            this.actionbutton.setToolTipText("Invoke action");
        } else if (this.type == 1) {
            this.extrapanel.removeAll();
            this.extrapanel.setVisible(false);
            this.actionbutton.setEnabled(true);
            this.graphcheckbox.setVisible(false);
            this.valuetxt.setVisible(false);
            this.actionbutton.setIcon(actionIcon);
            this.actionbutton.setToolTipText("Invoke action");
        } else if (this.type == 8) {
            Class<?> nodet = ((Field)this.node.member).getType();
            if (ClassVisualiser.is(nodet, BasicActions.ActionSet.class)) {
                try {
                    this.actionSet = (BasicActions.ActionSet)this.node.objectGetVal();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.varnamelabel.setText(this.actionSet.groupName);
                this.extrapanel.removeAll();
                this.extrapanel.setVisible(false);
                this.graphcheckbox.setVisible(false);
                this.valuetxt.setVisible(false);
                this.actionbutton.setVisible(false);
                this.jPanel1.removeAll();
                FlowLayout ly = new FlowLayout(2, 2, 0);
                this.jPanel1.setLayout(ly);
                int nb = this.actionSet.size();
                this.buttons = new JButton[nb];
                Action[] a = this.actionSet.getActions();
                int i = 0;
                while (i < nb) {
                    this.buttons[i] = new JButton(a[i]);
                    this.buttons[i].setMargin(new Insets(1, 2, 1, 2));
                    this.jPanel1.add(this.buttons[i]);
                    ++i;
                }
            } else {
                try {
                    this.actionValue = (BasicActions.ActionValue)this.node.objectGetVal();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.amount = this.actionValue.getFormatter();
                this.actionValue.value = this.amount.node.doubleGetVal();
                this.varnamelabel.setText(this.actionValue.name);
                this.extrapanel.setVisible(true);
                this.extrapanel.removeAll();
                this.extrapanel.add(this.iconLabel);
                this.actionbutton.setEnabled(true);
                this.actionbutton.setAction(this.actionValue);
                this.actionbutton.setIcon(actionIcon);
                this.actionbutton.setToolTipText("Invoke action");
                this.iconLabel.setIcon(null);
                this.oldVal = Double.NaN;
                this.valuetxt.setPreferredSize(new Dimension(78, 20));
                this.slider.setValue((int)(100.0 * (this.actionValue.value - this.amount.minimum) / (this.amount.maximum - this.amount.minimum)));
                this.graphcheckbox.setVisible(false);
            }
        }
    }

    void namebutton_actionPerformed(ActionEvent e) {
        if (this.type == 3) {
            super.namebutton_actionPerformed(e);
        } else if (this.type == 1) {
            this.node.methodInvoke();
            String comment = String.valueOf(this.node.getLeafName()) + " " + this.amount.formatValue(this.amount.node.doubleGetVal(), true, false);
            PhicApplication.markEvent(comment);
            Current.body.message(comment);
        }
    }

    void slider_stateChanged(ChangeEvent e) {
        if (this.automaticAdjust) {
            return;
        }
        String newString = "";
        double newVal = 0.0;
        if (this.theVDouble != null) {
            newVal = this.theVDouble.minimum + (this.theVDouble.maximum - this.theVDouble.minimum) * (double)this.slider.getValue() / 100.0;
            newString = this.theVDouble.formatValue(newVal, true, true);
        } else if (this.amount != null) {
            newVal = this.amount.minimum + (this.amount.maximum - this.amount.minimum) * (double)this.slider.getValue() / 100.0;
            newString = this.amount.formatValue(newVal, true, true);
            this.actionValue.value = newVal;
        }
        LifeSupport ls = Current.environment.getVariableClamps();
        if (this.theVV != null && ls.isFudgeVariable(this.theVV)) {
            ls.setFudgeValue(this.theVV, newVal);
        } else {
            this.node.doubleSetVal(newVal);
        }
        this.valuetxt.setText(newString);
    }

    class ButtonAction
    extends AbstractAction {
        double value;

        ButtonAction(double d) {
            super(ThinButtonSet.this.amount.formatValue(d, true, false));
            this.value = d;
        }

        public void actionPerformed(ActionEvent arg0) {
            try {
                ((Method)ThinButtonSet.this.node.member).invoke(ThinButtonSet.this.node.object, new Double(this.value));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            String comment = String.valueOf(ThinButtonSet.this.node.getLeafName()) + " " + ThinButtonSet.this.amount.formatValue(this.value, true, false);
        }
    }
}

