/*
 * Decompiled with CFR 0.152.
 */
package phic.gui;

import evaluator.EquationException;
import evaluator.MathException;
import evaluator.MathExtra;
import evaluator.ObjectPath;
import evaluator.ParseException;
import evaluator.StackException;
import evaluator.VariableLookup;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.text.NumberFormat;
import javax.swing.JFrame;
import phic.Current;
import phic.IntravenousInfusion;
import phic.Person;
import phic.common.TextReceiver;
import phic.common.Variable;
import phic.gui.FrameStub;
import phic.gui.Variables;
import phic.gui.VisibleVariable;
import phic.modifiable.EvaluatorHelper;

public class TextIOFrame
implements FrameStub,
VariableLookup,
TextReceiver {
    boolean running = false;
    String promptString = ">";
    Thread thread = new Thread(new Runnable(){

        public void run() {
            TextIOFrame.this.out.println();
            while (TextIOFrame.this.running) {
                String s = "";
                try {
                    TextIOFrame.this.out.print(String.valueOf(Current.person.name) + TextIOFrame.this.promptString);
                    s = TextIOFrame.this.in.readLine();
                    if (TextIOFrame.this.dataStreamer.running) {
                        TextIOFrame.this.dataStreamer.stopStreaming();
                    }
                    if (s.length() >= 4 && (s.substring(0, 4).equalsIgnoreCase("quit") || s.substring(0, 4).equalsIgnoreCase("exit"))) {
                        TextIOFrame.this.running = false;
                        continue;
                    }
                    String o = EvaluatorHelper.evaluate(s);
                    TextIOFrame.this.out.println(o);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (ParseException e) {
                    TextIOFrame.this.out.println(e);
                    e.printStackTrace();
                }
                catch (MathException e) {
                    TextIOFrame.this.out.println(e);
                    e.printStackTrace();
                }
                catch (StackException e) {
                    TextIOFrame.this.out.println(e);
                    e.printStackTrace();
                }
            }
            TextIOFrame.this.out.println("Exiting HOM");
            System.exit(0);
        }
    });
    EvaluatorHelper evaluatorHelper = new EvaluatorHelper();
    PrintStream out = System.out;
    BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
    DataStreamer dataStreamer = new DataStreamer();

    public TextIOFrame() {
        this.dataStreamer.textOut = this.out;
        ObjectPath.setPackage(new String[]{"java.lang", "phic", "phic.common", "phic.gui", "phic.drug", "phic.doctor", "java.awt", "javax.swing", "java.util"});
        try {
            ObjectPath.setRoot(new Object[]{Current.body, Current.environment, Class.forName("java.lang.Math"), MathExtra.class, Current.person, this.evaluatorHelper});
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        evaluator.Variable.namespaceLookup = this;
        Current.body.receiver = this;
        Variables.initialise();
        EvaluatorHelper.multilineHelp = true;
        this.running = true;
        Current.body.setRunning(true);
        this.thread.start();
        this.out.println("HOM - Human Physiology Model, (c) Dr. Sanjay Manohar");
        this.out.println("Text-only mode");
    }

    public Object getVariableValue(String variableName) {
        if (variableName.equalsIgnoreCase("Time")) {
            return Current.body.getClock().getTimeString(0);
        }
        if (variableName.equalsIgnoreCase("stream")) {
            return this.dataStreamer;
        }
        try {
            return new Double(Variables.forName((String)variableName).node.doubleGetVal());
        }
        catch (IllegalArgumentException e) {
            Object val = evaluator.Variable.table.get(variableName);
            if (val != null) {
                return val;
            }
            throw new EquationException("Variable " + variableName + " not found");
        }
    }

    public void addCloseListener(ActionListener reshowListener) {
    }

    public void doSetup(String setupFile, String setupSection) {
    }

    public void finishDrip(IntravenousInfusion ivi) {
    }

    public void patientWarning(int consciousLevel, String message) {
    }

    public void show() {
    }

    public void hide() {
    }

    public void markEvent(Object event) {
    }

    public JFrame getJFrame() {
        return null;
    }

    public void message(String message) {
    }

    public void error(String s) {
    }

    public static class DataStreamer
    implements Runnable {
        Person person = Current.person;
        VisibleVariable[] vv;
        Variable[] v;
        int mode = 0;
        PrintStream textOut;
        DataOutput binOut;
        int columnWidth;
        public static final int TEXT = 0;
        public static final int BINARY = 1;
        NumberFormat nformat;
        long interval = 100L;
        static final String colsep = " | ";
        Thread thread;
        boolean running = false;

        public void streamText(String format, double rate) {
            this.mode = 0;
            String[] vn = format.split("[\\s,;]+");
            this.vv = new VisibleVariable[vn.length];
            this.v = new Variable[vn.length];
            int i = 0;
            while (i < vn.length) {
                this.vv[i] = Variables.forName(vn[i]);
                this.v[i] = this.vv[i].node.getVDouble();
                ++i;
            }
            this.interval = (long)(1000.0 / rate);
            this.columnWidth = 8;
            this.nformat = NumberFormat.getNumberInstance();
            this.startStreaming();
        }

        public synchronized void startStreaming() {
            if (!this.running) {
                this.thread = new Thread(this);
                this.running = true;
                this.thread.start();
            }
        }

        public synchronized void stopStreaming() {
            if (this.running) {
                this.running = false;
                this.thread = null;
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (this.running) {
                    Object sb;
                    if (this.mode == 0) {
                        sb = new StringBuffer();
                        int i = 0;
                        while (i < this.v.length) {
                            String s = this.nformat.format(this.v[i].get());
                            int nsp = Math.max(0, this.columnWidth - s.length());
                            ((StringBuffer)sb).append(s);
                            int j = 0;
                            while (j < nsp) {
                                ((StringBuffer)sb).append(' ');
                                ++j;
                            }
                            ((StringBuffer)sb).append(colsep);
                            ++i;
                        }
                        this.textOut.println(((StringBuffer)sb).toString());
                    }
                    sb = this;
                    synchronized (sb) {
                        this.wait(this.interval);
                    }
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.running = false;
        }
    }
}

