/*
 * Decompiled with CFR 0.152.
 */
package phic.gui;

import evaluator.Expression;
import evaluator.ObjectPath;
import evaluator.Statement;
import evaluator.Variable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.lang.reflect.Field;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import phic.Body;
import phic.Current;
import phic.common.Clock;
import phic.common.CommonThread;
import phic.common.Quantity;
import phic.common.VDouble;
import phic.gui.GraphPaper;
import phic.gui.Variables;
import phic.gui.VisibleVariable;
import phic.modifiable.Script;

public class SimulationPlotPanel
extends JPanel {
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanel1 = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    JPanel jPanel3 = new JPanel();
    JPanel jPanel4 = new JPanel();
    JSpinner samplestxt = new JSpinner();
    BorderLayout borderLayout3 = new BorderLayout();
    JSpinner divisionstxt = new JSpinner();
    BorderLayout borderLayout4 = new BorderLayout();
    JPanel jPanel5 = new JPanel();
    JPanel jPanel6 = new JPanel();
    JScrollPane jScrollPane1 = new JScrollPane();
    JTextArea scripttxt = new JTextArea();
    JLabel jLabel2 = new JLabel();
    JPanel jPanel7 = new JPanel();
    BorderLayout borderLayout5 = new BorderLayout();
    JPanel jPanel8 = new JPanel();
    BorderLayout borderLayout6 = new BorderLayout();
    JLabel jLabel3 = new JLabel();
    JTextField xmintxt = new JTextField();
    JTextField xmaxtxt = new JTextField();
    JSplitPane jSplitPane1 = new JSplitPane();
    JLabel jLabel1 = new JLabel();
    JTextField timetxt = new JTextField();
    JLabel jLabel4 = new JLabel();
    JScrollPane jScrollPane2 = new JScrollPane();
    JTextArea ytxt = new JTextArea();
    JLabel jLabel5 = new JLabel();
    JPanel jPanel13 = new JPanel();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JLabel jLabel6 = new JLabel();
    JPanel jPanel10 = new JPanel();
    JLabel statustxt = new JLabel();
    BorderLayout borderLayout7 = new BorderLayout();
    Border border1;
    GraphPaper graphPaper1 = new GraphPaper(){

        public void paint(Graphics g) {
            super.paint(g);
        }
    };
    public Action runAction = new AbstractAction("Start"){

        public void actionPerformed(ActionEvent e) {
            if (!SimulationPlotPanel.this.started) {
                SimulationPlotPanel.this.runSimulation();
                this.putValue("Name", "Stop");
            } else if (SimulationPlotPanel.this.currentSim != null) {
                SimulationPlotPanel.this.currentSim.halt();
            }
            this.putValue("Name", "Start");
        }
    };
    double minx;
    double maxx;
    double miny;
    double maxy;
    double dx;
    double simtime;
    int nx;
    int nsamp;
    Script script;
    Expression yexpr;
    boolean started = false;
    VisibleVariable yVariable = null;
    int ps = 4;
    double[][] py;
    double[][] px;
    int npts = 0;
    Simulator currentSim;
    int serial = 0;

    public SimulationPlotPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.border1 = BorderFactory.createBevelBorder(1);
        this.setLayout(this.borderLayout1);
        this.jPanel1.setLayout(this.borderLayout2);
        this.jPanel3.setLayout(this.borderLayout3);
        this.jPanel4.setLayout(this.borderLayout4);
        this.scripttxt.setToolTipText("The script to run at the start of each simulation period. Use 'x' to get the value of x.");
        this.scripttxt.setText("air.O2=0.2+(x/15)");
        this.scripttxt.setColumns(12);
        this.scripttxt.setLineWrap(true);
        this.scripttxt.setRows(4);
        this.jLabel2.setText("Script:");
        this.jPanel7.setLayout(this.borderLayout5);
        this.jPanel8.setLayout(this.borderLayout6);
        this.jLabel3.setHorizontalAlignment(0);
        this.jLabel3.setHorizontalTextPosition(11);
        this.jLabel3.setText("< x <");
        this.xmintxt.setText("0");
        this.xmintxt.setColumns(8);
        this.xmaxtxt.setText("10");
        this.xmaxtxt.setColumns(8);
        this.jSplitPane1.setOrientation(1);
        this.jLabel1.setText("Time per run (s)");
        this.timetxt.setToolTipText("How long to run the simulation before retrieving the value of y");
        this.timetxt.setText("60");
        this.timetxt.setColumns(8);
        this.jLabel4.setText("y=");
        this.ytxt.setToolTipText("The expression to evaluate to get the value of y at each point x");
        this.ytxt.setText("APO2");
        this.ytxt.setColumns(8);
        this.ytxt.setLineWrap(true);
        this.ytxt.setRows(3);
        this.jLabel5.setText("Samples per x");
        this.samplestxt.setToolTipText("How many times to run the simulation at each value of x");
        this.jPanel13.setLayout(this.gridBagLayout1);
        this.jLabel6.setText("Number of x's");
        this.divisionstxt.setToolTipText("Number of different values of x to try");
        this.statustxt.setText("Ready");
        this.jPanel10.setLayout(this.borderLayout7);
        this.jPanel3.setBorder(this.border1);
        this.graphPaper1.setLayout(null);
        this.jPanel5.add((Component)this.jPanel13, null);
        this.jPanel13.add((Component)this.jLabel2, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel13.add((Component)this.jScrollPane1, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel13.add((Component)this.jLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel13.add((Component)this.timetxt, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel13.add((Component)this.jLabel4, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel13.add((Component)this.jLabel5, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel13.add((Component)this.samplestxt, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel13.add((Component)this.jLabel6, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel13.add((Component)this.divisionstxt, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel13.add((Component)this.jScrollPane2, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jScrollPane2.getViewport().add((Component)this.ytxt, null);
        this.jScrollPane1.getViewport().add((Component)this.scripttxt, null);
        this.jPanel4.add((Component)this.jPanel6, "North");
        this.jSplitPane1.add((Component)this.jPanel7, "bottom");
        this.jPanel4.add((Component)this.jPanel5, "Center");
        this.add((Component)this.jPanel1, "Center");
        this.jPanel1.add((Component)this.jPanel3, "South");
        this.jPanel7.add((Component)this.graphPaper1, "Center");
        this.jPanel7.add((Component)this.jPanel8, "South");
        this.jPanel8.add((Component)this.jLabel3, "Center");
        this.jPanel8.add((Component)this.xmintxt, "West");
        this.jPanel8.add((Component)this.xmaxtxt, "East");
        this.jPanel1.add((Component)this.jSplitPane1, "Center");
        this.jSplitPane1.add((Component)this.jPanel4, "top");
        this.jPanel3.add((Component)this.jPanel10, "Center");
        this.jPanel10.add((Component)this.statustxt, "Center");
        this.samplestxt.setValue(new Integer(3));
        this.divisionstxt.setValue(new Integer(5));
    }

    void runSimulation() {
        Object v;
        this.statustxt.setText("Initialising...");
        try {
            this.minx = Double.parseDouble(this.xmintxt.getText());
            this.maxx = Double.parseDouble(this.xmaxtxt.getText());
        }
        catch (NumberFormatException x) {
            this.error("Please enter valid minimum and maximum x values.");
        }
        try {
            v = this.divisionstxt.getValue();
            this.nx = v instanceof Integer ? (Integer)v : Integer.parseInt(v.toString());
            this.dx = (this.maxx - this.minx) / (double)this.nx;
        }
        catch (Exception x) {
            this.error("Please enter a valid number of x-values to try");
        }
        try {
            v = this.samplestxt.getValue();
            this.nsamp = v instanceof Integer ? (Integer)v : Integer.parseInt(v.toString());
        }
        catch (Exception x) {
            this.error("Please enter a valid number of x-values to try");
        }
        try {
            this.simtime = new Expression(this.timetxt.getText()).value();
        }
        catch (Exception x) {
            this.error("Error in time expression: " + x.toString());
            x.printStackTrace();
        }
        try {
            this.script = new Script("PlotScript" + this.serial++, "Plot script", this.scripttxt.getText(), false);
        }
        catch (Exception x) {
            this.error("Error in script expression: " + x.toString());
            x.printStackTrace();
        }
        try {
            Field f;
            this.yexpr = new Expression(this.ytxt.getText());
            this.yVariable = null;
            if (this.yexpr.getCodeLength() == 1 && this.yexpr.getCode()[0] instanceof Variable && ((ObjectPath)(v = (Variable)this.yexpr.getCode()[0])).getMember() instanceof Field && (f = (Field)((ObjectPath)v).getMember()).getType() == VDouble.class) {
                VDouble vd = (VDouble)f.get(((ObjectPath)v).getObject());
                try {
                    this.yVariable = Variables.forVDouble(vd);
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception x) {
            this.error("Error in y expression: " + x.toString());
            x.printStackTrace();
        }
        this.graphPaper1.removeAll();
        this.px = new double[this.nx][this.nsamp];
        this.py = new double[this.nx][this.nsamp];
        int i = 0;
        while (i < this.nx) {
            int j = 0;
            while (j < this.nsamp) {
                this.px[i][j] = Double.NaN;
                this.py[i][j] = Double.NaN;
                ++j;
            }
            ++i;
        }
        this.graphPaper1.setXRange(this.minx, this.maxx);
        this.currentSim = new Simulator();
        new Thread(this.currentSim).start();
    }

    void updateGraph() {
        if (this.npts >= 2) {
            int j;
            this.graphPaper1.removeAll();
            double miny = Double.MAX_VALUE;
            double maxy = Double.MIN_VALUE;
            double sy = 0.0;
            int i = 0;
            while (i < this.py.length) {
                j = 0;
                while (j < this.py[i].length) {
                    if (!Double.isNaN(this.py[i][j])) {
                        miny = Math.min(this.py[i][j], miny);
                        maxy = Math.max(this.py[i][j], maxy);
                        sy += this.py[i][j];
                    }
                    ++j;
                }
                ++i;
            }
            double meany = sy / (double)this.npts;
            this.graphPaper1.setYRange(miny, maxy);
            i = 0;
            while (i < this.py.length) {
                j = 0;
                while (j < this.py[i].length) {
                    if (!Double.isNaN(this.px[i][j]) && !Double.isNaN(this.py[i][j])) {
                        this.graphAddPoint(this.px[i][j], this.py[i][j]);
                    }
                    ++j;
                }
                ++i;
            }
            this.graphPaper1.repaint();
        }
    }

    void graphAddPoint(double x, double y) {
        JPanel c = new JPanel();
        this.graphPaper1.add(c);
        c.setBounds(this.graphPaper1.xS(x) - this.ps, this.graphPaper1.yS(y) - this.ps, this.ps * 2, this.ps * 2);
        c.setOpaque(true);
        c.setBackground(Color.red);
        c.setBorder(new BevelBorder(0));
        String xstr = Quantity.toString(x);
        String ystr = Quantity.toString(y);
        if (this.yVariable != null) {
            ystr = this.yVariable.formatValue(y, true, false);
        }
        c.setToolTipText("x=" + xstr + ", y=" + ystr);
    }

    void error(String x) {
        JOptionPane.showMessageDialog(this, x, "Error in simulation", 0);
    }

    public void halt() {
        if (this.currentSim != null && this.started) {
            this.currentSim.halt();
        }
    }

    class Simulator
    implements Runnable {
        Body body = Current.body;
        Clock clock = this.body.getClock();
        CommonThread thread = Current.thread;
        boolean deathDisabled;
        private boolean isHalted;

        Simulator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (SimulationPlotPanel.this.started) {
                SimulationPlotPanel.this.error("Simulation already running");
            }
            SimulationPlotPanel.this.started = true;
            this.isHalted = false;
            this.deathDisabled = this.body.brain.conscious.disableDeath;
            this.body.brain.conscious.disableDeath = true;
            try {
                this.clock.stop();
                SimulationPlotPanel.this.npts = 0;
                int xi = 0;
                while (xi < SimulationPlotPanel.this.nx) {
                    double xval = SimulationPlotPanel.this.minx + (double)xi * SimulationPlotPanel.this.dx;
                    int si = 0;
                    while (si < SimulationPlotPanel.this.nsamp) {
                        this.body.resetBodyValues();
                        new Statement("x=" + String.valueOf(xval)).evaluate();
                        SimulationPlotPanel.this.script.executeOnce();
                        SimulationPlotPanel.this.statustxt.setText("Simulating point " + SimulationPlotPanel.this.npts + ": x=" + Quantity.toString(xval));
                        Simulator simulator = this;
                        synchronized (simulator) {
                            this.body.getClock().requestNotifyAfter(SimulationPlotPanel.this.simtime, this);
                            this.clock.start();
                            this.wait();
                        }
                        this.clock.stop();
                        while (this.thread.isInCycle()) {
                            Thread.sleep(100L);
                        }
                        SimulationPlotPanel.this.px[xi][si] = xval;
                        SimulationPlotPanel.this.py[xi][si] = SimulationPlotPanel.this.yexpr.value();
                        ++SimulationPlotPanel.this.npts;
                        System.out.println(String.valueOf(SimulationPlotPanel.this.px[xi][si]) + "\t= " + SimulationPlotPanel.this.py[xi][si]);
                        SimulationPlotPanel.this.updateGraph();
                        if (this.isHalted) break;
                        ++si;
                    }
                    if (!this.isHalted) {
                        ++xi;
                        continue;
                    }
                    break;
                }
            }
            catch (Exception x) {
                SimulationPlotPanel.this.error("Error during simulation: " + x.toString());
                x.printStackTrace();
            }
            this.clock.stop();
            SimulationPlotPanel.this.started = false;
            this.body.brain.conscious.disableDeath = this.deathDisabled;
            SimulationPlotPanel.this.statustxt.setText("Done");
        }

        public synchronized void halt() {
            this.isHalted = true;
            this.notify();
        }
    }
}

