/*
 * Decompiled with CFR 0.152.
 */
package phic.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.Document;
import javax.swing.tree.DefaultMutableTreeNode;
import phic.Body;
import phic.Current;
import phic.IntravenousInfusion;
import phic.Person;
import phic.Resource;
import phic.common.Clock;
import phic.common.DiseaseCreator;
import phic.common.Fluids;
import phic.common.IniReader;
import phic.common.Organ;
import phic.common.TextReceiver;
import phic.gui.BodyTreeLabelled;
import phic.gui.ConsciousStateLabel;
import phic.gui.ContainerView;
import phic.gui.CreateGraphTarget;
import phic.gui.CurveNodeView;
import phic.gui.DeathBox;
import phic.gui.HorzScrollGraph;
import phic.gui.InfusionPanel;
import phic.gui.LimitChecker;
import phic.gui.LimitedNode;
import phic.gui.Node;
import phic.gui.NodeView;
import phic.gui.OldNodeView;
import phic.gui.OrbitPanel;
import phic.gui.PhicEvaluator;
import phic.gui.PhicFileDialog;
import phic.gui.PhicFrameActions;
import phic.gui.PhicFrameShortcutKeyMapper;
import phic.gui.RatePanel;
import phic.gui.RewindDialog;
import phic.gui.ThinNodeView;
import phic.gui.VariablePropertiesDialog;
import phic.gui.Variables;
import phic.gui.VisibleVariable;
import phic.gui.graphics.ECGIcon;
import sanjay.PlafMenu;

public class SimplePhicFrame
extends JFrame
implements TextReceiver {
    JPanel mainFramePanel = new JPanel();
    JMenuBar menuBar = new JMenuBar();
    JMenu filemenu = new JMenu();
    JMenuItem savecommand = new JMenuItem();
    JMenuItem opencommand = new JMenuItem();
    JMenuItem exitcommand = new JMenuItem();
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel leftHandPanel = new JPanel();
    JPanel rightHandPanel = new JPanel();
    JPanel jPanel4 = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    BorderLayout borderLayout3 = new BorderLayout();
    JPanel jPanel5 = new JPanel();
    JButton adddisplay = new JButton();
    BodyTreeLabelled bodyTree = new BodyTreeLabelled();
    JPanel controlBar = new JPanel();
    BorderLayout borderLayout4 = new BorderLayout();
    JPanel rightBottomPanel = new JPanel();
    Border border1;
    BorderLayout borderLayout5 = new BorderLayout();
    JPanel graphspane = new JPanel();
    JPanel variablepane = new JPanel();
    JButton start = new JButton();
    JScrollPane consolepanel = new JScrollPane();
    PhicEvaluator statusbar = new PhicEvaluator();
    JMenu graphsmenu = new JMenu();
    JMenuItem rescalecommand = new JMenuItem();
    JMenu fluidsmenu = new JMenu();
    JMenuItem ivdrugmenu = new JMenuItem();
    JMenu fluidlist = new JMenu();
    Border border2;
    JButton namebox = new JButton();
    JMenuItem oraldrugmenu = new JMenuItem();
    BorderLayout borderLayout6 = new BorderLayout();
    LimitChecker limitChecker = new LimitChecker();
    ConsciousStateLabel statuscommand = new ConsciousStateLabel();
    JSlider timecomp = new JSlider();
    JLabel timeCompLabel = new JLabel();
    JButton restartbutton = new JButton();
    JSplitPane mainSplitter = new JSplitPane();
    JMenu graphsetupmenu = new JMenu();
    JMenuItem jMenuItem1 = new JMenuItem();
    JMenu toolsmenu = new JMenu();
    JMenuItem jMenuItem2 = new JMenuItem();
    JMenu orbitsmenu = new JMenu();
    BorderLayout borderLayout7 = new BorderLayout();
    JMenuItem jMenuItem3 = new JMenuItem();
    JPanel horizontalGraphs = new JPanel();
    JMenuItem jMenuItem7 = new JMenuItem();
    JMenuItem jMenuItem10 = new JMenuItem();
    JMenuItem lifesupportmenu = new JMenuItem();
    JMenuItem ecg_menu = new JMenuItem();
    JMenu helpmenu = new JMenu();
    JMenuItem examinemenu = new JMenuItem();
    JMenuItem druglevelsmenu = new JMenuItem();
    JMenu ratemenu = new JMenu();
    JMenuItem aboutmenu = new JMenuItem();
    public HorzScrollGraph graph = new HorzScrollGraph();
    JPanel dripspanel = new JPanel();
    JMenuItem scenariomenu = new JMenuItem();
    JMenuItem physhelpmenu = new JMenuItem();
    JMenuItem restartmenu = new JMenuItem();
    JButton rewindbutton = new JButton();
    RewindDialog rewindDialog = new RewindDialog();
    JMenuItem jMenuItem13 = new JMenuItem();
    JMenuItem jMenuItem14 = new JMenuItem();
    JMenuItem printgrcommand = new JMenuItem();
    JMenuItem printsccommand = new JMenuItem();
    JMenuItem printlgcommand = new JMenuItem();
    JPanel bottomrightpanel = new JPanel();
    JMenuItem jMenuItem15 = new JMenuItem();
    JMenu diseaseMenu = new JMenu();
    JButton partialreset = new JButton();
    JMenuItem commentsmenu = new JMenuItem();
    LayoutManager boxLayout21 = new BoxLayout(this.dripspanel, 1);
    JSplitPane rightSplitter = new JSplitPane(0);
    BoxLayout gridBagLayout1 = new BoxLayout(this.horizontalGraphs, 1);
    JLabel timebox = new TimeLabel();
    ECGIcon slowPanel = new ECGIcon();
    ImageIcon picon = new ImageIcon(Resource.loader.getImageResource("Play.gif"));
    ImageIcon sicon = new ImageIcon(Resource.loader.getImageResource("Pause.gif"));
    ImageIcon ricon = new ImageIcon(Resource.loader.getImageResource("SmallCross.gif"));
    ImageIcon fficon = new ImageIcon(Resource.loader.getImageResource("FastForward.gif"));
    Image frameicon = Resource.loader.getImageResource("Humanico16.gif");
    public final String generalHelpResource = "help/index.html";
    public String currentHelpResource = "patient/DefaultScenario.html";
    public String interpreterHelpResource = "help/Scripting.html";
    PhicFrameActions frameActions;
    static final int MAX_TEXT = 5000;
    private static final boolean DEBUG_ERRORS = true;
    public boolean showSelectedVariableEditor = true;
    Component selectiondisplay = null;
    Node selectednode = null;
    Action addscrollgraphAL = new AbstractAction("AddScrollGraph"){

        public void actionPerformed(ActionEvent e) {
            SimplePhicFrame.this.createThinView(SimplePhicFrame.this.selectednode, true);
        }
    };
    Vector infusionPanels = new Vector();
    ActionListener fluidselectionlistener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            String fluidName = e.getActionCommand();
            IntravenousInfusion bag = new IntravenousInfusion(Current.body.blood);
            bag.add(Fluids.get(fluidName, 1.0));
            InfusionPanel p = new InfusionPanel(bag, fluidName);
            SimplePhicFrame.this.dripspanel.add(p);
            SimplePhicFrame.this.infusionPanels.add(p);
            Current.environment.addInfusion(bag);
            SimplePhicFrame.this.validate();
        }
    };
    ContainerView containerview;
    boolean started = false;
    double[] timeCompressionValues = new double[]{1000.0, 100.0, 16.666666666666668, 1.6666666666666667, 0.2777777777777778, 0.046296296296296294};
    String[] timeCompressionDescriptions = new String[]{"Real time", "10 seconds per sec", "1 minute per sec", "10 minutes per sec", "1 hour per sec", "6 hours per sec"};
    public static final String graphSetupsResourceFile = "GraphSetups.txt";
    public static final String orbitSetupsResourceFile = "OrbitSetups.txt";
    IniReader graphsetups = new IniReader("GraphSetups.txt");
    IniReader orbitsini = new IniReader("OrbitSetups.txt");
    Vector nodeViews = new Vector();
    boolean restartClock = false;
    PhicFileDialog filer;
    Vector scripts = new Vector();
    JMenuItem interpreterHelpMenu = new JMenuItem();
    JPanel jPanel1 = new JPanel();
    BorderLayout borderLayout8 = new BorderLayout();
    JPanel jPanel8 = new JPanel();
    JPanel sharedPanel = new JPanel();
    BoxLayout sharedLayout = new BoxLayout(this.sharedPanel, 1);
    BorderLayout borderLayout9 = new BorderLayout();
    JPanel spacer = new JPanel();
    JMenuItem diagramsmenu = new JMenuItem();
    boolean allowRatePanel = true;
    WindowListener wl = new WindowAdapter(){

        public void windowClosed(WindowEvent e) {
            Current.body.setRunning(false);
        }
    };

    public JFrame getJFrame() {
        return this;
    }

    public static void main(String[] args) {
        SimplePhicFrame f = new SimplePhicFrame();
        f.show();
    }

    public SimplePhicFrame() {
        Current.body.setRunning(false);
        this.frameActions = new PhicFrameActions(this);
        this.setupSetupMenu();
        DiseaseCreator d = new DiseaseCreator();
        this.diseaseMenu = d.getMenu();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.bodyTree.tree.addTreeSelectionListener(new MyTSL());
        this.setupFluids(this.fluidlist);
        this.updateNameBox();
        Current.body.receiver = this;
        this.limitChecker.start();
        this.setIconImage(this.frameicon);
        this.helpmenu.add(new PlafMenu(this.getContentPane()));
        this.setupRateMenu();
        this.updateSpeedSlider();
        Variables.initialise();
        PhicFrameShortcutKeyMapper.mapKeys(this);
        this.slowPanel.setBody(Current.body);
        this.addWindowListener(this.wl);
        try {
            this.filer = PhicFileDialog.createFileDialog();
        }
        catch (IllegalAccessException e) {
            System.out.println("Running without filer - no access.");
            this.savecommand.setEnabled(false);
            this.opencommand.setEnabled(false);
        }
    }

    void setupRateMenu() {
        Component[] c = this.graph.popupmenu.getComponents();
        int i = 0;
        while (i < c.length) {
            if (c[i] instanceof JMenuItem) {
                JMenuItem o = (JMenuItem)c[i];
                JMenuItem n = new JMenuItem(o.getAction());
                n.setBackground(o.getBackground());
                this.ratemenu.add(n);
            }
            ++i;
        }
    }

    void copyPopupmenuToJMenu(JPopupMenu src, JMenu dst) {
        Component[] c = src.getComponents();
        int i = 0;
        while (i < c.length) {
            dst.add(c[i]);
            ++i;
        }
    }

    void setupSetupMenu() {
        ActionListener smal = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SimplePhicFrame.this.graphsetup(e);
            }
        };
        try {
            this.graphsetupmenu = Resource.loader.createMenuFromIni(graphSetupsResourceFile, "Views", smal, null);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.setupMenu(this.orbitsmenu, this.orbitsini, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SimplePhicFrame.this.createOrbit(e.getActionCommand());
            }
        }, null);
    }

    void setupMenu(JMenu menu, IniReader ini, ActionListener al, Icon icon) {
        String[] names = ini.getSectionHeaders();
        int i = 0;
        while (i < names.length) {
            JMenuItem m = new JMenuItem();
            m.setText(names[i]);
            m.addActionListener(al);
            if (icon != null) {
                m.setIcon(icon);
            }
            menu.add(m);
            ++i;
        }
    }

    void setupFluids(JMenu p) {
        ImageIcon fluidicon = new ImageIcon(Resource.loader.getImageResource("Container.gif"));
        String[] names = Fluids.getNames();
        int i = 0;
        while (i < names.length) {
            JMenuItem mi = new JMenuItem(names[i], fluidicon);
            mi.addActionListener(this.fluidselectionlistener);
            p.add(mi);
            ++i;
        }
    }

    void jbInit() throws Exception {
        this.border1 = BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.border2 = BorderFactory.createBevelBorder(1);
        this.setDefaultCloseOperation(2);
        this.setJMenuBar(this.menuBar);
        this.setTitle("Human Physiology");
        this.filemenu.setText("File");
        this.savecommand.setText("Save state");
        this.savecommand.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SimplePhicFrame.this.savecommand_actionPerformed(e);
            }
        });
        this.opencommand.setText("Open state");
        this.opencommand.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SimplePhicFrame.this.opencommand_actionPerformed(e);
            }
        });
        this.exitcommand.setAction(this.frameActions.exitAction);
        this.mainFramePanel.setLayout(this.borderLayout1);
        this.jPanel4.setLayout(this.borderLayout2);
        this.leftHandPanel.setLayout(this.borderLayout3);
        this.adddisplay.setMinimumSize(new Dimension(0, 0));
        this.adddisplay.setToolTipText("Display graph of selected quantity");
        this.adddisplay.setText("Display");
        this.adddisplay.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SimplePhicFrame.this.adddisplay_actionPerformed(e);
            }
        });
        this.rightHandPanel.setLayout(this.borderLayout4);
        this.rightSplitter.setResizeWeight(1.0);
        this.interpreterHelpMenu.setText("Interpreter help");
        this.diseaseMenu.setText("Diseases");
        this.partialreset.setAction(this.frameActions.partialResetAction);
        this.partialreset.setMargin(new Insets(2, 2, 2, 2));
        this.partialreset.setText("");
        this.jPanel8.setLayout(this.borderLayout8);
        this.sharedPanel.setLayout(this.sharedLayout);
        this.jPanel1.setLayout(this.borderLayout9);
        this.spacer.setBorder(BorderFactory.createLoweredBevelBorder());
        this.spacer.setPreferredSize(new Dimension(4, 0));
        this.graph.setMinimumSize(new Dimension(20, 15));
        this.graph.setPreferredSize(new Dimension(10, 15));
        this.diagramsmenu.setText("Diagrams");
        this.dripspanel.setLayout(this.boxLayout21);
        this.commentsmenu.setAction(this.frameActions.sendProblemToAuthor);
        this.rightHandPanel.add(this.rightSplitter);
        this.rightBottomPanel.setLayout(this.borderLayout5);
        this.graphspane.setLayout(this.borderLayout7);
        this.leftHandPanel.setPreferredSize(new Dimension(150, 371));
        this.start.setAction(this.frameActions.startAction);
        this.start.setToolTipText("Stop / Go");
        this.start.setMargin(new Insets(1, 1, 1, 1));
        this.start.setText("");
        this.statusbar.setToolTipText("Scrolling log");
        this.statusbar.setPreferredSize(new Dimension(35, 80));
        this.statusbar.setText("HOM\n");
        this.statusbar.setFont(new Font("Dialog", 0, 12));
        this.consolepanel.setAutoscrolls(true);
        this.consolepanel.setPreferredSize(new Dimension(39, 80));
        this.consolepanel.setMinimumSize(new Dimension(39, 24));
        this.graphsmenu.setText("Graphs");
        this.rescalecommand.setAction(this.frameActions.rescaleAction);
        this.fluidsmenu.setText("Give");
        this.ivdrugmenu.setAction(this.frameActions.ivDrugBolusAction);
        this.oraldrugmenu.setAction(this.frameActions.oralDrugAction);
        this.fluidlist.setText("Fluid");
        this.timebox.setBorder(this.border2);
        this.timebox.setPreferredSize(new Dimension(180, 21));
        this.timebox.setToolTipText("Current date and time");
        this.timebox.setText("time");
        this.namebox.setAction(this.frameActions.nameChangeAction);
        this.namebox.setToolTipText("Name of patient");
        this.timecomp.setMaximum(this.timeCompressionValues.length - 1);
        this.timecomp.setSnapToTicks(true);
        this.timecomp.setMajorTickSpacing(5);
        this.timecomp.setPaintTicks(true);
        this.timecomp.setMinorTickSpacing(1);
        this.timecomp.setToolTipText("Time compression");
        this.timecomp.setPreferredSize(new Dimension(80, 24));
        this.timecomp.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                SimplePhicFrame.this.timecomp_stateChanged(e);
            }
        });
        this.timecomp.setValue(3);
        this.timeCompLabel.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                SimplePhicFrame.this.timeCompLabel_mouseReleased(e);
            }
        });
        this.restartbutton.setAction(this.frameActions.restartAction);
        this.restartbutton.setMargin(new Insets(1, 1, 1, 1));
        this.restartbutton.setText("");
        this.mainSplitter.setLeftComponent(this.leftHandPanel);
        this.mainSplitter.setOneTouchExpandable(true);
        this.mainSplitter.setRightComponent(this.rightHandPanel);
        this.graphsetupmenu.setText("Views");
        this.variablepane.setLayout(this.borderLayout6);
        this.bodyTree.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SimplePhicFrame.this.bodyTree_actionPerformed(e);
            }
        });
        this.limitChecker.setMinimumSize(new Dimension(0, 17));
        this.toolsmenu.setText("Tools");
        this.jMenuItem2.setText("Medical reports");
        this.jMenuItem2.addActionListener(this.frameActions.medicalReportsAction);
        this.orbitsmenu.setText("New Orbit");
        this.dripspanel.setMinimumSize(new Dimension(0, 0));
        this.horizontalGraphs.setMinimumSize(new Dimension(0, 0));
        this.horizontalGraphs.setLayout(this.gridBagLayout1);
        this.jMenuItem3.setText("Close all");
        this.jMenuItem3.addActionListener(this.frameActions.closeAllGraphsAction);
        this.jMenuItem7.setAction(this.frameActions.pathologyAnalysisAction);
        this.jMenuItem10.setText("Fluid balance sheet");
        this.jMenuItem10.addActionListener(this.frameActions.fluidBalanceAction);
        this.lifesupportmenu.setAction(this.frameActions.lifeSupportAction);
        this.ecg_menu.setAction(this.frameActions.ecgAction);
        this.helpmenu.setText("Help");
        this.examinemenu.setAction(this.frameActions.examineAction);
        this.statuscommand.setPreferredSize(new Dimension(90, 21));
        this.druglevelsmenu.setAction(this.frameActions.drugLevelsAction);
        this.ratemenu.setText("Rate");
        this.aboutmenu.setAction(this.frameActions.aboutAction);
        this.scenariomenu.setAction(this.frameActions.scenarioHelp);
        this.physhelpmenu.setAction(this.frameActions.physiologyHelp);
        this.restartmenu.setAction(this.frameActions.restartAction);
        this.rewindbutton.setAction(this.frameActions.rewindAction);
        this.rewindbutton.setActionCommand("Rewind");
        this.rewindbutton.setText("");
        this.rewindbutton.setToolTipText("Go back");
        this.rewindbutton.setMargin(new Insets(1, 1, 1, 1));
        this.jMenuItem13.setAction(this.frameActions.optionsAction);
        this.jMenuItem14.setAction(this.frameActions.scriptEditorAction);
        this.printgrcommand.setAction(this.frameActions.printGraphs);
        this.printsccommand.setAction(this.frameActions.printScreen);
        this.printlgcommand.setAction(this.frameActions.printLog);
        this.jMenuItem15.setAction(this.frameActions.monitoringAction);
        this.menuBar.add(this.filemenu);
        this.menuBar.add(this.graphsmenu);
        this.menuBar.add(this.fluidsmenu);
        this.menuBar.add(this.toolsmenu);
        this.menuBar.add(this.helpmenu);
        this.filemenu.add(this.savecommand);
        this.filemenu.add(this.opencommand);
        this.filemenu.add(this.frameActions.copyPersonData);
        this.filemenu.addSeparator();
        this.filemenu.add(this.printsccommand);
        this.filemenu.add(this.printlgcommand);
        this.filemenu.add(this.printgrcommand);
        this.filemenu.addSeparator();
        this.filemenu.add(this.exitcommand);
        this.getContentPane().add((Component)this.mainFramePanel, "Center");
        this.leftHandPanel.add((Component)this.jPanel4, "Center");
        this.jPanel4.add((Component)this.jPanel5, "South");
        this.jPanel5.add((Component)this.adddisplay, null);
        this.jPanel4.add((Component)this.bodyTree, "Center");
        this.jPanel4.add((Component)this.dripspanel, "North");
        this.leftHandPanel.add((Component)this.variablepane, "South");
        this.rightSplitter.add((Component)this.rightBottomPanel, "bottom");
        this.rightBottomPanel.add((Component)this.consolepanel, "Center");
        this.rightBottomPanel.add((Component)this.limitChecker, "North");
        this.rightBottomPanel.add((Component)this.slowPanel, "East");
        this.slowPanel.setVisible(false);
        this.slowPanel.setPreferredSize(new Dimension(30, 30));
        this.consolepanel.getViewport().add((Component)this.statusbar, null);
        this.rightSplitter.add((Component)this.graphspane, "top");
        this.graphspane.add((Component)this.graph, "Center");
        this.graphspane.add((Component)this.horizontalGraphs, "South");
        this.rightHandPanel.add((Component)this.jPanel1, "East");
        this.jPanel1.add((Component)this.jPanel8, "Center");
        this.jPanel8.add((Component)this.sharedPanel, "North");
        this.jPanel1.add((Component)this.spacer, "West");
        this.controlBar.add((Component)this.namebox, null);
        this.controlBar.add((Component)this.statuscommand, null);
        this.controlBar.add((Component)this.timebox, null);
        this.controlBar.add((Component)this.restartbutton, null);
        this.controlBar.add((Component)this.partialreset, null);
        this.controlBar.add((Component)this.rewindbutton, null);
        this.controlBar.add((Component)this.start, null);
        this.controlBar.add((Component)this.timecomp, null);
        this.controlBar.add((Component)this.timeCompLabel, null);
        this.mainFramePanel.add((Component)this.controlBar, "North");
        this.mainFramePanel.add((Component)this.mainSplitter, "Center");
        this.graphsmenu.add(this.ratemenu);
        this.graphsmenu.add(this.orbitsmenu);
        this.graphsmenu.addSeparator();
        this.graphsmenu.add(this.graphsetupmenu);
        this.graphsmenu.add(this.jMenuItem3);
        this.graphsmenu.add(this.rescalecommand);
        this.graphsmenu.add(this.frameActions.zoomInAll);
        this.graphsmenu.add(this.frameActions.zoomOutAll);
        this.graphsmenu.add(this.druglevelsmenu);
        this.graphsmenu.add(this.jMenuItem15);
        this.graphsmenu.add(this.frameActions.quickAddAction);
        this.fluidsmenu.add(this.fluidlist);
        this.fluidsmenu.addSeparator();
        this.fluidsmenu.add(this.ivdrugmenu);
        this.fluidsmenu.add(this.oraldrugmenu);
        this.toolsmenu.add(this.jMenuItem2);
        this.toolsmenu.add(this.jMenuItem7);
        this.toolsmenu.add(this.jMenuItem10);
        this.toolsmenu.add(this.lifesupportmenu);
        this.toolsmenu.add(this.examinemenu);
        this.toolsmenu.add(this.ecg_menu);
        this.toolsmenu.add(this.diagramsmenu);
        this.toolsmenu.add(this.frameActions.simulationPlot);
        this.toolsmenu.addSeparator();
        this.toolsmenu.add(this.frameActions.editControllersAction);
        this.toolsmenu.add(this.diseaseMenu);
        this.toolsmenu.add(this.jMenuItem14);
        this.toolsmenu.add(this.jMenuItem13);
        this.toolsmenu.add(this.frameActions.allEquationsAction);
        this.helpmenu.add(this.scenariomenu);
        this.helpmenu.add(this.physhelpmenu);
        this.helpmenu.add(this.interpreterHelpMenu);
        this.helpmenu.addSeparator();
        this.helpmenu.add(this.frameActions.showShortcuts);
        this.helpmenu.add(this.commentsmenu);
        this.helpmenu.add(this.frameActions.goToWebsite);
        this.helpmenu.add(this.aboutmenu);
        this.mainSplitter.setDividerLocation(200);
        this.statusbar.requestFocus();
        this.filemenu.add(this.restartmenu);
        this.diagramsmenu.addActionListener(this.frameActions.diagramsAction);
        PhicFrameActions phicFrameActions = this.frameActions;
        phicFrameActions.getClass();
        this.interpreterHelpMenu.addActionListener(phicFrameActions.new PhicFrameActions.HTMLMessageAction(this.interpreterHelpResource, "Interpreter help"));
        this.getRootPane().setDefaultButton(this.start);
        String longest = "";
        int i = 0;
        while (i < this.timeCompressionDescriptions.length) {
            if (this.timeCompressionDescriptions[i].length() > longest.length()) {
                longest = this.timeCompressionDescriptions[i];
            }
            ++i;
        }
        this.timeCompLabel.setText(longest);
        this.timeCompLabel.setPreferredSize(this.timeCompLabel.getPreferredSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void message(final String s) {
        PhicEvaluator phicEvaluator = this.statusbar;
        synchronized (phicEvaluator) {
            Document d = this.statusbar.getDocument();
            try {
                d.insertString(d.getLength(), String.valueOf('\n') + s, null);
                int len = d.getLength();
                this.statusbar.setSelectionStart(len);
                if (len > 5000) {
                    d.remove(0, len / 2);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (s.indexOf(" died") >= 0) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        SimplePhicFrame.this.die(s);
                    }
                });
            }
        }
    }

    public void error(String s) {
        this.message(s);
        this.stopPressed();
        JOptionPane.showMessageDialog(this, s, "Error in calculations", 0);
    }

    public void setSelectPanel(Component c) {
        if (this.selectiondisplay != null) {
            this.variablepane.remove(this.selectiondisplay);
        }
        this.selectiondisplay = c;
        if (this.selectiondisplay != null) {
            this.variablepane.add(this.selectiondisplay);
        }
        this.validateTree();
        this.variablepane.repaint();
    }

    void adddisplay_actionPerformed(ActionEvent e) {
        JPopupMenu menu = this.createDisplayPopup(this.selectednode);
        JComponent src = (JComponent)e.getSource();
        if (menu == null) {
            return;
        }
        menu.show(src, 0, 0);
    }

    JPopupMenu createDisplayPopup(Node n) {
        OldNodeView.Type[] type = OldNodeView.Type.forNode(n);
        if (type.length > 0) {
            JPopupMenu displaytypemenu = new JPopupMenu("Display");
            if (this.selectednode.getType() == 2) {
                JMenuItem m = displaytypemenu.add("Scroll Graph");
                m.addActionListener(this.addscrollgraphAL);
            }
            int i = 0;
            while (i < type.length) {
                JMenuItem m = displaytypemenu.add(type[i].toString());
                m.addActionListener(new adddisplayAL(type[i].type));
                ++i;
            }
            return displaytypemenu;
        }
        return null;
    }

    NodeView createThinView(Node node, boolean showGraph) {
        int i = 0;
        while (i < this.nodeViews.size()) {
            NodeView n = (NodeView)this.nodeViews.get(i);
            if (n.node.equals(node) && (n.node.getType() == 9 || n.node.getType() == 10)) {
                JCheckBox b = ((ThinNodeView)n.content).graphcheckbox;
                if (b.isSelected() != showGraph) {
                    b.doClick();
                }
                return n;
            }
            ++i;
        }
        NodeView n = this.showVariableInMain(node, 9);
        if (showGraph) {
            ((ThinNodeView)n.content).graphcheckbox.doClick();
        }
        return n;
    }

    public void finishDrip(IntravenousInfusion n) {
        int i = 0;
        while (i < this.infusionPanels.size()) {
            InfusionPanel p = (InfusionPanel)this.infusionPanels.get(i);
            if (p.infusion == n) {
                this.dripspanel.remove(p);
                this.infusionPanels.remove(i--);
            }
            ++i;
        }
        this.validate();
    }

    void addToShared(JComponent c) {
        this.sharedPanel.add(c);
    }

    NodeView showVariableInMain(Node n, int type) {
        NodeView nv;
        Cursor oldCursor = this.getCursor();
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            nv = new OldNodeView.Type(type).instantiate(n, this.graph);
            this.nodeViews.add(nv);
            if (!nv.needsNewFrame()) {
                this.addToShared(nv);
            } else {
                this.horizontalGraphs.add(nv);
            }
            this.validateLater();
        }
        finally {
            this.setCursor(oldCursor);
        }
        return nv;
    }

    protected void stopPressed() {
        Current.body.setRunning(false);
        this.start.setIcon(this.picon);
        this.started = false;
    }

    protected void startPressed() {
        Current.body.setRunning(true);
        this.start.setIcon(this.sicon);
        this.started = true;
    }

    void command(ActionEvent e) {
        String c = e.getActionCommand();
    }

    void timecomp_stateChanged(ChangeEvent e) {
        int i = this.timecomp.getValue();
        double value = this.timeCompressionValues[i];
        Current.body.getClock().setSecond(value);
        this.timeCompLabel.setToolTipText("x" + Math.round(1000.0 / value));
        this.timeCompLabel.setText(this.timeCompressionDescriptions[i]);
        this.displaySlowModeItems(Current.body.getClock().isSlowMode);
    }

    void displaySlowModeItems(boolean show) {
        this.slowPanel.setVisible(show);
    }

    public void updateTimeCompText() {
        int i = this.timecomp.getValue();
        double value = this.timeCompressionValues[i];
        this.timeCompLabel.setToolTipText("x" + Math.round(1000.0 / value));
        this.timeCompLabel.setText(this.timeCompressionDescriptions[i]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doFullReset() {
        Organ.DataLock dataLock = Organ.cycleLock;
        synchronized (dataLock) {
            Current.body.resetAllValues();
            this.statusbar.setText("Restarted\n");
            this.rewindDialog.reset();
            this.graph.reset();
        }
        this.graph.removeAnyDrugQuantities();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doPartialReset() {
        Organ.DataLock dataLock = Organ.cycleLock;
        synchronized (dataLock) {
            Current.body.resetBodyValues();
            this.statusbar.setText("Restarted\n");
            this.rewindDialog.reset();
            this.graph.reset();
        }
        this.graph.removeAnyDrugQuantities();
    }

    void graphsetup(ActionEvent e) {
        boolean r = Current.body.getClock().running;
        if (r) {
            Current.body.setRunning(false);
        }
        Cursor previousCursor = this.getCursor();
        System.out.println("Loading graph setup " + e.getActionCommand());
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            String[][] gs;
            if (e.getSource() instanceof String[][]) {
                gs = (String[][])e.getSource();
            } else {
                String s = e.getActionCommand();
                gs = this.graphsetups.getSectionPairs(s);
            }
            this.closeAllGraphs();
            int ngraphs = 0;
            CurveNodeView lastCurve = null;
            String orbitXVarName = null;
            int i = 0;
            while (i < gs.length) {
                block24: {
                    String varname = gs[i][0];
                    if (gs[i][1].equalsIgnoreCase("orbit")) {
                        if (orbitXVarName == null) {
                            orbitXVarName = varname;
                        } else {
                            this.createOrbit(Variables.forName(orbitXVarName), Variables.forName(varname));
                            orbitXVarName = null;
                        }
                    } else if (gs[i][1].equalsIgnoreCase("curvepointx") || gs[i][1].equalsIgnoreCase("curvepointy")) {
                        if (lastCurve == null) {
                            throw new IllegalStateException("error: no curves before " + gs[i][0] + "=" + gs[i][1]);
                        }
                        lastCurve.panel.addPointNode(Variables.forName((String)varname).node, Color.red, gs[i][1].equalsIgnoreCase("curvepointy"));
                    } else if (gs[i][0].equalsIgnoreCase("curvedescription")) {
                        if (lastCurve == null) {
                            throw new IllegalStateException("error: no curves before description");
                        }
                        lastCurve.panel.setDescription(gs[i][1]);
                    } else {
                        OldNodeView.Type type = new OldNodeView.Type(gs[i][1]);
                        try {
                            NodeView nv;
                            VisibleVariable variable = Variables.forName(varname);
                            if (gs[i][1].equals("Graph") || gs[i][1].equals("GraphSlider")) {
                                nv = this.createThinView(variable.node, true);
                                ++ngraphs;
                                if (!gs[i][1].equals("GraphSlider")) {
                                    nv.t.setReadOnly(true);
                                }
                            } else {
                                nv = this.showVariableInMain(variable.node, type.type);
                            }
                        }
                        catch (IllegalArgumentException ex) {
                            if (gs[i][1].equals("Graph")) {
                                this.graph.addNewVariable(Node.findNodeByName(varname));
                                ++ngraphs;
                            }
                            NodeView n = this.showVariableInMain(Node.findNodeByName(varname), type.type);
                            if (!(n instanceof CurveNodeView)) break block24;
                            lastCurve = (CurveNodeView)n;
                        }
                    }
                }
                ++i;
            }
            this.graphspane.repaint();
            if (r) {
                Current.body.setRunning(true);
            }
        }
        finally {
            this.setCursor(previousCursor);
        }
    }

    void closeAllGraphs() {
        this.sharedPanel.removeAll();
        this.nodeViews.removeAllElements();
        this.graph.removeAllGraphs();
    }

    void createOrbit(String name) {
        String[] s = this.orbitsini.getSectionStrings(name);
        VisibleVariable v1 = Variables.forName(s[0]);
        VisibleVariable v2 = Variables.forName(s[1]);
        this.addToShared(new OrbitPanel(v1, v2, (CreateGraphTarget)this.graph));
    }

    void createOrbit(VisibleVariable x, VisibleVariable y) {
        this.addToShared(new OrbitPanel(x, y, (CreateGraphTarget)this.graph));
    }

    public void markEvent(Object event) {
        this.graph.mark(event);
    }

    void bodyTree_actionPerformed(ActionEvent e) {
        VisibleVariable v;
        try {
            v = Variables.forName(e.getActionCommand());
        }
        catch (IllegalArgumentException x) {
            System.out.println(String.valueOf(e.getActionCommand()) + " is not a visible variable");
            return;
        }
        VariablePropertiesDialog d = new VariablePropertiesDialog();
        d.setVariable(v);
        d.show();
    }

    void pauseBodyClock() {
        Clock clock = Current.body.getClock();
        this.restartClock = clock.running;
        if (this.restartClock) {
            Current.body.setRunning(false);
        }
    }

    void restartBodyClock() {
        Body body = Current.body;
        if (this.restartClock) {
            body.setRunning(true);
        }
    }

    void updateNameBox() {
        this.namebox.setText(Current.person.name);
    }

    void savecommand_actionPerformed(ActionEvent e) {
        this.pauseBodyClock();
        Person person = Current.person;
        person.body = Current.body;
        person.environment = Current.environment;
        person.organList = Organ.getList();
        try {
            this.filer.save(Current.person, this);
        }
        catch (Exception x) {
            x.printStackTrace();
            String s = this.filer == null ? "" : this.filer.getSelectedFile().toString();
            JOptionPane.showMessageDialog(this, "An error occured: " + x.toString(), "Error writing file " + s, 0);
        }
        this.restartBodyClock();
    }

    void opencommand_actionPerformed(ActionEvent e) {
        try {
            Person person = this.filer.open(this);
            if (person != null) {
                this.setupNewPerson(person);
            }
        }
        catch (Exception x) {
            x.printStackTrace();
            JOptionPane.showMessageDialog(this, "An error occured: " + x.toString(), "Error opening file " + (this.filer == null ? "" : this.filer.getSelectedFile().toString()), 0);
        }
    }

    public void setupNewPerson(Person person) {
        person.body.getClock().preventTimeLapse();
        person.body.getClock().stop();
        this.start.setIcon(this.picon);
        this.started = false;
        Current.body = person.body;
        Current.environment = person.environment;
        Current.person = person;
        Organ.setList(person.organList);
        person.body.receiver = this;
        Node.allNodes = new Vector();
        Variables.initialiseVariables();
        this.bodyTree.refreshNodes();
        person.body.setupControllers();
        try {
            LimitedNode.setupVisibleNodes();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.graph.clock = person.body.getClock();
        this.updateNameBox();
        this.updateSpeedSlider();
        this.replaceAllVariables();
        this.statusbar.restoreObjectRoots();
    }

    void replaceAllVariables() {
        this.graph.replaceVariables();
        int i = 0;
        while (i < this.nodeViews.size()) {
            ((OldNodeView)this.nodeViews.get(i)).replaceVariables();
            ++i;
        }
    }

    void updateSpeedSlider() {
        double s = Current.body.getClock().getSecond();
        int i = 0;
        while (i < this.timeCompressionValues.length) {
            if (s == this.timeCompressionValues[i]) {
                this.timecomp.setValue(i);
            }
            ++i;
        }
    }

    void timeCompLabel_mouseReleased(MouseEvent e) {
        Point p = e.getComponent().getLocationOnScreen();
        p.translate(e.getX(), e.getY());
        if (this.allowRatePanel) {
            RatePanel.showSmallDialog(p.x, p.y);
        }
    }

    private void validateLater() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SimplePhicFrame.this.validate();
            }
        });
    }

    protected void die(String message) {
        Current.body.brain.getFeeling();
        if (Current.body.brain.getUnconscious().disableDeath) {
            return;
        }
        DeathBox d = new DeathBox((Object)message, this.controlBar.getParent() == null);
        JDialog dialog = d.createDialog(this, String.valueOf(Current.person.name) + " died");
        dialog.show();
        if (d.getValue() instanceof String && ((String)d.getValue()).equalsIgnoreCase("Restart")) {
            this.restartbutton.doClick();
        }
    }

    public void setRewindEnabled(boolean b) {
        this.rewindbutton.setEnabled(b);
        this.rewindDialog.enableStore = b;
    }

    public boolean isRewindEnabled() {
        return this.rewindDialog.enableStore;
    }

    class MyTSL
    implements TreeSelectionListener {
        MyTSL() {
        }

        public void valueChanged(TreeSelectionEvent e) {
            Node n;
            DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)e.getPath().getLastPathComponent();
            if (!(dmtn instanceof Node)) {
                return;
            }
            SimplePhicFrame.this.selectednode = n = (Node)dmtn;
            if (SimplePhicFrame.this.showSelectedVariableEditor) {
                OldNodeView.Type[] types = OldNodeView.Type.forNode(n);
                NodeView p = null;
                if (types.length > 0) {
                    p = new NodeView(SimplePhicFrame.this.selectednode, types[0], (CreateGraphTarget)SimplePhicFrame.this.graph);
                }
                SimplePhicFrame.this.setSelectPanel(p);
            }
        }
    }

    class TimeLabel
    extends JLabel {
        public Timer timer = new Timer(1000, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TimeLabel.this.setText(Current.body.getClock().getTimeString(0));
            }
        });

        TimeLabel() {
            this.timer.start();
        }
    }

    class adddisplayAL
    implements ActionListener {
        int i;

        adddisplayAL(int j) {
            this.i = j;
        }

        public void actionPerformed(ActionEvent e) {
            SimplePhicFrame.this.showVariableInMain(SimplePhicFrame.this.selectednode, this.i);
        }
    }
}

