/*
 * Decompiled with CFR 0.152.
 */
package phic.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.CharArrayWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import phic.Current;
import phic.Resource;
import phic.gui.ModalDialog;
import phic.gui.PhicFileDialog;
import phic.gui.SimplePhicFrame;

public class SendCommentsDialog
extends ModalDialog {
    public static final String commentServer = String.valueOf(Resource.homServer) + "/cgi-bin/submit_comment.pl";
    JPanel mainpanel = new JPanel();
    JPanel lowerpanel = new JPanel();
    JButton sendbutton = new JButton();
    JButton cancelbutton = new JButton();
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanel1 = new JPanel();
    JPanel jPanel2 = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    JScrollPane jScrollPane1 = new JScrollPane();
    JTextArea comments = new JTextArea();
    JLabel jLabel1 = new JLabel();
    JPanel jPanel3 = new JPanel();
    JTextArea jTextArea2 = new JTextArea();
    BorderLayout borderLayout3 = new BorderLayout();
    JPanel jPanel4 = new JPanel();
    BorderLayout borderLayout4 = new BorderLayout();
    Border border1;
    JPanel jPanel5 = new JPanel();
    JLabel jLabel2 = new JLabel();
    JScrollPane jScrollPane2 = new JScrollPane();
    JTextArea triedtxt = new JTextArea();
    BorderLayout borderLayout5 = new BorderLayout();
    JPanel jPanel6 = new JPanel();
    JLabel jLabel3 = new JLabel();
    JScrollPane jScrollPane3 = new JScrollPane();
    JTextArea expectedtxt = new JTextArea();
    BorderLayout borderLayout6 = new BorderLayout();
    JPanel jPanel7 = new JPanel();
    JLabel jLabel4 = new JLabel();
    JScrollPane jScrollPane4 = new JScrollPane();
    JTextArea happenedtxt = new JTextArea();
    BorderLayout borderLayout7 = new BorderLayout();
    GridLayout gridLayout1 = new GridLayout();
    JSplitPane jSplitPane1 = new JSplitPane();
    String extraData = "";
    Thread t;
    JProgressBar progressbar = new JProgressBar();
    JLabel progresstxt = new JLabel();
    JPanel jPanel8 = new JPanel();
    BorderLayout borderLayout8 = new BorderLayout();
    JPanel jPanel9 = new JPanel();
    BorderLayout borderLayout9 = new BorderLayout();
    JLabel jLabel5 = new JLabel();
    JTextField fromemail = new JTextField();

    public SendCommentsDialog() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setTitle("Send problem to author");
        this.setSize(400, 400);
    }

    public SendCommentsDialog(Exception e) {
        this();
        JOptionPane.showMessageDialog(this, "The following error occured: " + e.toString() + "\n" + "You may now send this information to the author.", "Error report", 1);
        CharArrayWriter cw = new CharArrayWriter();
        e.printStackTrace(new PrintWriter(cw));
        this.extraData = new String(cw.toCharArray());
    }

    private void jbInit() throws Exception {
        this.border1 = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        this.sendbutton.setToolTipText("Sends the message to the author");
        this.sendbutton.setText("Send");
        this.sendbutton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SendCommentsDialog.this.sendbutton_actionPerformed(e);
            }
        });
        this.cancelbutton.setText("Cancel");
        this.cancelbutton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SendCommentsDialog.this.cancelbutton_actionPerformed(e);
            }
        });
        this.mainpanel.setLayout(this.borderLayout1);
        this.jPanel2.setLayout(this.borderLayout2);
        this.comments.setToolTipText("Insert your additional comments here");
        this.comments.setText("");
        this.jLabel1.setText("Comments:");
        this.jTextArea2.setBackground(Color.white);
        this.jTextArea2.setEnabled(true);
        this.jTextArea2.setFont(new Font("Dialog", 0, 12));
        this.jTextArea2.setOpaque(false);
        this.jTextArea2.setEditable(false);
        this.jTextArea2.setText("This program will attempt to send an e-mail message to the author, detailing the current state of the simulation, and what you think the problem is. Information about your Java version will also be sent.");
        this.jTextArea2.setLineWrap(true);
        this.jTextArea2.setWrapStyleWord(true);
        this.jPanel3.setLayout(this.borderLayout3);
        this.jPanel4.setLayout(this.borderLayout4);
        this.mainpanel.setBorder(this.border1);
        this.jLabel2.setText("I tried to:");
        this.jPanel5.setLayout(this.borderLayout5);
        this.jLabel3.setText("I expected that:");
        this.expectedtxt.setToolTipText("Please enter what you feel should happen in the given situation");
        this.expectedtxt.setText("");
        this.jPanel6.setLayout(this.borderLayout6);
        this.jLabel4.setText("But in fact what happened was:");
        this.jPanel7.setLayout(this.borderLayout7);
        this.happenedtxt.setToolTipText("Please enter what you feel the erroneous values or results are.");
        this.happenedtxt.setText("");
        this.jPanel1.setLayout(this.gridLayout1);
        this.gridLayout1.setColumns(1);
        this.gridLayout1.setRows(3);
        this.jSplitPane1.setOrientation(1);
        this.jSplitPane1.setResizeWeight(0.5);
        this.jPanel3.setBorder(BorderFactory.createLoweredBevelBorder());
        this.progresstxt.setText("");
        this.lowerpanel.setLayout(this.borderLayout8);
        this.triedtxt.setToolTipText("Please enter exactly what values you changed and what buttons you pressed.");
        this.jPanel9.setLayout(this.borderLayout9);
        this.jLabel5.setText("Optional: your email address");
        this.fromemail.setToolTipText("If you specify your email address, the author could contact you to inform you of implementations of your suggestion");
        this.fromemail.setText("");
        this.getContentPane().add((Component)this.mainpanel, "Center");
        this.getContentPane().add((Component)this.lowerpanel, "South");
        this.lowerpanel.add((Component)this.jPanel8, "Center");
        this.jPanel8.add((Component)this.cancelbutton, null);
        this.jPanel8.add((Component)this.sendbutton, null);
        this.lowerpanel.add((Component)this.progresstxt, "North");
        this.lowerpanel.add((Component)this.progressbar, "West");
        this.jPanel7.add((Component)this.jScrollPane4, "Center");
        this.jPanel7.add((Component)this.jLabel4, "North");
        this.jPanel1.add((Component)this.jPanel5, null);
        this.jPanel1.add((Component)this.jPanel6, null);
        this.jScrollPane4.getViewport().add((Component)this.happenedtxt, null);
        this.jPanel1.add((Component)this.jPanel7, null);
        this.jPanel6.add((Component)this.jScrollPane3, "Center");
        this.jPanel6.add((Component)this.jLabel3, "North");
        this.jScrollPane3.getViewport().add((Component)this.expectedtxt, null);
        this.jPanel5.add((Component)this.jScrollPane2, "Center");
        this.jPanel5.add((Component)this.jLabel2, "North");
        this.jSplitPane1.add((Component)this.jPanel4, "bottom");
        this.jScrollPane2.getViewport().add((Component)this.triedtxt, null);
        this.jPanel2.add((Component)this.jScrollPane1, "Center");
        this.jPanel2.add((Component)this.jLabel1, "North");
        this.jPanel4.add((Component)this.jPanel9, "South");
        this.jPanel9.add((Component)this.jLabel5, "North");
        this.jPanel9.add((Component)this.fromemail, "Center");
        this.jPanel4.add((Component)this.jPanel3, "North");
        this.jPanel3.add((Component)this.jTextArea2, "Center");
        this.jScrollPane1.getViewport().add((Component)this.comments, null);
        this.jPanel4.add((Component)this.jPanel2, "Center");
        this.mainpanel.add((Component)this.jSplitPane1, "Center");
        this.jSplitPane1.add((Component)this.jPanel1, "top");
        this.progressbar.setVisible(false);
    }

    void sendbutton_actionPerformed(ActionEvent e) {
        this.t = new Thread(new Runnable(){

            public void run() {
                SendCommentsDialog.this.doSend();
            }
        });
        this.t.start();
    }

    public void doSend() {
        this.progress(10, "Collecting state data");
        CharArrayWriter w = new CharArrayWriter();
        PrintWriter ps = new PrintWriter(w);
        PhicFileDialog.writeVariablesToScript(ps, Current.person);
        String log = "";
        if (this.getParentFrame() instanceof SimplePhicFrame) {
            log = ((SimplePhicFrame)this.getParentFrame()).statusbar.getText();
        }
        StringBuffer sb = new StringBuffer();
        sb.append("<EMAIL>\n\t" + this.fromemail.getText() + "\n</EMAIL>\n");
        sb.append("<TRIED>\n\t" + this.triedtxt.getText() + "\n</TRIED>\n");
        sb.append("<EXPECTED>\n\t" + this.expectedtxt.getText() + "\n</EXPECTED>\n");
        sb.append("<HAPPENED>\n\t" + this.happenedtxt.getText() + "\n</HAPPENED>\n");
        sb.append("<COMMENTS>\n\t" + this.comments.getText() + "\n</COMMENTS>\n");
        sb.append("<SCRIPT>\n\t" + new String(w.toCharArray()) + "\n</SCRIPT>\n");
        sb.append("<LOG>\n\t" + log + "\n</LOG>\n");
        if (this.extraData != null && this.extraData.length() > 0) {
            sb.append("<EXTRA>\n\t" + this.extraData + "\n</EXTRA>\n");
        }
        sb.append("<CONTEXT>\n\t<HOM_VERSION> " + String.valueOf(Resource.loader.getHOMVersion()) + "</HOM_VERSION>\n");
        try {
            String versionfile = Resource.loader.readWholeStreamToString(Resource.loader.getResource(Resource.versionFile));
            sb.append("<VERSION>\n\t" + versionfile + "\n</VERSION>\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.putprops(sb, "java.version");
        this.putprops(sb, "java.vm.name");
        this.putprops(sb, "java.vm.version");
        this.putprops(sb, "os.arch");
        this.putprops(sb, "os.name");
        this.putprops(sb, "os.version");
        this.putprops(sb, "user.home");
        this.putprops(sb, "user.dir");
        sb.append("</CONTEXT>\n");
        this.serverSend(sb.toString());
    }

    void putprops(StringBuffer sb, String prop) {
        String p2 = prop.replace('.', '_');
        sb.append("\t<" + p2);
        sb.append("> " + System.getProperty(prop));
        sb.append(" </" + p2 + ">\n");
    }

    public void serverSend(String message) {
        try {
            message = message.replaceAll(";", "%3b");
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            String tmp;
            this.progress(20, "Contacting HOM server");
            URLConnection u = new URL(commentServer).openConnection();
            this.progress(30, "Sending headers");
            u.setDoOutput(true);
            PrintStream ps = new PrintStream(u.getOutputStream());
            this.progress(40, "Sending data");
            ps.print("comment=" + message + "\n\n");
            this.progress(70, "Closing connection");
            ps.close();
            this.progress(80, "Awaiting server response");
            DataInputStream dis = new DataInputStream(u.getInputStream());
            String resp = "";
            BufferedReader br = new BufferedReader(new InputStreamReader(dis));
            while ((tmp = br.readLine()) != null) {
                resp = String.valueOf(resp) + tmp + "\n";
            }
            this.progress(100, "Done");
            JOptionPane.showMessageDialog(this, resp, "Response from server", 1);
            if (resp.indexOf("Thank you") >= 0) {
                this.completed();
                this.hide();
            }
        }
        catch (IOException x) {
            this.error("Cannot send comment to server: " + x.toString());
            this.progress(0, "Not sent.");
            JTextArea b = new JTextArea();
            JScrollPane a = new JScrollPane(b);
            a.setPreferredSize(new Dimension(100, 100));
            b.setText(message);
            b.selectAll();
            JOptionPane.showMessageDialog(this, new Object[]{"Please select all the text below, and email it to info@homphysiology.com", a});
        }
    }

    public void mailsend(String message, String from) {
        Socket smtpSocket = null;
        DataOutputStream os = null;
        BufferedReader is = null;
        Date dDate = new Date();
        DateFormat dFormat = DateFormat.getDateInstance(0, Locale.US);
        int port = 25;
        String hostName = "smtp.email.msn.com";
        try {
            this.progress(20, "Opening host");
            smtpSocket = new Socket(hostName, port);
            this.progress(25, "Logging into server");
            os = new DataOutputStream(smtpSocket.getOutputStream());
            is = new BufferedReader(new InputStreamReader(smtpSocket.getInputStream()));
            if (smtpSocket != null && os != null && is != null) {
                try {
                    os.writeBytes("HELO\r\n");
                    os.writeBytes("MAIL From: homphysiology@hotmail.com\r\n");
                    this.wait(is, "250", "HOM address (from) not accepted by server.");
                    os.writeBytes("RCPT To: homphysiology@hotmail.com\r\n");
                    this.wait(is, "250", "HOM address (recipient) not accepted by server.");
                    os.writeBytes("DATA\r\n");
                    this.progress(30, "Awaiting response");
                    this.wait(is, "354", "Unable to send data.");
                    this.progress(35, "Sending header");
                    os.writeBytes("X-Mailer: Via Java\r\n");
                    os.writeBytes("DATE: " + dFormat.format(dDate) + "\r\n");
                    if (from == null || from.length() < 5) {
                        from = "HOM User <homphysiology@hotmail.com>";
                    }
                    os.writeBytes("From: " + from + "\r\n");
                    os.writeBytes("To:  HOM Physiology <homphysiology@hotmail.com>\r\n");
                    os.writeBytes("Subject: Your subjectline here\r\n");
                    this.progress(50, "Sending data");
                    System.out.println(message);
                    os.writeBytes(String.valueOf(message) + "\r\n");
                    os.writeBytes("\r\n.\r\n");
                    this.progress(90, "Awaiting response");
                    this.wait(is, "250", "Message not accepted.");
                    os.writeBytes("QUIT\r\n");
                    this.progress(100, "Sent.");
                    this.completed();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.error("Cannot send email: " + e.toString());
                    this.progress(0, "Not sent.");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error("Cannot connect to server " + hostName + "\n" + e.toString());
            this.progress(0, "Not sent.");
        }
    }

    void wait(BufferedReader r, String id, String error) throws IOException {
        String z = r.readLine();
        StringBuffer sb = new StringBuffer();
        try {
            while (z != null) {
                System.out.println(z);
                this.progresstxt.setText(z);
                sb.append(String.valueOf(z) + '\n');
                if (z.indexOf(id) >= 0) {
                    return;
                }
                z = r.readLine();
            }
        }
        catch (SocketException x) {
            throw new IOException(String.valueOf(error) + " (socket reset)\n" + sb.toString());
        }
        throw new IOException(String.valueOf(error) + "\n" + sb.toString());
    }

    void completed() {
        this.sendbutton.setEnabled(false);
        this.cancelbutton.setText("Close");
    }

    public void error(String s) {
        JOptionPane.showMessageDialog(this, s, "Error sending mail", 0);
    }

    void cancelbutton_actionPerformed(ActionEvent e) {
        this.hide();
    }

    public void progress(int n, String s) {
        this.progressbar.setVisible(n > 0);
        this.progressbar.setValue(n);
        this.progresstxt.setText(s);
    }
}

