/*
 * Decompiled with CFR 0.152.
 */
package phic.gui;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.border.Border;
import phic.Current;
import phic.common.Quantity;
import phic.gui.VisibleVariable;

public class ScrollGraphPane
extends JPanel {
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanel1 = new JPanel();
    JPanel jPanel2 = new JPanel();
    Border border1;
    Border border2;
    BorderLayout borderLayout2 = new BorderLayout();
    JPanel graphpanel = new GraphPanel();
    JPanel xscalebar = new JPanel(){

        public void paint(Graphics g) {
            super.paint(g);
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setColor(Color.white);
            if (ScrollGraphPane.this.variable != null) {
                g.drawString(ScrollGraphPane.this.variable.formatValue(ScrollGraphPane.this.variable.minimum, false, false), 0, 10);
                g.drawString(ScrollGraphPane.this.variable.formatValue(ScrollGraphPane.this.variable.initial, false, false), ScrollGraphPane.this.getscreenx(ScrollGraphPane.this.variable.initial), 10);
                g.drawString(ScrollGraphPane.this.variable.formatValue(ScrollGraphPane.this.variable.maximum, false, false), this.getWidth() - 30, 10);
            }
            int i = 0;
            while (i < 10) {
                g.drawLine(i * this.getWidth() / 10, 15, i * this.getWidth() / 10, 20);
                ++i;
            }
        }
    };
    Point mouse;
    static int pixelrate = 7;
    int timermsec = 100;
    VisibleVariable variable = null;
    Timer timer = new Timer(this.timermsec, new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            if (Current.body.getClock().running && ScrollGraphPane.this.variable != null) {
                double val = ScrollGraphPane.this.variable.node.doubleGetVal();
                ScrollGraphPane.this.plot(val);
                ScrollGraphPane.this.valuetext.setText(ScrollGraphPane.this.variable.formatValue(val, true, true));
            }
        }
    });
    Border border3;
    JTextField valuetext = new JTextField();
    static int colourindex = 0;
    static final Color[] colourset = new Color[]{Color.red, Color.yellow, Color.cyan, Color.orange, Color.green, Color.pink};
    final Color colour = colourset[colourindex++ % colourset.length];
    BorderLayout borderLayout3 = new BorderLayout();
    Border border4;

    public ScrollGraphPane() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.timer.start();
        this.valuetext.setCursor(new Cursor(8));
        this.valuetext.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                ScrollGraphPane.this.mouse = e.getPoint();
            }
        });
        this.valuetext.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent e) {
                int d = e.getY() - ScrollGraphPane.this.mouse.y;
                double val = ScrollGraphPane.this.variable.node.doubleGetVal();
                double du = Quantity.getNearestRoundBelow(val);
                if (d != 0) {
                    ScrollGraphPane.this.variable.node.doubleSetVal(val + du * (double)d);
                }
            }
        });
    }

    public void setVariable(VisibleVariable n) {
        this.variable = n;
    }

    public void plot(double d) {
        ((GraphPanel)this.graphpanel).plot(this.getscreenx(d));
    }

    int getscreenx(double d) {
        if (this.variable != null) {
            return (int)((d - this.variable.minimum) * (double)this.graphpanel.getWidth() / (this.variable.maximum - this.variable.minimum));
        }
        return 0;
    }

    private void jbInit() throws Exception {
        this.border1 = BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1, Color.white, Color.white, new Color(134, 134, 134), new Color(93, 93, 93)), BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.border2 = BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(Color.white, new Color(134, 134, 134)), BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.border3 = BorderFactory.createBevelBorder(1, Color.white, Color.white, new Color(134, 134, 134), new Color(93, 93, 93));
        this.border4 = BorderFactory.createEmptyBorder(2, 2, 2, 2);
        this.setLayout(this.borderLayout1);
        this.jPanel2.setLayout(this.borderLayout2);
        this.setBorder(this.border2);
        this.setPreferredSize(new Dimension(136, 160));
        this.graphpanel.setBackground(Color.black);
        this.graphpanel.setForeground(Color.red);
        this.xscalebar.setBackground(Color.black);
        this.xscalebar.setForeground(Color.lightGray);
        this.xscalebar.setPreferredSize(new Dimension(10, 20));
        this.valuetext.setBackground(Color.black);
        this.valuetext.setFont(new Font("SansSerif", 1, 12));
        this.valuetext.setForeground(this.colour);
        this.valuetext.setPreferredSize(new Dimension(110, 21));
        this.valuetext.setCaretColor(Color.orange);
        this.valuetext.setDisabledTextColor(Color.red);
        this.valuetext.setEditable(false);
        this.valuetext.setText("0.0");
        this.valuetext.setHorizontalAlignment(0);
        this.jPanel1.setBorder(this.border4);
        this.jPanel1.setPreferredSize(new Dimension(130, 23));
        this.jPanel1.setLayout(this.borderLayout3);
        this.add((Component)this.jPanel1, "North");
        this.jPanel1.add((Component)this.valuetext, "Center");
        this.add((Component)this.jPanel2, "Center");
        this.jPanel2.add((Component)this.xscalebar, "North");
        this.jPanel2.add((Component)this.graphpanel, "Center");
    }

    class GraphPanel
    extends JPanel {
        BufferedImage[] image = new BufferedImage[2];
        int pos = 0;
        int bank = 0;
        int prevp;
        long minorinterval = (long)(Current.body.getClock().getSecond() * 60.0);
        long majorinterval = this.minorinterval * 60L;
        long lastminmod;
        long lastmajmod;

        public GraphPanel() {
            this.addComponentListener(new ComponentAdapter(){

                public void componentResized(ComponentEvent e) {
                    int i = 0;
                    while (i < 2) {
                        GraphPanel.this.image[i] = new BufferedImage(GraphPanel.this.getWidth(), GraphPanel.this.getHeight(), 13);
                        GraphPanel.this.image[i].getGraphics().clearRect(0, 0, GraphPanel.this.getWidth(), GraphPanel.this.getHeight());
                        ++i;
                    }
                }
            });
        }

        public void paint(Graphics g_) {
            super.paint(g_);
            Graphics2D g = (Graphics2D)g_;
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (this.image[0] != null) {
                g.drawImage((Image)this.image[(this.bank + 1) % 2], 0, -this.pos, null);
                g.drawImage((Image)this.image[this.bank], 0, this.image[this.bank].getHeight() - this.pos, null);
            }
        }

        public void plot(int x) {
            long t;
            if (this.image[0] == null) {
                return;
            }
            this.pos += pixelrate;
            if (this.pos >= this.image[0].getHeight()) {
                this.pos = 0;
                this.bank = (this.bank + 1) % 2;
                this.image[this.bank].getGraphics().clearRect(0, 0, this.image[this.bank].getWidth(), this.image[this.bank].getHeight());
            }
            Graphics2D g = (Graphics2D)this.image[this.bank].getGraphics();
            int op = this.pos - pixelrate;
            if (op < 0) {
                op = 0;
            }
            g.setColor(Color.gray);
            if (ScrollGraphPane.this.variable != null) {
                int z = ScrollGraphPane.this.getscreenx(ScrollGraphPane.this.variable.initial);
                g.drawLine(z, op, z, this.pos);
            }
            if ((t = Current.body.getClock().getTime()) % this.minorinterval - this.lastminmod < 0L) {
                g.drawLine(0, this.pos, 6, this.pos);
                int pp = this.pos - 10 < 0 ? 0 : this.pos - 10;
                if (t % this.majorinterval - this.lastmajmod < 0L) {
                    g.setStroke(new BasicStroke(1.0f, 2, 2, 0.1f, new float[]{2.0f, 1.0f}, 0.0f));
                    g.drawLine(0, this.pos, this.getWidth(), this.pos);
                    String ts = Current.body.getClock().getTimeString(2);
                    g.drawString(ts, 0, pp);
                } else {
                    int i = 0;
                    while (i < 10) {
                        g.drawLine(i * this.getWidth() / 10, this.pos, i * this.getWidth() / 10, this.pos);
                        ++i;
                    }
                }
            }
            this.lastminmod = t % this.minorinterval;
            this.lastmajmod = t % this.minorinterval;
            g.setColor(ScrollGraphPane.this.colour);
            this.prevp = x;
            g.drawLine(this.prevp, op, this.prevp, this.pos);
            this.repaint();
        }
    }
}

