/*
 * Decompiled with CFR 0.152.
 */
package phic.gui;

import evaluator.ParseException;
import evaluator.Variable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Date;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import phic.Resource;
import phic.common.IniReader;
import phic.gui.HTMLMessagePane;
import phic.gui.ModalDialog;
import phic.modifiable.Script;
import phic.modifiable.ScriptViewPanel;

public class ScriptEditor
extends ModalDialog
implements ListSelectionListener {
    public static final String defaultScriptResource = "scripts/PhicScripts.txt";
    public static final String defaultScriptResourceFolder = "scripts";
    JPanel jPanel1 = new JPanel();
    JPanel jPanel2 = new JPanel();
    JButton closebutton = new JButton();
    JButton jButton1 = new JButton();
    BorderLayout borderLayout1 = new BorderLayout();
    JScrollPane jScrollPane1 = new JScrollPane();
    JList scriptlist = new JList();
    JPanel jPanel3 = new JPanel();
    DefaultListModel scriptlistmodel = new DefaultListModel();
    BorderLayout borderLayout2 = new BorderLayout();
    JButton newbutton = new JButton();
    ScriptViewPanel scriptViewPanel1 = new ScriptViewPanel();
    private Vector scripts = new Vector();
    private JButton jButton2 = new JButton();
    JMenuBar jMenuBar1 = new JMenuBar();
    JMenu jMenu1 = new JMenu();
    JMenuItem jMenuItem1 = new JMenuItem();
    JMenuItem jMenuItem2 = new JMenuItem();
    JMenuItem jMenuItem3 = new JMenuItem();
    JMenuItem jMenuItem4 = new JMenuItem();
    JMenu jMenu2 = new JMenu();
    JMenuItem jMenuItem5 = new JMenuItem();
    JMenu jMenu3 = new JMenu();
    JMenuItem scripthelp = new JMenuItem();
    JMenuItem jMenuItem7 = new JMenuItem();
    protected Action newScript = new AbstractAction("New Script"){

        public void actionPerformed(ActionEvent e) {
            Script s = new Script();
            ScriptEditor.this.scripts.add(s);
            ScriptEditor.this.updateList();
            ScriptEditor.this.scriptlist.setSelectedValue(s, true);
        }
    };
    protected Action runScriptOnce = new AbstractAction("Run Script Once"){

        public void actionPerformed(ActionEvent e) {
            try {
                Variable.set("elapsedTime", new Double(1.0));
                ((Script)ScriptEditor.this.scriptlist.getSelectedValue()).executeOnce();
            }
            catch (Exception x) {
                JOptionPane.showMessageDialog(ScriptEditor.this, "Error during script execution: " + x.toString(), "Script error", 0);
                x.printStackTrace();
            }
        }
    };
    protected Action close = new AbstractAction("Close"){

        public void actionPerformed(ActionEvent e) {
            ScriptEditor.this.hide();
        }
    };
    protected Action deleteScript = new AbstractAction("Delete Script"){

        public void actionPerformed(ActionEvent e) {
            Object[] o = ScriptEditor.this.scriptlist.getSelectedValues();
            int i = 0;
            while (i < o.length) {
                ScriptEditor.this.scripts.remove(o[i]);
                ((Script)o[i]).setContinuous(false);
                ++i;
            }
            ScriptEditor.this.updateList();
        }
    };
    protected Action scriptHelpAction = new AbstractAction("Script help"){

        public void actionPerformed(ActionEvent e) {
            HTMLMessagePane.showDialog("help/Scripting.html", "Script help");
        }
    };
    protected Action saveScripts = new AbstractAction("Save Scripts"){

        public void actionPerformed(ActionEvent e) {
            JFileChooser fc = new JFileChooser(Resource.loader.getResourceURL(ScriptEditor.defaultScriptResourceFolder).getFile());
            int state = fc.showSaveDialog(ScriptEditor.this);
            if (state == 0) {
                try {
                    File f = fc.getSelectedFile();
                    PrintStream w = new PrintStream(new FileOutputStream(f), true);
                    w.println("// Script file " + f.getAbsolutePath());
                    w.println("// Last saved " + new Date());
                    int i = 0;
                    while (i < ScriptEditor.this.scripts.size()) {
                        Script script = (Script)ScriptEditor.this.scripts.get(i);
                        w.println(String.valueOf('[') + script.name + ']');
                        w.println("Description=" + script.description);
                        w.println("Body=" + script.getText());
                        w.println("Continuous=" + script.isContinuous());
                        w.println("ExecutionInterval=" + script.getExecutionInterval());
                        w.println();
                        ++i;
                    }
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(ScriptEditor.this, "Error writing file: " + e.toString(), "Could not save scripts", 0);
                    ex.printStackTrace();
                }
            }
            ScriptEditor.this.updateList();
        }
    };
    protected Action openScripts = new AbstractAction("Open Scripts"){

        public void actionPerformed(ActionEvent e) {
            JFileChooser fc = new JFileChooser(Resource.loader.getResourceURL(ScriptEditor.defaultScriptResourceFolder).getFile());
            int state = fc.showOpenDialog(ScriptEditor.this);
            if (state == 0) {
                try {
                    ScriptEditor.this.readScriptsFromStream(new FileInputStream(fc.getSelectedFile()));
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(ScriptEditor.this, "Error reading file '" + fc.getSelectedFile().getAbsolutePath() + "': " + ex.getMessage());
                    ex.printStackTrace();
                }
            }
            ScriptEditor.this.updateList();
        }
    };

    public Vector getScripts() {
        return this.scripts;
    }

    public ScriptEditor() {
        this.init();
    }

    public ScriptEditor(Vector scripts) {
        this.scripts = scripts;
        this.init();
        this.updateList();
    }

    private void init() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setSize(400, 400);
        if (this.scripts.size() == 0) {
            try {
                this.readScriptsFromStream(Resource.loader.getResource(defaultScriptResource));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void jbInit() throws Exception {
        this.closebutton.setText("Close");
        this.closebutton.addActionListener(this.close);
        this.jButton1.setText("Run script once");
        this.jButton1.addActionListener(this.runScriptOnce);
        this.jPanel1.setLayout(this.borderLayout1);
        this.jScrollPane1.setPreferredSize(new Dimension(150, 131));
        this.scriptlist.setModel(this.scriptlistmodel);
        this.scriptlist.addListSelectionListener(this);
        this.jPanel3.setLayout(this.borderLayout2);
        this.newbutton.setText("New script");
        this.newbutton.addActionListener(this.newScript);
        this.scriptViewPanel1.nametxt.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                ScriptEditor.this.updateList();
            }
        });
        this.jButton2.setText("Delete script");
        this.jButton2.addActionListener(this.deleteScript);
        this.jMenu1.setText("File");
        this.jMenuItem1.addActionListener(this.newScript);
        this.jMenuItem1.setText("New Script");
        this.jMenuItem2.addActionListener(this.saveScripts);
        this.jMenuItem2.setText("Save Scripts");
        this.jMenuItem3.addActionListener(this.openScripts);
        this.jMenuItem3.setText("Open Scripts");
        this.jMenuItem4.setAction(this.close);
        this.jMenuItem4.setText("Close Script Editor");
        this.jMenu2.setText("Edit");
        this.jMenuItem5.addActionListener(this.deleteScript);
        this.jMenuItem5.setText("Delete Selected Script");
        this.jMenu3.setText("Help");
        this.scripthelp.setText("Script Language Help");
        this.scripthelp.addActionListener(this.scriptHelpAction);
        this.jMenuItem7.setText("Delete All Scripts");
        this.setJMenuBar(this.jMenuBar1);
        this.setTitle("Script Editor");
        this.jPanel2.add((Component)this.newbutton, null);
        this.jPanel2.add((Component)this.jButton2, null);
        this.jPanel2.add((Component)this.jButton1, null);
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.getContentPane().add((Component)this.jPanel2, "South");
        this.jPanel2.add((Component)this.closebutton, null);
        this.jPanel1.add((Component)this.jScrollPane1, "West");
        this.jPanel1.add((Component)this.jPanel3, "Center");
        this.jPanel3.add((Component)this.scriptViewPanel1, "Center");
        this.jScrollPane1.getViewport().add((Component)this.scriptlist, null);
        this.jMenuBar1.add(this.jMenu1);
        this.jMenuBar1.add(this.jMenu2);
        this.jMenuBar1.add(this.jMenu3);
        this.jMenu1.add(this.jMenuItem1);
        this.jMenu1.add(this.jMenuItem2);
        this.jMenu1.add(this.jMenuItem3);
        this.jMenu1.addSeparator();
        this.jMenu1.add(this.jMenuItem4);
        this.jMenu2.add(this.jMenuItem5);
        this.jMenu2.add(this.jMenuItem7);
        this.jMenu3.add(this.scripthelp);
    }

    protected void updateList() {
        Object sel = this.scriptlist.getSelectedValue();
        this.scriptlistmodel.removeAllElements();
        int i = 0;
        while (i < this.scripts.size()) {
            this.scriptlistmodel.addElement(this.scripts.get(i));
            ++i;
        }
        this.scriptlist.setSelectedValue(sel, true);
    }

    public void valueChanged(ListSelectionEvent e) {
        this.scriptViewPanel1.setScript((Script)this.scriptlist.getSelectedValue());
    }

    public void readScriptsFromStream(InputStream fc) throws IOException {
        IniReader ir = new IniReader(fc);
        String[] names = ir.getSectionHeaders();
        int i = 0;
        while (i < names.length) {
            Map m = ir.getSectionMap(names[i]);
            Script script = new Script();
            script.name = names[i];
            script.description = m.get("Description").toString();
            script.setContinuous(Boolean.valueOf(m.get("Continuous").toString()));
            script.setExecutionInterval((Double)m.get("ExecutionInterval"));
            try {
                script.setText(m.get("Body").toString());
                this.scripts.add(script);
            }
            catch (ParseException pe) {
                JOptionPane.showMessageDialog(this, "Error compiling script " + i + " '" + names[i] + "': " + pe.getMessage());
            }
            ++i;
        }
    }
}

