/*
 * Decompiled with CFR 0.152.
 */
package phic.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;
import phic.common.IniReader;
import phic.gui.ValueRangeLabel;
import phic.gui.Variables;
import phic.gui.VisibleVariable;

public class ScreensPanel
extends JPanel {
    JPanel jPanel1 = new JPanel();
    Border border1;
    BorderLayout borderLayout1 = new BorderLayout();
    Border border2;
    String filename;
    Vector sections;
    JPanel[] panels;
    JTabbedPane tabbedpane = new JTabbedPane();
    private final boolean scrollable = true;
    protected IniReader ir;

    protected ScreensPanel(String file) {
        this.filename = file;
        this.ir = new IniReader(this.filename);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ScreensPanel(String file, Vector sections) {
        this(file);
        this.sections = sections;
        this.myinit();
    }

    private void jbInit() throws Exception {
        this.border1 = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        this.border2 = BorderFactory.createBevelBorder(1);
        this.jPanel1.setLayout(this.borderLayout1);
        this.add((Component)this.jPanel1, "Center");
        this.jPanel1.add((Component)this.tabbedpane, "Center");
    }

    public String[] getSections() {
        Vector v = new Vector();
        return this.ir.getSectionHeaders();
    }

    public void setSections(Vector v) {
        this.sections = v;
        this.myinit();
    }

    protected void myinit() {
        this.setSize(new Dimension(460, 480));
        this.tabbedpane.removeAll();
        String[] head = this.ir.getSectionHeaders();
        JPanel[] panel = new JPanel[head.length];
        int i = 0;
        while (i < head.length) {
            if (this.doDisplay(head[i])) {
                JScrollPane sp = new JScrollPane();
                sp.setHorizontalScrollBarPolicy(31);
                sp.setBorder(null);
                panel[i] = new JPanel();
                panel[i].setLayout(new BoxLayout(panel[i], 1));
                sp.getViewport().setView(panel[i]);
                this.tabbedpane.add(head[i], sp);
                String[] item = this.ir.getSectionStrings(head[i]);
                int j = 0;
                while (j < item.length) {
                    String name = item[j].trim();
                    if (!name.equals("")) {
                        VisibleVariable v = Variables.forName(name);
                        panel[i].add(new ValueRangeLabel(v));
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    boolean doDisplay(String s) {
        if (this.sections == null) {
            return true;
        }
        int i = 0;
        while (i < this.sections.size()) {
            if (this.sections.get(i).equals(s)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

