/*
 * Decompiled with CFR 0.152.
 */
package phic.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.Timer;
import javax.swing.border.Border;
import phic.Current;
import phic.common.DataHistory;
import phic.gui.ModalDialog;
import phic.gui.RewindDialog_cancelbutton_actionAdapter;
import phic.gui.RewindDialog_gotobutton_actionAdapter;
import phic.gui.SimplePhicFrame;

public class RewindDialog
extends ModalDialog
implements ActionListener {
    private int saveInterval = 5000;
    public boolean enableStore = true;
    DataHistory history = new DataHistory();
    public static final int MAX_STORE_ITEMS = 60;
    Timer timer = new Timer(this.saveInterval, this);
    JPanel jPanel1 = new JPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanel2 = new JPanel();
    JPanel jPanel3 = new JPanel();
    Border border1;
    BorderLayout borderLayout2 = new BorderLayout();
    JScrollPane jScrollPane1 = new JScrollPane();
    JList restorelist = new JList();
    JButton gotobutton = new JButton();
    JButton cancelbutton = new JButton();
    DefaultListModel model = new DefaultListModel();

    public RewindDialog() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setSize(200, 200);
        this.timer.start();
        this.getRootPane().setDefaultButton(this.gotobutton);
    }

    public void show() {
        this.model.removeAllElements();
        String[] s = this.history.getTimes();
        int i = 0;
        while (i < s.length) {
            this.model.addElement(s[i]);
            ++i;
        }
        this.restorelist.setModel(this.model);
        super.show();
    }

    public void reset() {
        this.history.removeAll();
    }

    public void actionPerformed(ActionEvent e) {
        if (Current.body.getClock().running && this.enableStore) {
            this.history.storeSnapshot(Current.person);
        }
        if (this.history.getDataSize() > 60) {
            this.history.removeEarliestSnapshot();
        }
    }

    private void jbInit() throws Exception {
        this.border1 = BorderFactory.createEmptyBorder(4, 4, 4, 4);
        this.jPanel1.setLayout(this.borderLayout1);
        this.jPanel3.setBorder(this.border1);
        this.jPanel3.setLayout(this.borderLayout2);
        this.gotobutton.setText("Go to");
        this.gotobutton.addActionListener(new RewindDialog_gotobutton_actionAdapter(this));
        this.cancelbutton.setText("Cancel");
        this.cancelbutton.addActionListener(new RewindDialog_cancelbutton_actionAdapter(this));
        this.setResizable(true);
        this.setTitle("Rewind to time");
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.jPanel1.add((Component)this.jPanel2, "South");
        this.jPanel2.add((Component)this.gotobutton, null);
        this.jPanel2.add((Component)this.cancelbutton, null);
        this.jPanel1.add((Component)this.jPanel3, "Center");
        this.jPanel3.add((Component)this.jScrollPane1, "Center");
        this.jScrollPane1.getViewport().add((Component)this.restorelist, null);
    }

    void gotobutton_actionPerformed(ActionEvent e) {
        int i = this.restorelist.getSelectedIndex();
        this.history.restore(i, (SimplePhicFrame)this.getParentFrame());
        this.history.removeAfter(i);
        this.hide();
    }

    void cancelbutton_actionPerformed(ActionEvent e) {
        this.hide();
    }

    public int getSaveInterval() {
        return this.saveInterval;
    }

    public void setSaveInterval(int saveInterval) {
        this.saveInterval = saveInterval;
        this.timer.setDelay(saveInterval);
    }
}

