/*
 * Decompiled with CFR 0.152.
 */
package phic.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import phic.Resource;
import phic.common.IniReader;
import phic.common.Organ;
import phic.gui.VisibleVariable;
import phic.modifiable.Range;

public class ReferenceValuesPanel
extends JPanel {
    IniReader file = new IniReader("ReferenceValues.txt");
    double currentValue;
    Image bigArrow = Resource.loader.getImageResource("LeftArrowRed3D.gif");
    Image smallArrow = Resource.loader.getImageResource("LeftArrowBlue3D.gif");
    Map map;
    VisibleVariable variable;
    public boolean foundValues = false;
    JLabel[] labels;
    double max;
    double min;
    int sx = 70;

    public ReferenceValuesPanel(VisibleVariable vv) {
        this.setVariable(vv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVariable(VisibleVariable vv) {
        this.readVariable(vv);
        this.createLabels();
        this.repaint();
        Organ.DataLock dataLock = Organ.cycleLock;
        synchronized (dataLock) {
            this.currentValue = this.variable.node.doubleGetVal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void readVariable(VisibleVariable vv) {
        this.variable = vv;
        this.max = Double.MIN_VALUE;
        this.min = Double.MAX_VALUE;
        try {
            try {
                this.map = this.file.getSectionMap(this.variable.longName);
            }
            catch (IllegalArgumentException e) {
                this.map = this.file.getSectionMap(this.variable.canonicalName);
            }
            Iterator i = this.map.values().iterator();
            while (i.hasNext()) {
                double d = (Double)i.next();
                this.extendRangeTo(d);
            }
            this.foundValues = true;
        }
        catch (Exception e) {
            System.out.println("Cannot find reference values for variable '" + vv.canonicalName + "' in 'resources/ReferenceValues.txt'");
            if (!(e instanceof IllegalArgumentException)) {
                e.printStackTrace();
            }
            this.map = new HashMap();
            this.foundValues = false;
        }
        this.extendRangeTo(this.variable.minimum);
        this.extendRangeTo(this.variable.maximum);
        Organ.DataLock dataLock = Organ.cycleLock;
        synchronized (dataLock) {
            this.extendRangeTo(this.variable.node.doubleGetVal());
        }
        this.min = Range.findRange((double)this.min, (int)0).minimum;
        this.max = Range.findRange((double)this.max, (int)0).maximum;
        if (this.max / this.min > 20.0) {
            this.min = 0.0;
        }
    }

    public void doLayout() {
        super.doLayout();
        this.createLabels();
    }

    void createLabels() {
        this.removeAll();
        this.setLayout(null);
        this.labels = new JLabel[this.map.size()];
        Vector<JLabel> bottoms = new Vector<JLabel>();
        for (Object name : this.map.keySet()) {
            try {
                double val = (Double)this.map.get(name);
                int pos = this.getPos(val);
                String paintString = String.valueOf(this.variable.formatValue(val, true, true)) + ": " + name.toString();
                JLabel label = new JLabel(paintString);
                this.add(label);
                Dimension s = label.getPreferredSize();
                if (pos > this.getHeight() - 50) {
                    bottoms.add(label);
                    while (pos > this.getHeight() - 20) {
                        pos -= 5;
                        int j = 0;
                        while (j < bottoms.size()) {
                            JLabel l = (JLabel)bottoms.get(j);
                            l.setLocation(l.getX(), l.getY() - 5);
                            ++j;
                        }
                    }
                }
                System.out.println(String.valueOf(paintString) + " - " + pos + " px / " + this.getHeight());
                Rectangle r = new Rectangle(this.sx + 47, pos + 5, s.width, s.height);
                double bx = r.getMaxY() - (double)this.getHeight();
                if (bx > 0.0) {
                    r.setLocation(r.x, r.y + (int)(bx + 1.0));
                }
                label.setBounds(r);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    final void extendRangeTo(double value) {
        if (value < this.min) {
            this.min = value;
        }
        if (value > this.max) {
            this.max = value;
        }
    }

    int getPos(double value) {
        return (int)((double)this.getHeight() * (this.max - value) / (this.max - this.min));
    }

    public void paint(Graphics g) {
        super.paint(g);
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.drawLine(this.sx, 0, this.sx, this.getHeight());
        int nTicks = 5;
        int i = 0;
        while (i <= nTicks) {
            int h = (nTicks - i) * this.getHeight() / nTicks;
            if (h == this.getHeight()) {
                --h;
            }
            g.drawLine(this.sx, h, this.sx + 10, h);
            if (h < 10) {
                h += 5;
            }
            if (h > this.getHeight() - 10) {
                h -= 10;
            }
            g.drawString(this.variable.formatValue(this.min + (double)i * (this.max - this.min) / (double)nTicks, true, true), 3, h + 5);
            ++i;
        }
        int n = 0;
        for (Object name : this.map.keySet()) {
            ++n;
            try {
                double val = (Double)this.map.get(name);
                int pos = this.getPos(val);
                g.drawImage(this.smallArrow, this.sx + 15, pos - this.smallArrow.getHeight(this) / 2, this);
                String paintString = String.valueOf(this.variable.formatValue(val, true, true)) + ": " + name.toString();
                g.drawLine(this.sx + 20, pos, this.labels[n].getX(), (int)this.labels[n].getBounds().getCenterY());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        g.drawImage(this.bigArrow, this.sx + 15, this.getPos(this.currentValue) - this.bigArrow.getHeight(this) / 2, this);
        g.setColor(Color.cyan);
        int top = this.getPos(this.variable.maximum);
        g.fill3DRect(this.sx + 10, top, 5, this.getPos(this.variable.minimum) - top, true);
        super.paintChildren(g);
    }
}

