/*
 * Decompiled with CFR 0.152.
 */
package phic.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.Timer;
import javax.swing.border.BevelBorder;
import phic.Current;
import phic.common.Clock;
import phic.gui.PhicApplication;

public class RatePanel
extends JPanel {
    static final String[] timeunit = new String[]{"second", "minute", "hour", "day", "week"};
    static final long[] millis = new long[]{1000L, 60000L, 3600000L, 86400000L, 604800000L};
    private DefaultComboBoxModel model1 = new DefaultComboBoxModel<String>(timeunit);
    private DefaultComboBoxModel model2 = new DefaultComboBoxModel<String>(timeunit);
    NumberFormat nf = new DecimalFormat("0.00E0");
    Timer timer = new Timer(750, new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            double et = Clock.getAverageElapsedTime();
            RatePanel.this.fpslabel.setText(RatePanel.this.nf.format(et));
            RatePanel.this.correctionTxt.setText(String.valueOf((int)(100.0 * (Clock.getExactElapsedTime() - et)) / 100));
        }
    });
    private JPanel jPanel1 = new JPanel();
    private JLabel jLabel4 = new JLabel();
    private JLabel jLabel2 = new JLabel();
    private JComboBox drop1 = new JComboBox();
    private JLabel jLabel1 = new JLabel();
    private JLabel fpslabel = new JLabel();
    private JLabel jLabel5 = new JLabel();
    private JComboBox drop2 = new JComboBox();
    private JPanel jPanel2 = new JPanel();
    private BorderLayout borderLayout1 = new BorderLayout();
    private JPanel jPanel3 = new JPanel();
    private JLabel jLabel3 = new JLabel();
    private JLabel correctionTxt = new JLabel();
    private JLabel jLabel7 = new JLabel();
    JButton ok = new JButton();
    JPanel eastpanel = new JPanel();
    JWindow pp;
    JButton single = new JButton();
    JPanel jPanel4 = new JPanel();
    JPanel jPanel5 = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    JCheckBox jCheckBox1 = new JCheckBox();
    JPanel jPanel6 = new JPanel();
    BorderLayout borderLayout3 = new BorderLayout();
    JPanel jPanel7 = new JPanel();
    BorderLayout borderLayout4 = new BorderLayout();
    JLabel jLabel6 = new JLabel();
    Action freezeFramerateAction = new AbstractAction("Freeze framerate"){

        public void actionPerformed(ActionEvent e) {
            Current.thread.fixedFrameDurationMillis = 10.0;
            Current.thread.fixedFrameDuration = RatePanel.this.jCheckBox1.isSelected();
        }
    };

    public RatePanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.init();
        this.timer.start();
    }

    private void jbInit() throws Exception {
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RatePanel.this.pp.hide();
            }
        });
        this.ok.setText("OK");
        this.jLabel4.setText("  s/f");
        this.jLabel2.setText("1");
        this.drop1.setModel(this.model1);
        this.drop1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RatePanel.this.change(e);
            }
        });
        this.jLabel1.setText("per");
        this.fpslabel.setText("0");
        this.jLabel5.setText("Body timeslice:");
        this.drop2.setModel(this.model2);
        this.drop2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RatePanel.this.change(e);
            }
        });
        this.single.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Clock c = Current.body.getClock();
                double sc = millis[RatePanel.this.drop1.getSelectedIndex()];
                c.elapseTime(sc / 1000.0);
                Current.thread.tickOnce();
            }
        });
        this.setLayout(this.borderLayout1);
        this.jLabel3.setText("Bunching correction");
        this.correctionTxt.setText("0");
        this.jLabel7.setText("s");
        this.single.setToolTipText("Execute a single time step of the size selected in dropdown 1");
        this.single.setText("Step");
        this.jPanel2.setLayout(this.borderLayout2);
        this.jCheckBox1.setToolTipText("This makes every frame of computation last a fixed duration of 10 ms");
        this.jCheckBox1.setText("Freeze @100Hz!");
        this.jCheckBox1.addActionListener(this.freezeFramerateAction);
        this.jPanel6.setLayout(this.borderLayout3);
        this.jPanel7.setLayout(this.borderLayout4);
        this.jLabel6.setBackground(SystemColor.activeCaption);
        this.jLabel6.setForeground(SystemColor.activeCaptionText);
        this.jLabel6.setBorder(null);
        this.jLabel6.setOpaque(true);
        this.jLabel6.setToolTipText("These options are for accurate control of the engine's timing parameters, for debugging purposes");
        this.jLabel6.setText("Advanced timing settings");
        this.add((Component)this.jPanel1, "Center");
        this.jPanel1.add((Component)this.jLabel2, null);
        this.jPanel1.add((Component)this.drop1, null);
        this.jPanel1.add((Component)this.jLabel1, null);
        this.jPanel1.add((Component)this.drop2, null);
        this.add((Component)this.jPanel2, "South");
        this.jPanel2.add((Component)this.jPanel5, "East");
        this.jPanel5.add((Component)this.jCheckBox1, null);
        this.jPanel2.add((Component)this.jPanel4, "Center");
        this.jPanel4.add((Component)this.jLabel5, null);
        this.jPanel4.add((Component)this.fpslabel, null);
        this.jPanel4.add((Component)this.jLabel4, null);
        this.jPanel3.add((Component)this.jLabel3, null);
        this.jPanel3.add((Component)this.correctionTxt, null);
        this.jPanel3.add((Component)this.jLabel7, null);
        this.jPanel6.add((Component)this.jPanel7, "North");
        this.jPanel7.add((Component)this.jLabel6, "Center");
        this.add((Component)this.eastpanel, "East");
        this.eastpanel.setLayout(new BorderLayout());
        this.eastpanel.add(this.ok);
        this.eastpanel.add((Component)this.single, "North");
        this.add((Component)this.jPanel6, "North");
        this.jPanel6.add((Component)this.jPanel3, "Center");
    }

    double setFromSecond(double second) {
        double minDist = Double.MAX_VALUE;
        int a = -1;
        int b = -1;
        double compression = 1000.0 / second;
        int i = 0;
        while (i < millis.length) {
            int j = 0;
            while (j < millis.length) {
                double comp2 = (double)millis[i] / (double)millis[j];
                double dist = Math.abs(comp2 - compression);
                if (dist < minDist) {
                    minDist = dist;
                    a = i;
                    b = j;
                }
                ++j;
            }
            ++i;
        }
        this.drop1.setSelectedIndex(a);
        this.drop2.setSelectedIndex(b);
        return 1000.0 / ((double)millis[a] / (double)millis[b]);
    }

    public void finalize() throws Throwable {
        this.timer.stop();
        super.finalize();
    }

    static String setClockToClosest(double second) {
        double minDist = Double.MAX_VALUE;
        int a = -1;
        int b = -1;
        double compression = 1000.0 / second;
        int i = 0;
        while (i < millis.length) {
            int j = 0;
            while (j < millis.length) {
                double comp2 = (double)millis[i] / (double)millis[j];
                double dist = Math.abs(comp2 - compression);
                if (dist < minDist) {
                    minDist = dist;
                    a = i;
                    b = j;
                }
                ++j;
            }
            ++i;
        }
        double newSecond = 1000.0 / ((double)millis[a] / (double)millis[b]);
        Current.body.getClock().setSecond(newSecond);
        return "1 " + timeunit[a] + " per " + timeunit[b];
    }

    public static void showSmallDialog(int x, int y) {
        RatePanel r = new RatePanel();
        r.setPanelLocation(x, y);
    }

    public void setPanelLocation(int x, int y) {
        this.pp.setLocation(x, y);
    }

    public void init() {
        this.pp = new JWindow(PhicApplication.frame.getJFrame());
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.setBorder(new BevelBorder(0));
        this.pp.getContentPane().add(panel);
        this.setFromSecond(Current.body.getClock().getSecond());
        this.jCheckBox1.setSelected(Current.thread.fixedFrameDuration);
        panel.add((Component)this, "Center");
        panel.add((Component)this.ok, "East");
        this.pp.setSize(320, 120);
        panel.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                RatePanel.this.pp.hide();
                RatePanel.this.pp.dispose();
            }
        });
        this.pp.show();
        this.pp.requestFocus();
    }

    void change(ActionEvent e) {
        double compression = (double)millis[this.drop1.getSelectedIndex()] / (double)millis[this.drop2.getSelectedIndex()];
        double second = 1000.0 / compression;
        Current.body.getClock().setSecond(second);
    }
}

