/*
 * Decompiled with CFR 0.152.
 */
package phic.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import phic.gui.ModalDialog;
import phic.gui.OldNodeView;
import phic.gui.QuickAdd_jButton1_actionAdapter;
import phic.gui.QuickAdd_jButton2_actionAdapter;
import phic.gui.Variables;
import phic.gui.VisibleVariable;

public class QuickAdd
extends ModalDialog {
    JPanel jPanel1 = new JPanel();
    JPanel jPanel2 = new JPanel();
    JButton jButton1 = new JButton();
    JButton jButton2 = new JButton();
    JComboBox varname = new JComboBox();
    JComboBox displaytype = new JComboBox();
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanel3 = new JPanel();
    JTextField namefield;
    Object lastSelection = null;
    Object previousSelection = null;
    DefaultComboBoxModel varmodel = new DefaultComboBoxModel();
    DefaultComboBoxModel typemodel = new DefaultComboBoxModel();
    VisibleVariable selectedVariable;
    OldNodeView.Type selectedDisplay;
    boolean selectedScrollGraph = false;
    JLabel currvaluetxt = new JLabel();

    public QuickAdd() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setSize(200, 200);
        this.getRootPane().setDefaultButton(this.jButton1);
    }

    public void addNotify() {
        this.namefield = (JTextField)this.varname.getEditor().getEditorComponent();
        this.namefield.getDocument().addDocumentListener(new DocumentListener(){
            boolean mod = false;

            public void changedUpdate(DocumentEvent e) {
            }

            public void insertUpdate(DocumentEvent e) {
                if (!this.mod) {
                    this.doup();
                }
            }

            public void removeUpdate(DocumentEvent e) {
                if (!this.mod) {
                    this.doup();
                }
            }

            void doup() {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        String s = (this).QuickAdd.this.namefield.getText();
                        Object o = (this).QuickAdd.this.varname.getSelectedItem();
                        if ((this).QuickAdd.this.lastSelection != s && (o == null || o instanceof String || o instanceof VisibleVariable && !((VisibleVariable)o).longName.equals(s))) {
                            mod = true;
                            QuickAdd.this.updateList(s);
                            (this).QuickAdd.this.lastSelection = s;
                            mod = false;
                        }
                    }
                });
            }
        });
        super.addNotify();
    }

    private void jbInit() throws Exception {
        this.setTitle("Quick add variable");
        this.jButton1.setText("OK");
        this.jButton1.addActionListener(new QuickAdd_jButton1_actionAdapter(this));
        this.jButton2.setText("Cancel");
        this.jButton2.addActionListener(new QuickAdd_jButton2_actionAdapter(this));
        this.varname.setEditable(true);
        this.varname.setModel(this.varmodel);
        this.jPanel1.setLayout(this.borderLayout1);
        this.displaytype.setModel(this.typemodel);
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.jPanel1.add((Component)this.varname, "North");
        this.jPanel1.add((Component)this.jPanel3, "South");
        this.jPanel3.add((Component)this.currvaluetxt, null);
        this.jPanel3.add((Component)this.displaytype, null);
        this.getContentPane().add((Component)this.jPanel2, "South");
        this.jPanel2.add((Component)this.jButton2, null);
        this.jPanel2.add((Component)this.jButton1, null);
    }

    void varname_actionPerformed(ActionEvent e) {
        Object o = this.varname.getSelectedItem();
        if (o != this.previousSelection) {
            if (o instanceof String) {
                String s = o.toString();
                this.updateList(s);
                this.updateDisplayType();
            }
            this.previousSelection = o;
        } else {
            this.okAction();
        }
    }

    void updateList(Object s0) {
        this.varname.hidePopup();
        this.varmodel.removeAllElements();
        int icaret = this.namefield.getCaretPosition();
        String s = s0 == null ? "" : s0.toString();
        int i = 0;
        while (i < Variables.variable.length) {
            VisibleVariable v = Variables.variable[i];
            String slc = s.toLowerCase();
            if (v.shortName.toLowerCase().replace('$', '2').startsWith(slc)) {
                this.varmodel.addElement(v);
            } else if (v.longName.toLowerCase().startsWith(slc)) {
                this.varmodel.addElement(v);
            } else if (v.canonicalName.toLowerCase().startsWith(slc)) {
                this.varmodel.addElement(v);
            }
            ++i;
        }
        this.varname.showPopup();
        if (this.varmodel.getSize() == 1) {
            this.varname.setSelectedItem(this.varmodel.getElementAt(0));
        } else {
            this.varname.setSelectedItem(s);
            this.namefield.setCaretPosition(this.namefield.getDocument().getLength());
        }
        this.updateValue();
    }

    void updateDisplayType() {
        this.typemodel.removeAllElements();
        Object o = this.varname.getSelectedItem();
        this.typemodel.addElement("Scroll graph");
        if (o instanceof VisibleVariable) {
            VisibleVariable v = (VisibleVariable)o;
            OldNodeView.Type[] t = OldNodeView.Type.forNode(v.node);
            int i = 0;
            while (i < t.length) {
                this.typemodel.addElement(t[i]);
                ++i;
            }
        }
        if (this.typemodel.getSize() > 0) {
            this.displaytype.setSelectedIndex(0);
        }
    }

    void okAction() {
        Object o = this.varname.getSelectedItem();
        Object p = this.displaytype.getSelectedItem();
        if (o instanceof VisibleVariable) {
            this.selectedVariable = (VisibleVariable)o;
            if (p instanceof OldNodeView.Type) {
                this.selectedDisplay = (OldNodeView.Type)p;
            } else {
                this.selectedScrollGraph = true;
            }
            this.hide();
        }
    }

    void cancelAction() {
        this.selectedVariable = null;
        this.hide();
    }

    void jButton2_actionPerformed(ActionEvent e) {
        this.cancelAction();
    }

    void jButton1_actionPerformed(ActionEvent e) {
        this.okAction();
    }

    void varname_itemStateChanged(ItemEvent e) {
        this.updateDisplayType();
        this.updateValue();
    }

    void updateValue() {
        Object o = this.varname.getSelectedItem();
        if (o instanceof VisibleVariable) {
            VisibleVariable v = (VisibleVariable)o;
            this.currvaluetxt.setText(v.formatValue(v.node.doubleGetVal(), true, false));
        } else {
            this.currvaluetxt.setText("");
        }
    }
}

