/*
 * Decompiled with CFR 0.152.
 */
package phic.gui;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import phic.gui.PhicEvaluator;
import phic.gui.PhicFrameActions;
import phic.gui.SimplePhicFrame;

public class PhicFrameShortcutKeyMapper {
    public static void mapKeys(final SimplePhicFrame f) {
        ActionMap am = f.mainFramePanel.getActionMap();
        InputMap im = f.mainFramePanel.getInputMap(2);
        PhicFrameActions a = f.frameActions;
        am.put(a.startAction, a.startAction);
        im.put(KeyStroke.getKeyStroke(80, 2), a.startAction);
        am.put(a.partialResetAction, a.restartAction);
        im.put(KeyStroke.getKeyStroke(82, 0), a.restartAction);
        am.put(a.restartAction, a.restartAction);
        im.put(KeyStroke.getKeyStroke(82, 2), a.restartAction);
        am.put(a.quickAddAction, a.quickAddAction);
        im.put(KeyStroke.getKeyStroke(81, 2), a.quickAddAction);
        am.put(a.editControllersAction, a.editControllersAction);
        im.put(KeyStroke.getKeyStroke(71, 2), a.editControllersAction);
        am.put(a.ivDrugBolusAction, a.ivDrugBolusAction);
        im.put(KeyStroke.getKeyStroke(68, 2), a.ivDrugBolusAction);
        am.put(a.oralDrugAction, a.oralDrugAction);
        im.put(KeyStroke.getKeyStroke(68, 0), a.oralDrugAction);
        am.put(a.scenarioHelp, a.scenarioHelp);
        im.put(KeyStroke.getKeyStroke(112, 2), a.scenarioHelp);
        am.put(a.physiologyHelp, a.physiologyHelp);
        im.put(KeyStroke.getKeyStroke(112, 0), a.physiologyHelp);
        am.put(a.fluidBalanceAction, a.fluidBalanceAction);
        im.put(KeyStroke.getKeyStroke(70, 2), a.fluidBalanceAction);
        am.put(a.medicalReportsAction, a.medicalReportsAction);
        im.put(KeyStroke.getKeyStroke(77, 2), a.medicalReportsAction);
        am.put(a.optionsAction, a.optionsAction);
        im.put(KeyStroke.getKeyStroke(79, 2), a.optionsAction);
        am.put(a.lifeSupportAction, a.lifeSupportAction);
        im.put(KeyStroke.getKeyStroke(75, 2), a.lifeSupportAction);
        am.put(a.simulationPlot, a.simulationPlot);
        im.put(KeyStroke.getKeyStroke(85, 2), a.simulationPlot);
        am.put(a.speedUp, a.speedUp);
        im.put(KeyStroke.getKeyStroke(93, 2), a.speedUp);
        am.put(a.speedDown, a.speedDown);
        im.put(KeyStroke.getKeyStroke(91, 2), a.speedDown);
        am.put(a.examineAction, a.examineAction);
        im.put(KeyStroke.getKeyStroke(73, 2), a.examineAction);
        am.put(a.nameChangeAction, a.nameChangeAction);
        im.put(KeyStroke.getKeyStroke(78, 2), a.nameChangeAction);
        am.put(a.scriptEditorAction, a.scriptEditorAction);
        im.put(KeyStroke.getKeyStroke(83, 3), a.scriptEditorAction);
        am.put(a.allEquationsAction, a.allEquationsAction);
        im.put(KeyStroke.getKeyStroke(69, 2), a.allEquationsAction);
        AbstractAction toConsole = new AbstractAction("Type in console"){

            public void actionPerformed(ActionEvent e) {
                PhicEvaluator s = f.statusbar;
                if (s.hasFocus()) {
                    s.transferFocus();
                } else {
                    s.requestFocusInWindow();
                    int pos = Math.max(0, s.getDocument().getLength() - 1);
                    s.setCaretPosition(pos);
                    try {
                        s.setCaretPosition(pos + 1);
                        if (!s.getDocument().getText(pos, 1).equals("\n")) {
                            s.getDocument().insertString(pos + 1, "\n", null);
                            s.setCaretPosition(pos + 2);
                        }
                    }
                    catch (BadLocationException ex) {
                        ex.printStackTrace();
                    }
                    catch (IllegalArgumentException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        };
        am.put(toConsole, toConsole);
        im.put(KeyStroke.getKeyStroke(83, 2), toConsole);
    }

    public static String getHelp(SimplePhicFrame f) {
        ActionMap am = f.mainFramePanel.getActionMap();
        InputMap im = f.mainFramePanel.getInputMap(2);
        Object[] a = am.keys();
        String out = "<HTML><H1>Keyboard shortcuts</H1><TABLE>";
        int i = 0;
        while (i < a.length) {
            AbstractAction ac = (AbstractAction)a[i];
            KeyStroke ks = null;
            KeyStroke[] keyStrokeArray = im.keys();
            int n = keyStrokeArray.length;
            int n2 = 0;
            while (n2 < n) {
                KeyStroke o = keyStrokeArray[n2];
                if (im.get(o) == ac) {
                    ks = o;
                }
                ++n2;
            }
            if (ks != null) {
                out = String.valueOf(out) + "<TR><TD>" + ac.getValue("Name");
                out = String.valueOf(out) + "</TD><TD>" + ks.toString();
                out = String.valueOf(out) + "</TD></TR>";
            }
            ++i;
        }
        return String.valueOf(out) + "</TABLE></HTML>";
    }
}

