/*
 * Decompiled with CFR 0.152.
 */
package phic.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import phic.Current;
import phic.Person;
import phic.Resource;
import phic.common.IniReader;
import phic.gui.FrameStub;
import phic.gui.HTMLMessagePane;
import phic.gui.LimitedNode;
import phic.gui.OldNodeView;
import phic.gui.PathologyAnalysisDialog;
import phic.gui.PersonSetupDialog;
import phic.gui.SimplePhicFrame;
import phic.gui.ThinNodeView;
import phic.modifiable.Script;

public class PhicFrameSetup
extends SimplePhicFrame
implements FrameStub {
    final String DEFAULT_SECTION = "Default";
    public static boolean treeIsShowing = true;
    public static int allowEquations = 1;
    public static boolean allowVariableModification = true;
    double timeCompression = Double.NaN;
    public static final long STARTUP_INFO_DELAY = 4000L;
    String patientFile = null;
    Runnable startRunner;
    double consoleSize = Double.NaN;
    protected boolean startClockOnInitialisation = false;
    protected String defaultGraphSetup = null;
    boolean firstEverReset = true;

    public PhicFrameSetup() {
        this.setSize(new Dimension(650, 490));
    }

    public PhicFrameSetup(String resourceFile, String resourceSection) {
        this();
        this.doSetup(resourceFile, resourceSection);
    }

    public void doSetup(String resourceFile, String resourceSection) {
        if (resourceSection == null) {
            resourceSection = "Default";
        }
        IniReader ir = new IniReader(resourceFile);
        Map m = null;
        try {
            m = ir.getSectionMap(resourceSection);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid section name in " + resourceFile + ": " + resourceSection);
        }
        this.setTitle(Resource.identifierToText("HOM - Human Physiology Model - " + resourceSection));
        this.doSetup(m);
    }

    public void doSetup(Map m) {
        String startupScript;
        String vn;
        String graphSetupFile;
        try {
            double width = (Double)m.get("FrameWidth");
            if (width > 0.0) {
                this.setSize((int)width, this.getSize().height);
            }
        }
        catch (NullPointerException width) {
            // empty catch block
        }
        try {
            double height = (Double)m.get("FrameHeight");
            if (height > 0.0) {
                this.setSize(this.getSize().width, (int)height);
            }
        }
        catch (NullPointerException height) {
            // empty catch block
        }
        try {
            boolean fullscreen = (Boolean)m.get("FullScreen");
            if (fullscreen) {
                this.setExtendedState(6);
            }
        }
        catch (Exception fullscreen) {
            // empty catch block
        }
        try {
            boolean resiz = (Boolean)m.get("Resizeable");
            this.setResizable(resiz);
        }
        catch (NullPointerException resiz) {
            // empty catch block
        }
        try {
            boolean tree = true;
            Boolean b = (Boolean)m.get("Tree");
            if (b != null) {
                tree = b;
            }
            if (!tree) {
                treeIsShowing = tree;
                this.mainFramePanel.remove(this.mainSplitter);
                this.mainFramePanel.add((Component)this.rightHandPanel, "Center");
                this.rightBottomPanel.add((Component)this.dripspanel, "North");
                OldNodeView.TitleBar.allowClose = false;
            } else {
                OldNodeView.TitleBar.allowClose = true;
                treeIsShowing = true;
            }
        }
        catch (NullPointerException e) {
            treeIsShowing = true;
        }
        try {
            int sliderWidth = ((Number)m.get("SliderWidth")).intValue();
            ThinNodeView.setSliderWidth(sliderWidth);
        }
        catch (Exception sliderWidth) {
            // empty catch block
        }
        try {
            boolean rew = (Boolean)m.get("RewindButton");
            this.setRewindEnabled(rew);
            if (!rew) {
                this.controlBar.remove(this.rewindbutton);
            }
        }
        catch (NullPointerException rew) {
            // empty catch block
        }
        try {
            boolean build;
            PersonSetupDialog.allowBuildABod = build = ((Boolean)m.get("EditPatient")).booleanValue();
        }
        catch (NullPointerException build) {
            // empty catch block
        }
        try {
            boolean limit = (Boolean)m.get("LimitChecker");
            if (!limit) {
                this.rightBottomPanel.remove(this.limitChecker);
                this.limitChecker.running = false;
            }
        }
        catch (NullPointerException limit) {
            // empty catch block
        }
        try {
            boolean menus = (Boolean)m.get("Menus");
            if (!menus) {
                this.setJMenuBar(null);
            }
        }
        catch (NullPointerException menus) {
            // empty catch block
        }
        try {
            boolean fluid = (Boolean)m.get("FluidsMenu");
            if (!fluid) {
                this.menuBar.remove(this.fluidsmenu.getComponent());
            }
        }
        catch (NullPointerException fluid) {
            // empty catch block
        }
        try {
            boolean partreset = (Boolean)m.get("PartialReset");
            if (!partreset) {
                this.controlBar.remove(this.partialreset);
            }
        }
        catch (NullPointerException partreset) {
            // empty catch block
        }
        try {
            boolean advtiming = (Boolean)m.get("AdvancedTiming");
            if (!advtiming) {
                this.allowRatePanel = false;
            }
        }
        catch (NullPointerException advtiming) {
            // empty catch block
        }
        try {
            boolean diagnose;
            PathologyAnalysisDialog.diagnose = diagnose = ((Boolean)m.get("Diagnose")).booleanValue();
        }
        catch (NullPointerException diagnose) {
            // empty catch block
        }
        try {
            boolean tools = (Boolean)m.get("ToolsMenu");
            if (!tools) {
                this.menuBar.remove(this.toolsmenu.getComponent());
            }
        }
        catch (NullPointerException tools) {
            // empty catch block
        }
        try {
            boolean graphs = (Boolean)m.get("GraphsMenu");
            if (!graphs) {
                this.menuBar.remove(this.graphsmenu.getComponent());
                this.helpmenu.add(new AbstractAction("Restore default graphs"){

                    public void actionPerformed(ActionEvent e) {
                        PhicFrameSetup.this.graphsetup(new ActionEvent(this, 0, PhicFrameSetup.this.defaultGraphSetup));
                    }
                });
            }
        }
        catch (NullPointerException graphs) {
            // empty catch block
        }
        this.checkForOtherMenus(m);
        try {
            boolean console = (Boolean)m.get("Console");
            if (!console) {
                this.rightBottomPanel.remove(this.consolepanel);
            }
        }
        catch (NullPointerException console) {
            // empty catch block
        }
        try {
            double consize;
            this.consoleSize = consize = ((Double)m.get("ConsoleHeight")).doubleValue();
        }
        catch (NullPointerException consize) {
            // empty catch block
        }
        try {
            boolean controls = (Boolean)m.get("ControlBar");
            if (!controls) {
                this.mainFramePanel.remove(this.controlBar);
            }
        }
        catch (NullPointerException controls) {
            // empty catch block
        }
        if ((graphSetupFile = (String)m.get("GraphSetupFile")) != null) {
            this.graphsetups = new IniReader(graphSetupFile);
        }
        this.defaultGraphSetup = (String)m.get("GraphSetup");
        if (this.defaultGraphSetup != null) {
            try {
                this.graphsetup(new ActionEvent(this, 0, this.defaultGraphSetup));
            }
            catch (Exception e) {
                System.out.println("Invalid graph setup: " + this.defaultGraphSetup);
                e.printStackTrace();
            }
        }
        try {
            double timeb = (Double)m.get("Timebase");
            if (timeb > 0.0) {
                this.graph.setTSpeed(timeb);
            }
        }
        catch (NullPointerException timeb) {
            // empty catch block
        }
        if ((vn = (String)m.get("VisibleNodes")) != null) {
            try {
                LimitedNode.visibleNodesSection = vn;
            }
            catch (IllegalArgumentException e) {
                System.out.println("No such VisibleNodes setup: " + vn);
            }
        }
        this.patientFile = (String)m.get("PatientFile");
        if (this.patientFile != null) {
            this.fileOpen(this.patientFile);
        }
        try {
            this.timeCompression = (Double)m.get("TimeCompression");
            if (this.timeCompression > 0.0) {
                Current.body.getClock().setSecond(1000.0 / this.timeCompression);
                this.updateSpeedSlider();
                this.updateTimeCompText();
            }
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            boolean start = (Boolean)m.get("Started");
            if (!start) {
                this.stopPressed();
                this.startClockOnInitialisation = false;
            } else {
                this.startClockOnInitialisation = true;
            }
        }
        catch (NullPointerException start) {
            // empty catch block
        }
        boolean startWithInformation = false;
        try {
            startWithInformation = (Boolean)m.get("StartWithInformation");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        final String scenario = (String)m.get("ScenarioHtml");
        if (scenario != null) {
            this.currentHelpResource = scenario;
            if (startWithInformation) {
                this.startRunner = new Runnable(){

                    public void run() {
                        try {
                            Thread.sleep(4000L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        HTMLMessagePane.showDialog(scenario, "Welcome");
                    }
                };
            }
        }
        if ((startupScript = (String)m.get("StartupScript")) != null) {
            try {
                Current.body.startupScript = new Script("Startup script", "Run every time the variables are reset", startupScript.trim(), false);
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
        try {
            this.graph.mainpane.allowDrawOnGraph = (Boolean)m.get("AllowMouseDrawing");
        }
        catch (Exception x) {
            // empty catch block
        }
        try {
            boolean showGraphPanel = (Boolean)m.get("GraphPanel");
            if (!showGraphPanel) {
                this.rightSplitter.remove(this.graphspane);
            }
        }
        catch (Exception showGraphPanel) {
            // empty catch block
        }
        try {
            boolean showvs = (Boolean)m.get("VariableStrips");
            if (!showvs) {
                this.jPanel1.setVisible(false);
            }
        }
        catch (Exception showvs) {
            // empty catch block
        }
        try {
            boolean showvs = (Boolean)m.get("ChangePatient");
            if (!showvs) {
                this.namebox.setEnabled(false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            allowEquations = ((Double)m.get("Equations")).intValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void fileOpen(String file) {
        try {
            InputStream is = null;
            try {
                is = new FileInputStream(file);
            }
            catch (Exception e) {
                is = Resource.loader.getResource(file);
            }
            if (this.filer != null) {
                if (file.endsWith(".patient")) {
                    Person p = this.filer.openPatientFile(is);
                    this.setupNewPerson(p);
                } else {
                    Person p = new Person();
                    this.setupNewPerson(p);
                    this.filer.openScriptFile(is);
                }
            }
            this.startPressed();
        }
        catch (IOException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "Could not load " + file + "\n because of " + e, "Error loading file", 0);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "The file " + file + "\n was created with an old version (" + e + ")", "Error loading file", 0);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "The file " + file + "\n contains invalid script commands. ", "Error loading file", 0);
        }
    }

    public void show() {
        super.show();
        this.initialise();
    }

    public void initialise() {
        if (LimitedNode.visibleNodesSection != null) {
            LimitedNode.setVisibleNodesDelayed(LimitedNode.visibleNodesSection);
        }
        this.bodyTree.reload();
        this.restartbutton.doClick();
        if (this.startClockOnInitialisation) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Timer t = new Timer(1000, new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            PhicFrameSetup.this.startPressed();
                            if (!Double.isNaN((this).PhicFrameSetup.this.consoleSize)) {
                                (this).PhicFrameSetup.this.rightSplitter.setDividerLocation((this).PhicFrameSetup.this.consoleSize);
                                System.out.println("Done resize!");
                            }
                        }
                    });
                    t.setRepeats(false);
                    t.start();
                }
            });
        }
    }

    protected void checkForOtherMenus(Map m) {
        try {
            for (String menuItem : m.keySet()) {
                Component c = this.searchMenu(this.menuBar, menuItem);
                if (c == null) continue;
                boolean visible = (Boolean)m.get(menuItem);
                if (!(c instanceof JMenuItem)) continue;
                ((JMenuItem)c).setVisible(visible);
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    protected Component searchMenu(MenuElement e, String s) {
        String str;
        Component c = e.getComponent();
        if (c instanceof JMenuItem && (str = ((JMenuItem)c).getText()) != null && str.equalsIgnoreCase(s)) {
            return c;
        }
        MenuElement[] me = e.getSubElements();
        int i = 0;
        while (i < me.length) {
            Component f = this.searchMenu(me[i], s);
            if (f != null) {
                return f;
            }
            ++i;
        }
        return null;
    }

    void doFullReset() {
        super.doFullReset();
        if (this.patientFile != null) {
            this.fileOpen(this.patientFile);
        }
        if (!Double.isNaN(this.timeCompression) && this.timeCompression > 0.0) {
            Current.body.getClock().setSecond(1000.0 / this.timeCompression);
            this.updateSpeedSlider();
        }
        if (this.firstEverReset && this.startRunner != null) {
            new Thread(this.startRunner).start();
            this.firstEverReset = false;
        }
    }

    public void patientWarning(int level, String message) {
        this.stopPressed();
        String t = "unknown";
        String m = "";
        if (level == 2) {
            t = "unconscious";
        } else if (level == 3) {
            t = "dead";
        }
        if (message != null) {
            m = " because of " + message;
        }
        JOptionPane.showMessageDialog(this, new String[]{String.valueOf(Current.person.name) + " is " + t + m + ".", "The simulation has been paused."}, "Warning", 2);
    }

    public void addCloseListener(final ActionListener reshowListener) {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent e) {
                reshowListener.actionPerformed(new ActionEvent(e.getSource(), e.getID(), "Close"));
            }
        });
    }
}

