/*
 * Decompiled with CFR 0.152.
 */
package phic.gui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import phic.Current;
import phic.Resource;
import phic.drug.DrugContainer;
import phic.ecg.PhicECGDialog;
import phic.gui.AboutBox;
import phic.gui.ControllerEditorDialog;
import phic.gui.DrugConcentrationGraphChooser;
import phic.gui.DrugDialog;
import phic.gui.FluidBalanceDialog;
import phic.gui.HTMLMessagePane;
import phic.gui.HorzScrollGraph;
import phic.gui.LifeSupportDialog;
import phic.gui.MonitorsDialog;
import phic.gui.OptionsDialog;
import phic.gui.PathologyAnalysisDialog;
import phic.gui.PersonSetupDialog;
import phic.gui.PhicApplication;
import phic.gui.PhicFileDialog;
import phic.gui.PhicFrameShortcutKeyMapper;
import phic.gui.QuickAdd;
import phic.gui.ScreensDialog;
import phic.gui.ScriptEditor;
import phic.gui.SendCommentsDialog;
import phic.gui.SimplePhicFrame;
import phic.gui.SimulationPlotDialog;
import phic.gui.VariableEquationsPanel;
import phic.gui.Variables;
import phic.gui.VisibleVariable;
import phic.gui.exam.ExaminationsDialog;
import phic.gui.exam.ImageDiagramDialog;
import sanjay.common.BareBonesBrowserLaunch;

public class PhicFrameActions {
    static final String websiteUrl = "http://www.homphysiology.org";
    SimplePhicFrame f;
    public Action zoomInAll = new PhicAction("Zoom in graph scales"){

        public void actionPerformed(ActionEvent e) {
            PhicFrameActions.this.f.graph.zoomAllGraphs(false);
        }
    };
    public Action zoomOutAll = new PhicAction("Zoom out graph scales"){

        public void actionPerformed(ActionEvent e) {
            PhicFrameActions.this.f.graph.zoomAllGraphs(true);
        }
    };
    public Action printScreen;
    public Action printGraphs;
    public Action printLog;
    public Action monitoringAction = new PhicAction("Monitoring"){

        public void actionPerformed(ActionEvent e) {
            new MonitorsDialog().show();
        }
    };
    public Action ivDrugBolusAction = new PhicAction("IV drug bolus"){

        public void actionPerformed(ActionEvent e) {
            DrugDialog d = new DrugDialog();
            d.setTitle("Choose intravenous drug");
            d.OK.setText("Give");
            d.show();
            DrugContainer drug = d.getDrugContainer();
            if (drug != null) {
                Current.body.message("IV bolus of " + d.getDrugLabel());
                Current.body.blood.add(drug);
                PhicFrameActions.this.f.markEvent(d.getDrugName());
            }
        }
    };
    public Action oralDrugAction = new PhicAction("Oral drug"){

        public void actionPerformed(ActionEvent e) {
            DrugDialog d = new DrugDialog();
            d.setTitle("Choose oral drug");
            d.OK.setText("Give");
            d.show();
            DrugContainer drug = d.getDrugContainer();
            if (drug != null) {
                Current.body.message("Oral dose of " + d.getDrugLabel());
                Current.body.gitract.stomach.add(drug);
                PhicFrameActions.this.f.markEvent(d.getDrugName());
            }
        }
    };
    public Action medicalReportsAction = new PhicAction("Medical reports"){

        public void actionPerformed(ActionEvent e) {
            ScreensDialog s = new ScreensDialog();
            s.show();
        }
    };
    Action scenarioHelp;
    Action physiologyHelp;
    ImageIcon resicon = new ImageIcon(Resource.loader.getImageResource("RewindFully.gif"));
    Action restartAction = new PhicAction("Restart", "Reset whole simulation", this.resicon){

        public void actionPerformed(ActionEvent e) {
            Cursor previousCursor = PhicFrameActions.this.f.getCursor();
            PhicFrameActions.this.f.setCursor(Cursor.getPredefinedCursor(3));
            try {
                boolean wasStarted = PhicFrameActions.this.f.started;
                if (PhicFrameActions.this.f.started) {
                    PhicFrameActions.this.f.stopPressed();
                }
                PhicFrameActions.this.f.doFullReset();
                if (wasStarted) {
                    PhicFrameActions.this.f.startPressed();
                }
            }
            finally {
                PhicFrameActions.this.f.setCursor(previousCursor);
            }
        }
    };
    ImageIcon rewicon = new ImageIcon(Resource.loader.getImageResource("Rewind.gif"));
    Action partialResetAction = new PhicAction("Partial reset", "Reset variable values", this.rewicon){

        public void actionPerformed(ActionEvent e) {
            Cursor previousCursor = PhicFrameActions.this.f.getCursor();
            PhicFrameActions.this.f.setCursor(Cursor.getPredefinedCursor(3));
            try {
                boolean wasStarted = PhicFrameActions.this.f.started;
                if (PhicFrameActions.this.f.started) {
                    PhicFrameActions.this.f.stopPressed();
                }
                PhicFrameActions.this.f.doPartialReset();
                if (wasStarted) {
                    PhicFrameActions.this.f.startPressed();
                }
            }
            finally {
                PhicFrameActions.this.f.setCursor(previousCursor);
            }
        }
    };
    Action quickAddAction = new PhicAction("Quick add"){

        public void actionPerformed(ActionEvent e) {
            QuickAdd q = new QuickAdd();
            q.show();
            if (q.selectedVariable != null) {
                if (!q.selectedScrollGraph) {
                    PhicFrameActions.this.f.showVariableInMain(q.selectedVariable.node, q.selectedDisplay.type);
                } else {
                    PhicFrameActions.this.f.createThinView(q.selectedVariable.node, false);
                }
            }
        }
    };
    Action startAction;
    Action editControllersAction = new PhicAction("Edit controllers"){

        public void actionPerformed(ActionEvent e) {
            ControllerEditorDialog c = new ControllerEditorDialog();
            c.setBody(Current.body);
            c.setFrame(PhicFrameActions.this.f);
            c.show();
        }
    };
    Action closeAllGraphsAction = new PhicAction("Close all graphs"){

        public void actionPerformed(ActionEvent e) {
            PhicFrameActions.this.f.closeAllGraphs();
        }
    };
    public Action fluidBalanceAction = new PhicAction("Fluid balance sheet"){

        public void actionPerformed(ActionEvent e) {
            new FluidBalanceDialog().show();
        }
    };
    public Action exitAction = new PhicAction("Exit"){

        public void actionPerformed(ActionEvent e) {
            PhicFrameActions.this.f.hide();
            Current.body.setRunning(false);
            System.exit(0);
        }
    };
    public Action ecgAction = new PhicAction("ECG"){

        public void actionPerformed(ActionEvent e) {
            PhicECGDialog d = new PhicECGDialog();
            d.show();
        }
    };
    public Action examineAction = new PhicAction("Examine patient"){

        public void actionPerformed(ActionEvent e) {
            ExaminationsDialog d = new ExaminationsDialog(Current.body);
            d.show();
        }
    };
    public Action aboutAction = new PhicAction("About"){

        public void actionPerformed(ActionEvent e) {
            new AboutBox().show();
        }
    };
    public Action scriptEditorAction = new PhicAction("Script editor"){

        public void actionPerformed(ActionEvent e) {
            ScriptEditor se = new ScriptEditor(PhicFrameActions.this.f.scripts);
            se.show();
            PhicFrameActions.this.f.scripts = se.getScripts();
        }
    };
    public Action optionsAction = new PhicAction("Options"){

        public void actionPerformed(ActionEvent e) {
            new OptionsDialog().show();
        }
    };
    ImageIcon backwardIcon = new ImageIcon(Resource.loader.getImageResource("PlayBackwards.gif"));
    public Action rewindAction = new PhicAction("Rewind", this.backwardIcon){

        public void actionPerformed(ActionEvent e) {
            PhicFrameActions.this.f.rewindDialog.show();
        }
    };
    public Action rescaleAction = new PhicAction("Rescale"){

        public void actionPerformed(ActionEvent e) {
            PhicFrameActions.this.f.graph.rescaleAll();
        }
    };
    public Action nameChangeAction = new PhicAction("Change patient details"){

        public void actionPerformed(ActionEvent e) {
            PersonSetupDialog d = new PersonSetupDialog(Current.person);
            d.show();
            if (d.okPressed) {
                PhicFrameActions.this.f.namebox.setText(d.person.name);
            }
        }
    };
    public Action pathologyAnalysisAction = new PhicAction("Pathology analysis"){

        public void actionPerformed(ActionEvent e) {
            new PathologyAnalysisDialog().show();
        }
    };
    public Action lifeSupportAction = new PhicAction("Clamp variables"){

        public void actionPerformed(ActionEvent e) {
            new LifeSupportDialog(Current.environment.getVariableClamps()).show();
        }
    };
    public Action drugLevelsAction = new PhicAction("Drug levels"){

        public void actionPerformed(ActionEvent e) {
            new DrugConcentrationGraphChooser().show();
        }
    };
    public Action diagramsAction = new PhicAction("Diagrams"){

        public void actionPerformed(ActionEvent e) {
            new ImageDiagramDialog().show();
        }
    };
    public Action sendProblemToAuthor = new PhicAction("Send problem to author"){

        public void actionPerformed(ActionEvent e) {
            new SendCommentsDialog().show();
        }
    };
    public Action resetControllers = new PhicAction("Reset controllers", "Reset all the controller values to defaults"){

        public void actionPerformed(ActionEvent e) {
            Current.body.setupControllers();
        }
    };
    public Action speedUp = new PhicAction("Increase simulation speed", "Makes body-time run faster relative to real-time"){

        public void actionPerformed(ActionEvent e) {
            PhicFrameActions.this.f.timecomp.setValue(PhicFrameActions.this.f.timecomp.getValue() + 1);
        }
    };
    public Action speedDown = new PhicAction("Decrease simulation speed", "Makes body-time run slower relative to real-time"){

        public void actionPerformed(ActionEvent e) {
            PhicFrameActions.this.f.timecomp.setValue(PhicFrameActions.this.f.timecomp.getValue() - 1);
        }
    };
    SimulationPlotDialog spdlg;
    public Action simulationPlot = new PhicAction("Simulation plot", "Run the model several times and plot graph of results"){

        public void actionPerformed(ActionEvent e) {
            if (PhicFrameActions.this.spdlg == null) {
                PhicFrameActions.this.spdlg = new SimulationPlotDialog();
            }
            PhicFrameActions.this.spdlg.show();
        }
    };
    public Action goToWebsite = new PhicAction("HOM website", "Open the HOM website in a browser window (www.homphysiology.org)"){

        public void actionPerformed(ActionEvent e) {
            BareBonesBrowserLaunch.openURL(PhicFrameActions.websiteUrl);
        }
    };
    public static VariableEquationsPanel variableEquationsPanel;
    public Action allEquationsAction;
    public Action someEquationsAction;
    public Action showShortcuts;
    public Action copyPersonData;
    ClipboardOwner cbo;

    public PhicFrameActions(final SimplePhicFrame f) {
        Thread initialiseVEQ = new Thread(new Runnable(){

            public void run() {
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                variableEquationsPanel = new VariableEquationsPanel();
                variableEquationsPanel.setFilter((VisibleVariable)null);
            }
        });
        initialiseVEQ.start();
        this.allEquationsAction = new PhicAction("All equations", "View all the equations in the model"){

            public void actionPerformed(ActionEvent e) {
                VariableEquationsPanel.Dialog m = variableEquationsPanel.createDialog();
                m.setVisible(true);
            }
        };
        this.someEquationsAction = new PhicAction("Variable's equations", "View all equations which include this variable"){

            public void actionPerformed(ActionEvent e) {
                VariableEquationsPanel.Dialog m = variableEquationsPanel.createDialog();
                m.setFilter(Variables.forName(e.getActionCommand()));
                m.setVisible(true);
            }
        };
        this.showShortcuts = new PhicAction("Keyboard shortcuts", "Show list of all keyboard shorctuts"){

            public void actionPerformed(ActionEvent e) {
                try {
                    JEditorPane ep = new JEditorPane("text/html", PhicFrameShortcutKeyMapper.getHelp((SimplePhicFrame)((Object)PhicApplication.frame)));
                    ep.setEditable(false);
                    JOptionPane.showMessageDialog(PhicFrameActions.this.f, ep);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        };
        this.copyPersonData = new PhicAction("Copy variables", "Copies all the data for the current person to the clipboard"){

            public void actionPerformed(ActionEvent e) {
                StringWriter sw = new StringWriter(2048);
                PhicFileDialog cfr_ignored_0 = PhicFrameActions.this.f.filer;
                PhicFileDialog.writeVariablesToScript(new PrintWriter(sw), Current.person);
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(sw.toString()), PhicFrameActions.this.cbo);
            }
        };
        this.cbo = new ClipboardOwner(){

            public void lostOwnership(Clipboard c, Transferable t) {
            }
        };
        this.f = f;
        this.printScreen = new PrintAction("Print screen", f);
        this.printGraphs = new PrintAction("Print graphs", f.graph);
        this.printLog = new PrintAction("Print log", f.statusbar);
        this.scenarioHelp = new HTMLMessageAction(f.currentHelpResource, "Scenario information"){

            public void actionPerformed(ActionEvent e) {
                this.r = f.currentHelpResource;
                super.actionPerformed(e);
            }
        };
        this.physiologyHelp = new HTMLMessageAction(f.generalHelpResource, "Physiology help");
        this.startAction = new PhicAction("Start", f.picon){

            public void actionPerformed(ActionEvent e) {
                if (!f.started) {
                    f.startPressed();
                } else {
                    f.stopPressed();
                }
            }
        };
    }

    private void doPrinting(final Component item) {
        PrinterJob p = PrinterJob.getPrinterJob();
        p.setPrintable(new Printable(){

            public int print(Graphics g, PageFormat f, int page) {
                if (page == 0) {
                    boolean cfr_ignored_0 = item instanceof HorzScrollGraph;
                    Graphics2D g2 = (Graphics2D)g;
                    g2.translate(f.getImageableX(), f.getImageableY());
                    double fw = f.getImageableWidth();
                    double fh = f.getImageableHeight();
                    double cw = item.getWidth();
                    double ch = item.getHeight();
                    if (cw > fw || ch > fh) {
                        if (fw / fh < cw / ch) {
                            g2.scale(fw / cw, fw / cw);
                        } else {
                            g2.scale(fh / ch, fh / ch);
                        }
                    }
                    item.paintAll(g);
                    return 0;
                }
                return 1;
            }
        });
        p.setCopies(1);
        p.printDialog();
        try {
            p.print();
        }
        catch (PrinterException ex) {
            JOptionPane.showMessageDialog(this.f, ex, "Could not print", 0);
        }
    }

    class HTMLMessageAction
    extends PhicAction {
        String r;
        String a;

        public HTMLMessageAction(String resource, String action) {
            super(action);
            this.r = resource;
            this.a = action;
        }

        public HTMLMessageAction(String resource, Icon i, String action) {
            super(action, i);
            this.r = resource;
            this.a = action;
        }

        public void actionPerformed(ActionEvent e) {
            HTMLMessagePane.showDialog(this.r, this.a);
        }
    }

    abstract class PhicAction
    extends AbstractAction {
        public PhicAction(String name) {
            super(name);
        }

        public PhicAction(String name, Icon icon) {
            super(name, icon);
        }

        public PhicAction(String name, String tooltip) {
            super(name);
            this.putValue("ShortDescription", tooltip);
        }

        public PhicAction(String name, String tooltip, Icon icon) {
            super(name, icon);
            this.putValue("ShortDescription", tooltip);
        }
    }

    class PrintAction
    extends PhicAction {
        Component p;

        public PrintAction(String action, Component p) {
            super(action);
            this.p = p;
        }

        public PrintAction(String action, Icon i, Component p) {
            super(action, i);
            this.p = p;
        }

        public void actionPerformed(ActionEvent e) {
            PhicFrameActions.this.doPrinting(this.p);
        }
    }
}

