/*
 * Decompiled with CFR 0.152.
 */
package phic.gui;

import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import phic.Current;
import phic.Person;
import phic.gui.Variables;
import phic.gui.VisibleVariable;
import phic.modifiable.Script;

public class PhicFileDialog
extends JFileChooser {
    public static PhicFileDialog createFileDialog() throws IllegalAccessException {
        boolean error = false;
        long time = System.currentTimeMillis() + 2000L;
        block4: do {
            File[] files;
            try {
                Class<?> c = Class.forName("sun.awt.shell.ShellFolder");
                Method get = c.getMethod("get", String.class);
                files = (File[])get.invoke(null, "fileChooserShortcutPanelFolders");
            }
            catch (Exception e) {
                throw new IllegalAccessException("No file system access.");
            }
            error = false;
            int i = 0;
            while (i < files.length) {
                try {
                    Class<?> c = Class.forName("sun.awt.shell.ShellFolder");
                    if (c.isAssignableFrom(files[i].getClass()) && c.getMethod("getIcon", Boolean.TYPE).invoke((Object)files[i], Boolean.TRUE) == null) {
                        error = true;
                        System.out.println("avoided Bug#4711700");
                        continue block4;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++i;
            }
        } while (error && System.currentTimeMillis() < time);
        return new PhicFileDialog();
    }

    private PhicFileDialog() {
        super(String.valueOf(Current.class.getResource("").getPath()) + "/resources/patient");
        this.addChoosableFileFilter(new PatientFilter());
        this.addChoosableFileFilter(new ScriptFileFilter());
    }

    public static void writeVariablesToScript(OutputStream s, Person p) {
        PrintWriter w = new PrintWriter(s);
        PhicFileDialog.writeVariablesToScript(w, p);
    }

    public static void writeVariablesToScript(PrintWriter w, Person p) {
        w.println("// Variable script: " + p.body.getClock().getTimeString(0));
        VisibleVariable[] v = Variables.variable;
        int i = 0;
        while (i < v.length) {
            w.println(String.valueOf(v[i].canonicalName) + "\t=\t" + String.valueOf(v[i].node.doubleGetVal()) + ";");
            ++i;
        }
        w.println("// End of variables");
        w.flush();
        w.close();
    }

    public void save(Person p, Component parent) {
        if (this.showSaveDialog(parent) == 0) {
            try {
                FileOutputStream os = new FileOutputStream(this.getSelectedFile());
                if (this.getFileFilter() instanceof PatientFilter) {
                    ObjectOutputStream oos = new ObjectOutputStream(os);
                    oos.writeObject(p);
                    oos.close();
                } else if (this.getFileFilter() instanceof ScriptFileFilter) {
                    PhicFileDialog.writeVariablesToScript(os, p);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, e, "Error saving file", 0);
            }
        }
    }

    public Person open(Component parent) {
        Person person = null;
        if (this.showOpenDialog(parent) == 0) {
            try {
                FileInputStream is = new FileInputStream(this.getSelectedFile());
                if (this.getFileFilter() instanceof PatientFilter) {
                    ObjectInputStream ois = new ObjectInputStream(is);
                    person = (Person)ois.readObject();
                    ois.close();
                } else {
                    Script.executeScriptFromStream(is, null);
                    ((InputStream)is).close();
                }
            }
            catch (InvalidClassException x) {
                JOptionPane.showMessageDialog(this, "The file " + this.getSelectedFile() + " is not compatible with this version of the program.", "Incompatible file", 0);
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, e, "Error opening file", 0);
            }
        }
        return person;
    }

    public Person openPatientFile(InputStream is) throws IOException, ClassNotFoundException {
        ObjectInputStream ois = new ObjectInputStream(is);
        Person person = (Person)ois.readObject();
        ois.close();
        return person;
    }

    public void openScriptFile(InputStream is) throws IOException, ClassNotFoundException, InvocationTargetException, IOException {
        Script.executeScriptFromStream(is, null);
        is.close();
    }

    class PatientFilter
    extends FileFilter {
        PatientFilter() {
        }

        public boolean accept(File f) {
            return f.getName().endsWith(".patient") || f.getName().indexOf(46) < 0;
        }

        public String getDescription() {
            return "HOM patient file (*.patient)";
        }
    }

    class ScriptFileFilter
    extends FileFilter {
        ScriptFileFilter() {
        }

        public boolean accept(File f) {
            return f.getName().endsWith(".txt") || f.getName().endsWith(".js") || f.getName().endsWith(".script");
        }

        public String getDescription() {
            return "HOM patient script";
        }
    }
}

