/*
 * Decompiled with CFR 0.152.
 */
package phic.gui;

import evaluator.EquationException;
import evaluator.EvaluatorConsole;
import evaluator.MathException;
import evaluator.MathExtra;
import evaluator.ObjectPath;
import evaluator.ParseException;
import evaluator.StackException;
import evaluator.Variable;
import evaluator.VariableLookup;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import phic.Current;
import phic.common.Container;
import phic.common.VDouble;
import phic.gui.Node;
import phic.gui.Variables;
import phic.gui.VisibleVariable;
import phic.modifiable.EvaluatorHelper;

public class PhicEvaluator
extends EvaluatorConsole
implements VariableLookup {
    KeyListener kl = new KeyAdapter(){

        public void keyPressed(KeyEvent e) {
            if (!e.isActionKey() && e.getModifiers() == 0 && e.getKeyChar() >= ' ' && e.getKeyChar() < '\u007f') {
                e.consume();
            }
        }
    };
    MouseListener ml = new MouseAdapter(){

        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                PhicEvaluator.this.popupmenu(e.getPoint());
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                PhicEvaluator.this.popupmenu(e.getPoint());
            }
        }
    };
    JPopupMenu menu = new JPopupMenu();
    EvaluatorHelper evaluatorHelper = new EvaluatorHelper();

    public PhicEvaluator() {
        this.restoreObjectRoots();
        ObjectPath.setPackage(new String[]{"java.lang", "phic", "phic.common", "phic.gui", "phic.drug", "phic.doctor", "java.awt", "javax.swing", "java.util"});
        this.setFont(new Font("Monospaced", this.getFont().getStyle(), this.getFont().getSize()));
        this.addKeyListener(this.kl);
        Variable.namespaceLookup = this;
        this.addMouseListener(this.ml);
        Action[] a = this.getActions();
        int i = 0;
        while (i < a.length) {
            Object t = a[i].getValue("Name");
            if (t != null && t.toString().indexOf("clipboard") >= 0) {
                this.menu.add(a[i]);
            }
            ++i;
        }
        this.menu.add(this.evaluateSelection);
    }

    protected String evaluate(String s) throws ParseException, MathException, StackException {
        return EvaluatorHelper.evaluate(s);
    }

    public Object getVariableValue(String variableName) {
        if (variableName.equalsIgnoreCase("Time")) {
            return Current.body.getClock().getTimeString(0);
        }
        try {
            return new Double(Variables.forName((String)variableName).node.doubleGetVal());
        }
        catch (IllegalArgumentException e) {
            Object val = Variable.table.get(variableName);
            if (val != null) {
                return val;
            }
            throw new EquationException("Variable " + variableName + " not found");
        }
    }

    void popupmenu(Point x) {
        this.menu.show(this, x.x, x.y);
    }

    public void restoreObjectRoots() {
        try {
            ObjectPath.setRoot(new Object[]{Current.body, Current.environment, Class.forName("java.lang.Math"), MathExtra.class, Current.person, this.evaluatorHelper});
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void set(String vname, Object value) throws EquationException {
        Node node;
        VisibleVariable v;
        try {
            v = Variables.forName(vname);
        }
        catch (IllegalArgumentException e1) {
            try {
                v = Variables.forName("body." + vname);
            }
            catch (IllegalArgumentException e2) {
                try {
                    v = Variables.forName("environment." + vname);
                }
                catch (IllegalArgumentException e3) {
                    v = null;
                }
            }
        }
        if (v == null) {
            try {
                node = Node.findNodeByName(vname);
            }
            catch (IllegalArgumentException x) {
                int idot = vname.lastIndexOf(46);
                try {
                    VisibleVariable ivv = Variables.forName(vname.substring(0, idot));
                    String iname = vname.substring(idot + 1);
                    double dval = (Double)value;
                    VDouble vd = ivv.node.getVDouble();
                    if (iname.equalsIgnoreCase("initialValue")) {
                        vd.initialValue = dval;
                        return;
                    }
                    if (iname.equalsIgnoreCase("maximum")) {
                        vd.maximum = dval;
                        return;
                    }
                    if (!iname.equalsIgnoreCase("minimum")) throw new IllegalArgumentException("");
                    vd.minimum = dval;
                    return;
                }
                catch (Exception x2) {
                    Variable.set(vname, value);
                    return;
                }
            }
        } else {
            node = v.node;
        }
        int type = node.getType();
        if (type == 2) {
            if (value instanceof Double) {
                node.doubleSetVal((Double)value);
                return;
            } else {
                node.doubleSetVal(Double.parseDouble(value.toString()));
            }
            return;
        } else if (type == 4) {
            if (!(value instanceof Container)) throw new EquationException("Result '" + value.toString() + "' is not a Container");
            ((Container)node.objectGetVal()).set((Container)value);
            return;
        } else {
            if (type != 3) throw new EquationException("Type mismatch between " + value.toString() + " and " + v.node.canonicalName());
            if (!(value instanceof Boolean)) throw new EquationException("Result '" + value.toString() + "' is not a Boolean");
            node.booleanSetVal((Boolean)value);
        }
    }
}

