/*
 * Decompiled with CFR 0.152.
 */
package phic.gui;

import javax.swing.UIManager;
import phic.Current;
import phic.gui.FrameStub;
import phic.gui.PhicFrameSetup;
import phic.gui.TextIOFrame;

public class PhicApplication {
    public static FrameStub frame = null;
    private static final String physiologyFrameClass = "phic.gui.PhicFrameSetup";
    private static final String doctorFrameClass = "phic.doctor.DoctorFrame";
    private static String helpString = "PHIC Command Line Help\ndoctor             Runs in Doctor mode\ntext               Text-only console mode\nsetup [section]    Setup up the frame using the properties from the\n                   given section of the resource file 'FrameSetup.txt'\nSee the programming documentation for advanced help.\n";

    public static void main(String[] args) {
        try {
            UIManager.installLookAndFeel("Skin look and feel", "com.l2fprod.gui.plaf.skin.SkinLookAndFeel");
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!PhicApplication.listContains(args, "doctor") & !PhicApplication.listContains(args, "text")) {
            try {
                frame = (PhicFrameSetup)Class.forName(physiologyFrameClass).newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (PhicApplication.listContains(args, "text")) {
            frame = new TextIOFrame();
        }
        PhicApplication.processArguments(args);
        if (frame != null) {
            frame.show();
        }
    }

    private static boolean listContains(String[] list, Object item) {
        int i = 0;
        while (i < list.length) {
            if (list[i].equalsIgnoreCase((String)item)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static void processArguments(String[] args) {
        try {
            int i = 0;
            while (i < args.length) {
                if (!(args[i].equalsIgnoreCase("open") || args[i].equalsIgnoreCase("simple") || args[i].equalsIgnoreCase("graph"))) {
                    if (args[i].equalsIgnoreCase("doctor")) {
                        if (frame != null) {
                            frame.hide();
                        }
                        try {
                            Object df = Class.forName(doctorFrameClass).newInstance();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        Current.body.getClock().setSecond(1000.0);
                    } else if (!args[i].equalsIgnoreCase("blank")) {
                        if (args[i].equalsIgnoreCase("setup")) {
                            frame.doSetup("FrameSetup.txt", args[++i]);
                        } else if (!args[i].equalsIgnoreCase("text")) {
                            System.out.println(helpString);
                        }
                    }
                }
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException x) {
            System.out.println(helpString);
        }
        if (args.length == 0 && frame != null) {
            try {
                frame.doSetup("FrameSetup.txt", "Default");
            }
            catch (IllegalArgumentException e) {
                frame.message("Cannot find resources/FrameSetup.txt file with entry [Default]");
                e.printStackTrace();
                System.out.println("");
            }
        }
    }

    public static void markEvent(Object o) {
        if (frame != null) {
            frame.markEvent(o);
        }
    }
}

